/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudtrail.model.QueryParametersCopier;
import software.amazon.awssdk.services.cloudtrail.model.ViewPropertiesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Widget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Widget> {
    private static final SdkField<String> QUERY_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryAlias").getter(Widget.getter(Widget::queryAlias)).setter(Widget.setter(Builder::queryAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryAlias").build()}).build();
    private static final SdkField<String> QUERY_STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryStatement").getter(Widget.getter(Widget::queryStatement)).setter(Widget.setter(Builder::queryStatement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatement").build()}).build();
    private static final SdkField<List<String>> QUERY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueryParameters").getter(Widget.getter(Widget::queryParameters)).setter(Widget.setter(Builder::queryParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> VIEW_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ViewProperties").getter(Widget.getter(Widget::viewProperties)).setter(Widget.setter(Builder::viewProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ALIAS_FIELD, QUERY_STATEMENT_FIELD, QUERY_PARAMETERS_FIELD, VIEW_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Widget.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String queryAlias;
    private final String queryStatement;
    private final List<String> queryParameters;
    private final Map<String, String> viewProperties;

    private Widget(BuilderImpl builder) {
        this.queryAlias = builder.queryAlias;
        this.queryStatement = builder.queryStatement;
        this.queryParameters = builder.queryParameters;
        this.viewProperties = builder.viewProperties;
    }

    public final String queryAlias() {
        return this.queryAlias;
    }

    public final String queryStatement() {
        return this.queryStatement;
    }

    public final boolean hasQueryParameters() {
        return this.queryParameters != null && !(this.queryParameters instanceof SdkAutoConstructList);
    }

    public final List<String> queryParameters() {
        return this.queryParameters;
    }

    public final boolean hasViewProperties() {
        return this.viewProperties != null && !(this.viewProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> viewProperties() {
        return this.viewProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryParameters() ? this.queryParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasViewProperties() ? this.viewProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Widget)) {
            return false;
        }
        Widget other = (Widget)obj;
        return Objects.equals(this.queryAlias(), other.queryAlias()) && Objects.equals(this.queryStatement(), other.queryStatement()) && this.hasQueryParameters() == other.hasQueryParameters() && Objects.equals(this.queryParameters(), other.queryParameters()) && this.hasViewProperties() == other.hasViewProperties() && Objects.equals(this.viewProperties(), other.viewProperties());
    }

    public final String toString() {
        return ToString.builder((String)"Widget").add("QueryAlias", (Object)this.queryAlias()).add("QueryStatement", (Object)this.queryStatement()).add("QueryParameters", this.hasQueryParameters() ? this.queryParameters() : null).add("ViewProperties", this.hasViewProperties() ? this.viewProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryAlias": {
                return Optional.ofNullable(clazz.cast(this.queryAlias()));
            }
            case "QueryStatement": {
                return Optional.ofNullable(clazz.cast(this.queryStatement()));
            }
            case "QueryParameters": {
                return Optional.ofNullable(clazz.cast(this.queryParameters()));
            }
            case "ViewProperties": {
                return Optional.ofNullable(clazz.cast(this.viewProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("QueryAlias", QUERY_ALIAS_FIELD);
        map.put("QueryStatement", QUERY_STATEMENT_FIELD);
        map.put("QueryParameters", QUERY_PARAMETERS_FIELD);
        map.put("ViewProperties", VIEW_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Widget, T> g) {
        return obj -> g.apply((Widget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queryAlias;
        private String queryStatement;
        private List<String> queryParameters = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> viewProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Widget model) {
            this.queryAlias(model.queryAlias);
            this.queryStatement(model.queryStatement);
            this.queryParameters(model.queryParameters);
            this.viewProperties(model.viewProperties);
        }

        public final String getQueryAlias() {
            return this.queryAlias;
        }

        public final void setQueryAlias(String queryAlias) {
            this.queryAlias = queryAlias;
        }

        @Override
        public final Builder queryAlias(String queryAlias) {
            this.queryAlias = queryAlias;
            return this;
        }

        public final String getQueryStatement() {
            return this.queryStatement;
        }

        public final void setQueryStatement(String queryStatement) {
            this.queryStatement = queryStatement;
        }

        @Override
        public final Builder queryStatement(String queryStatement) {
            this.queryStatement = queryStatement;
            return this;
        }

        public final Collection<String> getQueryParameters() {
            if (this.queryParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queryParameters;
        }

        public final void setQueryParameters(Collection<String> queryParameters) {
            this.queryParameters = QueryParametersCopier.copy(queryParameters);
        }

        @Override
        public final Builder queryParameters(Collection<String> queryParameters) {
            this.queryParameters = QueryParametersCopier.copy(queryParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryParameters(String ... queryParameters) {
            this.queryParameters(Arrays.asList(queryParameters));
            return this;
        }

        public final Map<String, String> getViewProperties() {
            if (this.viewProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.viewProperties;
        }

        public final void setViewProperties(Map<String, String> viewProperties) {
            this.viewProperties = ViewPropertiesMapCopier.copy(viewProperties);
        }

        @Override
        public final Builder viewProperties(Map<String, String> viewProperties) {
            this.viewProperties = ViewPropertiesMapCopier.copy(viewProperties);
            return this;
        }

        public Widget build() {
            return new Widget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Widget> {
        public Builder queryAlias(String var1);

        public Builder queryStatement(String var1);

        public Builder queryParameters(Collection<String> var1);

        public Builder queryParameters(String ... var1);

        public Builder viewProperties(Map<String, String> var1);
    }
}

