/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDashboardRequest extends CloudTrailRequest implements
        ToCopyableBuilder<CreateDashboardRequest.Builder, CreateDashboardRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateDashboardRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<RefreshSchedule> REFRESH_SCHEDULE_FIELD = SdkField
            .<RefreshSchedule> builder(MarshallingType.SDK_POJO).memberName("RefreshSchedule")
            .getter(getter(CreateDashboardRequest::refreshSchedule)).setter(setter(Builder::refreshSchedule))
            .constructor(RefreshSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshSchedule").build()).build();

    private static final SdkField<List<Tag>> TAGS_LIST_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("TagsList")
            .getter(getter(CreateDashboardRequest::tagsList))
            .setter(setter(Builder::tagsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> TERMINATION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TerminationProtectionEnabled")
            .getter(getter(CreateDashboardRequest::terminationProtectionEnabled))
            .setter(setter(Builder::terminationProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationProtectionEnabled")
                    .build()).build();

    private static final SdkField<List<RequestWidget>> WIDGETS_FIELD = SdkField
            .<List<RequestWidget>> builder(MarshallingType.LIST)
            .memberName("Widgets")
            .getter(getter(CreateDashboardRequest::widgets))
            .setter(setter(Builder::widgets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Widgets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RequestWidget> builder(MarshallingType.SDK_POJO)
                                            .constructor(RequestWidget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            REFRESH_SCHEDULE_FIELD, TAGS_LIST_FIELD, TERMINATION_PROTECTION_ENABLED_FIELD, WIDGETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final RefreshSchedule refreshSchedule;

    private final List<Tag> tagsList;

    private final Boolean terminationProtectionEnabled;

    private final List<RequestWidget> widgets;

    private CreateDashboardRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.refreshSchedule = builder.refreshSchedule;
        this.tagsList = builder.tagsList;
        this.terminationProtectionEnabled = builder.terminationProtectionEnabled;
        this.widgets = builder.widgets;
    }

    /**
     * <p>
     * The name of the dashboard. The name must be unique to your account.
     * </p>
     * <p>
     * To create the Highlights dashboard, the name must be <code>AWSCloudTrail-Highlights</code>.
     * </p>
     * 
     * @return The name of the dashboard. The name must be unique to your account. </p>
     *         <p>
     *         To create the Highlights dashboard, the name must be <code>AWSCloudTrail-Highlights</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The refresh schedule configuration for the dashboard.
     * </p>
     * <p>
     * To create the Highlights dashboard, you must set a refresh schedule and set the <code>Status</code> to
     * <code>ENABLED</code>. The <code>Unit</code> for the refresh schedule must be <code>HOURS</code> and the
     * <code>Value</code> must be <code>6</code>.
     * </p>
     * 
     * @return The refresh schedule configuration for the dashboard. </p>
     *         <p>
     *         To create the Highlights dashboard, you must set a refresh schedule and set the <code>Status</code> to
     *         <code>ENABLED</code>. The <code>Unit</code> for the refresh schedule must be <code>HOURS</code> and the
     *         <code>Value</code> must be <code>6</code>.
     */
    public final RefreshSchedule refreshSchedule() {
        return refreshSchedule;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagsList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagsList() {
        return tagsList != null && !(tagsList instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the TagsList property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagsList} method.
     * </p>
     * 
     * @return The value of the TagsList property for this object.
     */
    public final List<Tag> tagsList() {
        return tagsList;
    }

    /**
     * <p>
     * Specifies whether termination protection is enabled for the dashboard. If termination protection is enabled, you
     * cannot delete the dashboard until termination protection is disabled.
     * </p>
     * 
     * @return Specifies whether termination protection is enabled for the dashboard. If termination protection is
     *         enabled, you cannot delete the dashboard until termination protection is disabled.
     */
    public final Boolean terminationProtectionEnabled() {
        return terminationProtectionEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the Widgets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWidgets() {
        return widgets != null && !(widgets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of widgets for a custom dashboard. A custom dashboard can have a maximum of ten widgets.
     * </p>
     * <p>
     * You do not need to specify widgets for the Highlights dashboard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWidgets} method.
     * </p>
     * 
     * @return An array of widgets for a custom dashboard. A custom dashboard can have a maximum of ten widgets. </p>
     *         <p>
     *         You do not need to specify widgets for the Highlights dashboard.
     */
    public final List<RequestWidget> widgets() {
        return widgets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(refreshSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagsList() ? tagsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(terminationProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasWidgets() ? widgets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDashboardRequest)) {
            return false;
        }
        CreateDashboardRequest other = (CreateDashboardRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(refreshSchedule(), other.refreshSchedule())
                && hasTagsList() == other.hasTagsList() && Objects.equals(tagsList(), other.tagsList())
                && Objects.equals(terminationProtectionEnabled(), other.terminationProtectionEnabled())
                && hasWidgets() == other.hasWidgets() && Objects.equals(widgets(), other.widgets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDashboardRequest").add("Name", name()).add("RefreshSchedule", refreshSchedule())
                .add("TagsList", hasTagsList() ? tagsList() : null)
                .add("TerminationProtectionEnabled", terminationProtectionEnabled())
                .add("Widgets", hasWidgets() ? widgets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RefreshSchedule":
            return Optional.ofNullable(clazz.cast(refreshSchedule()));
        case "TagsList":
            return Optional.ofNullable(clazz.cast(tagsList()));
        case "TerminationProtectionEnabled":
            return Optional.ofNullable(clazz.cast(terminationProtectionEnabled()));
        case "Widgets":
            return Optional.ofNullable(clazz.cast(widgets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("RefreshSchedule", REFRESH_SCHEDULE_FIELD);
        map.put("TagsList", TAGS_LIST_FIELD);
        map.put("TerminationProtectionEnabled", TERMINATION_PROTECTION_ENABLED_FIELD);
        map.put("Widgets", WIDGETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDashboardRequest, T> g) {
        return obj -> g.apply((CreateDashboardRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDashboardRequest> {
        /**
         * <p>
         * The name of the dashboard. The name must be unique to your account.
         * </p>
         * <p>
         * To create the Highlights dashboard, the name must be <code>AWSCloudTrail-Highlights</code>.
         * </p>
         * 
         * @param name
         *        The name of the dashboard. The name must be unique to your account. </p>
         *        <p>
         *        To create the Highlights dashboard, the name must be <code>AWSCloudTrail-Highlights</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The refresh schedule configuration for the dashboard.
         * </p>
         * <p>
         * To create the Highlights dashboard, you must set a refresh schedule and set the <code>Status</code> to
         * <code>ENABLED</code>. The <code>Unit</code> for the refresh schedule must be <code>HOURS</code> and the
         * <code>Value</code> must be <code>6</code>.
         * </p>
         * 
         * @param refreshSchedule
         *        The refresh schedule configuration for the dashboard. </p>
         *        <p>
         *        To create the Highlights dashboard, you must set a refresh schedule and set the <code>Status</code> to
         *        <code>ENABLED</code>. The <code>Unit</code> for the refresh schedule must be <code>HOURS</code> and
         *        the <code>Value</code> must be <code>6</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshSchedule(RefreshSchedule refreshSchedule);

        /**
         * <p>
         * The refresh schedule configuration for the dashboard.
         * </p>
         * <p>
         * To create the Highlights dashboard, you must set a refresh schedule and set the <code>Status</code> to
         * <code>ENABLED</code>. The <code>Unit</code> for the refresh schedule must be <code>HOURS</code> and the
         * <code>Value</code> must be <code>6</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RefreshSchedule.Builder} avoiding the
         * need to create one manually via {@link RefreshSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RefreshSchedule.Builder#build()} is called immediately and its
         * result is passed to {@link #refreshSchedule(RefreshSchedule)}.
         * 
         * @param refreshSchedule
         *        a consumer that will call methods on {@link RefreshSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #refreshSchedule(RefreshSchedule)
         */
        default Builder refreshSchedule(Consumer<RefreshSchedule.Builder> refreshSchedule) {
            return refreshSchedule(RefreshSchedule.builder().applyMutation(refreshSchedule).build());
        }

        /**
         * Sets the value of the TagsList property for this object.
         *
         * @param tagsList
         *        The new value for the TagsList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsList(Collection<Tag> tagsList);

        /**
         * Sets the value of the TagsList property for this object.
         *
         * @param tagsList
         *        The new value for the TagsList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsList(Tag... tagsList);

        /**
         * Sets the value of the TagsList property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtrail.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.cloudtrail.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtrail.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tagsList(List<Tag>)}.
         * 
         * @param tagsList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtrail.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagsList(java.util.Collection<Tag>)
         */
        Builder tagsList(Consumer<Tag.Builder>... tagsList);

        /**
         * <p>
         * Specifies whether termination protection is enabled for the dashboard. If termination protection is enabled,
         * you cannot delete the dashboard until termination protection is disabled.
         * </p>
         * 
         * @param terminationProtectionEnabled
         *        Specifies whether termination protection is enabled for the dashboard. If termination protection is
         *        enabled, you cannot delete the dashboard until termination protection is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled);

        /**
         * <p>
         * An array of widgets for a custom dashboard. A custom dashboard can have a maximum of ten widgets.
         * </p>
         * <p>
         * You do not need to specify widgets for the Highlights dashboard.
         * </p>
         * 
         * @param widgets
         *        An array of widgets for a custom dashboard. A custom dashboard can have a maximum of ten widgets. </p>
         *        <p>
         *        You do not need to specify widgets for the Highlights dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder widgets(Collection<RequestWidget> widgets);

        /**
         * <p>
         * An array of widgets for a custom dashboard. A custom dashboard can have a maximum of ten widgets.
         * </p>
         * <p>
         * You do not need to specify widgets for the Highlights dashboard.
         * </p>
         * 
         * @param widgets
         *        An array of widgets for a custom dashboard. A custom dashboard can have a maximum of ten widgets. </p>
         *        <p>
         *        You do not need to specify widgets for the Highlights dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder widgets(RequestWidget... widgets);

        /**
         * <p>
         * An array of widgets for a custom dashboard. A custom dashboard can have a maximum of ten widgets.
         * </p>
         * <p>
         * You do not need to specify widgets for the Highlights dashboard.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtrail.model.RequestWidget.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudtrail.model.RequestWidget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtrail.model.RequestWidget.Builder#build()} is called immediately
         * and its result is passed to {@link #widgets(List<RequestWidget>)}.
         * 
         * @param widgets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtrail.model.RequestWidget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #widgets(java.util.Collection<RequestWidget>)
         */
        Builder widgets(Consumer<RequestWidget.Builder>... widgets);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private String name;

        private RefreshSchedule refreshSchedule;

        private List<Tag> tagsList = DefaultSdkAutoConstructList.getInstance();

        private Boolean terminationProtectionEnabled;

        private List<RequestWidget> widgets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDashboardRequest model) {
            super(model);
            name(model.name);
            refreshSchedule(model.refreshSchedule);
            tagsList(model.tagsList);
            terminationProtectionEnabled(model.terminationProtectionEnabled);
            widgets(model.widgets);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RefreshSchedule.Builder getRefreshSchedule() {
            return refreshSchedule != null ? refreshSchedule.toBuilder() : null;
        }

        public final void setRefreshSchedule(RefreshSchedule.BuilderImpl refreshSchedule) {
            this.refreshSchedule = refreshSchedule != null ? refreshSchedule.build() : null;
        }

        @Override
        public final Builder refreshSchedule(RefreshSchedule refreshSchedule) {
            this.refreshSchedule = refreshSchedule;
            return this;
        }

        public final List<Tag.Builder> getTagsList() {
            List<Tag.Builder> result = TagsListCopier.copyToBuilder(this.tagsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagsList(Collection<Tag.BuilderImpl> tagsList) {
            this.tagsList = TagsListCopier.copyFromBuilder(tagsList);
        }

        @Override
        public final Builder tagsList(Collection<Tag> tagsList) {
            this.tagsList = TagsListCopier.copy(tagsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsList(Tag... tagsList) {
            tagsList(Arrays.asList(tagsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsList(Consumer<Tag.Builder>... tagsList) {
            tagsList(Stream.of(tagsList).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getTerminationProtectionEnabled() {
            return terminationProtectionEnabled;
        }

        public final void setTerminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
        }

        @Override
        public final Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        public final List<RequestWidget.Builder> getWidgets() {
            List<RequestWidget.Builder> result = RequestWidgetListCopier.copyToBuilder(this.widgets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWidgets(Collection<RequestWidget.BuilderImpl> widgets) {
            this.widgets = RequestWidgetListCopier.copyFromBuilder(widgets);
        }

        @Override
        public final Builder widgets(Collection<RequestWidget> widgets) {
            this.widgets = RequestWidgetListCopier.copy(widgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder widgets(RequestWidget... widgets) {
            widgets(Arrays.asList(widgets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder widgets(Consumer<RequestWidget.Builder>... widgets) {
            widgets(Stream.of(widgets).map(c -> RequestWidget.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDashboardRequest build() {
            return new CreateDashboardRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
