/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeQueryRequest extends CloudTrailRequest implements
        ToCopyableBuilder<DescribeQueryRequest.Builder, DescribeQueryRequest> {
    private static final SdkField<String> EVENT_DATA_STORE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventDataStore").getter(getter(DescribeQueryRequest::eventDataStore))
            .setter(setter(Builder::eventDataStore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStore").build()).build();

    private static final SdkField<String> QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryId").getter(getter(DescribeQueryRequest::queryId)).setter(setter(Builder::queryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()).build();

    private static final SdkField<String> QUERY_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryAlias").getter(getter(DescribeQueryRequest::queryAlias)).setter(setter(Builder::queryAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryAlias").build()).build();

    private static final SdkField<String> REFRESH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RefreshId").getter(getter(DescribeQueryRequest::refreshId)).setter(setter(Builder::refreshId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshId").build()).build();

    private static final SdkField<String> EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EventDataStoreOwnerAccountId")
            .getter(getter(DescribeQueryRequest::eventDataStoreOwnerAccountId))
            .setter(setter(Builder::eventDataStoreOwnerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStoreOwnerAccountId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORE_FIELD,
            QUERY_ID_FIELD, QUERY_ALIAS_FIELD, REFRESH_ID_FIELD, EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String eventDataStore;

    private final String queryId;

    private final String queryAlias;

    private final String refreshId;

    private final String eventDataStoreOwnerAccountId;

    private DescribeQueryRequest(BuilderImpl builder) {
        super(builder);
        this.eventDataStore = builder.eventDataStore;
        this.queryId = builder.queryId;
        this.queryAlias = builder.queryAlias;
        this.refreshId = builder.refreshId;
        this.eventDataStoreOwnerAccountId = builder.eventDataStoreOwnerAccountId;
    }

    /**
     * <p>
     * The ARN (or the ID suffix of the ARN) of an event data store on which the specified query was run.
     * </p>
     * 
     * @return The ARN (or the ID suffix of the ARN) of an event data store on which the specified query was run.
     * @deprecated EventDataStore is no longer required by DescribeQueryRequest
     */
    @Deprecated
    public final String eventDataStore() {
        return eventDataStore;
    }

    /**
     * <p>
     * The query ID.
     * </p>
     * 
     * @return The query ID.
     */
    public final String queryId() {
        return queryId;
    }

    /**
     * <p>
     * The alias that identifies a query template.
     * </p>
     * 
     * @return The alias that identifies a query template.
     */
    public final String queryAlias() {
        return queryAlias;
    }

    /**
     * <p>
     * The ID of the dashboard refresh.
     * </p>
     * 
     * @return The ID of the dashboard refresh.
     */
    public final String refreshId() {
        return refreshId;
    }

    /**
     * <p>
     * The account ID of the event data store owner.
     * </p>
     * 
     * @return The account ID of the event data store owner.
     */
    public final String eventDataStoreOwnerAccountId() {
        return eventDataStoreOwnerAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventDataStore());
        hashCode = 31 * hashCode + Objects.hashCode(queryId());
        hashCode = 31 * hashCode + Objects.hashCode(queryAlias());
        hashCode = 31 * hashCode + Objects.hashCode(refreshId());
        hashCode = 31 * hashCode + Objects.hashCode(eventDataStoreOwnerAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeQueryRequest)) {
            return false;
        }
        DescribeQueryRequest other = (DescribeQueryRequest) obj;
        return Objects.equals(eventDataStore(), other.eventDataStore()) && Objects.equals(queryId(), other.queryId())
                && Objects.equals(queryAlias(), other.queryAlias()) && Objects.equals(refreshId(), other.refreshId())
                && Objects.equals(eventDataStoreOwnerAccountId(), other.eventDataStoreOwnerAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeQueryRequest").add("EventDataStore", eventDataStore()).add("QueryId", queryId())
                .add("QueryAlias", queryAlias()).add("RefreshId", refreshId())
                .add("EventDataStoreOwnerAccountId", eventDataStoreOwnerAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventDataStore":
            return Optional.ofNullable(clazz.cast(eventDataStore()));
        case "QueryId":
            return Optional.ofNullable(clazz.cast(queryId()));
        case "QueryAlias":
            return Optional.ofNullable(clazz.cast(queryAlias()));
        case "RefreshId":
            return Optional.ofNullable(clazz.cast(refreshId()));
        case "EventDataStoreOwnerAccountId":
            return Optional.ofNullable(clazz.cast(eventDataStoreOwnerAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventDataStore", EVENT_DATA_STORE_FIELD);
        map.put("QueryId", QUERY_ID_FIELD);
        map.put("QueryAlias", QUERY_ALIAS_FIELD);
        map.put("RefreshId", REFRESH_ID_FIELD);
        map.put("EventDataStoreOwnerAccountId", EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeQueryRequest, T> g) {
        return obj -> g.apply((DescribeQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeQueryRequest> {
        /**
         * <p>
         * The ARN (or the ID suffix of the ARN) of an event data store on which the specified query was run.
         * </p>
         * 
         * @param eventDataStore
         *        The ARN (or the ID suffix of the ARN) of an event data store on which the specified query was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated EventDataStore is no longer required by DescribeQueryRequest
         */
        @Deprecated
        Builder eventDataStore(String eventDataStore);

        /**
         * <p>
         * The query ID.
         * </p>
         * 
         * @param queryId
         *        The query ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryId(String queryId);

        /**
         * <p>
         * The alias that identifies a query template.
         * </p>
         * 
         * @param queryAlias
         *        The alias that identifies a query template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryAlias(String queryAlias);

        /**
         * <p>
         * The ID of the dashboard refresh.
         * </p>
         * 
         * @param refreshId
         *        The ID of the dashboard refresh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshId(String refreshId);

        /**
         * <p>
         * The account ID of the event data store owner.
         * </p>
         * 
         * @param eventDataStoreOwnerAccountId
         *        The account ID of the event data store owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDataStoreOwnerAccountId(String eventDataStoreOwnerAccountId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private String eventDataStore;

        private String queryId;

        private String queryAlias;

        private String refreshId;

        private String eventDataStoreOwnerAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeQueryRequest model) {
            super(model);
            eventDataStore(model.eventDataStore);
            queryId(model.queryId);
            queryAlias(model.queryAlias);
            refreshId(model.refreshId);
            eventDataStoreOwnerAccountId(model.eventDataStoreOwnerAccountId);
        }

        @Deprecated
        public final String getEventDataStore() {
            return eventDataStore;
        }

        @Deprecated
        public final void setEventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
        }

        @Override
        @Deprecated
        public final Builder eventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
            return this;
        }

        public final String getQueryId() {
            return queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getQueryAlias() {
            return queryAlias;
        }

        public final void setQueryAlias(String queryAlias) {
            this.queryAlias = queryAlias;
        }

        @Override
        public final Builder queryAlias(String queryAlias) {
            this.queryAlias = queryAlias;
            return this;
        }

        public final String getRefreshId() {
            return refreshId;
        }

        public final void setRefreshId(String refreshId) {
            this.refreshId = refreshId;
        }

        @Override
        public final Builder refreshId(String refreshId) {
            this.refreshId = refreshId;
            return this;
        }

        public final String getEventDataStoreOwnerAccountId() {
            return eventDataStoreOwnerAccountId;
        }

        public final void setEventDataStoreOwnerAccountId(String eventDataStoreOwnerAccountId) {
            this.eventDataStoreOwnerAccountId = eventDataStoreOwnerAccountId;
        }

        @Override
        public final Builder eventDataStoreOwnerAccountId(String eventDataStoreOwnerAccountId) {
            this.eventDataStoreOwnerAccountId = eventDataStoreOwnerAccountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeQueryRequest build() {
            return new DescribeQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
