/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDashboardResponse extends CloudTrailResponse implements
        ToCopyableBuilder<GetDashboardResponse.Builder, GetDashboardResponse> {
    private static final SdkField<String> DASHBOARD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardArn").getter(getter(GetDashboardResponse::dashboardArn)).setter(setter(Builder::dashboardArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardArn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(GetDashboardResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetDashboardResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<Widget>> WIDGETS_FIELD = SdkField
            .<List<Widget>> builder(MarshallingType.LIST)
            .memberName("Widgets")
            .getter(getter(GetDashboardResponse::widgets))
            .setter(setter(Builder::widgets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Widgets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Widget> builder(MarshallingType.SDK_POJO)
                                            .constructor(Widget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RefreshSchedule> REFRESH_SCHEDULE_FIELD = SdkField
            .<RefreshSchedule> builder(MarshallingType.SDK_POJO).memberName("RefreshSchedule")
            .getter(getter(GetDashboardResponse::refreshSchedule)).setter(setter(Builder::refreshSchedule))
            .constructor(RefreshSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshSchedule").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(GetDashboardResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp").getter(getter(GetDashboardResponse::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build()).build();

    private static final SdkField<String> LAST_REFRESH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastRefreshId").getter(getter(GetDashboardResponse::lastRefreshId))
            .setter(setter(Builder::lastRefreshId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRefreshId").build()).build();

    private static final SdkField<String> LAST_REFRESH_FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastRefreshFailureReason").getter(getter(GetDashboardResponse::lastRefreshFailureReason))
            .setter(setter(Builder::lastRefreshFailureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRefreshFailureReason").build())
            .build();

    private static final SdkField<Boolean> TERMINATION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TerminationProtectionEnabled")
            .getter(getter(GetDashboardResponse::terminationProtectionEnabled))
            .setter(setter(Builder::terminationProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationProtectionEnabled")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ARN_FIELD,
            TYPE_FIELD, STATUS_FIELD, WIDGETS_FIELD, REFRESH_SCHEDULE_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD,
            LAST_REFRESH_ID_FIELD, LAST_REFRESH_FAILURE_REASON_FIELD, TERMINATION_PROTECTION_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dashboardArn;

    private final String type;

    private final String status;

    private final List<Widget> widgets;

    private final RefreshSchedule refreshSchedule;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private final String lastRefreshId;

    private final String lastRefreshFailureReason;

    private final Boolean terminationProtectionEnabled;

    private GetDashboardResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardArn = builder.dashboardArn;
        this.type = builder.type;
        this.status = builder.status;
        this.widgets = builder.widgets;
        this.refreshSchedule = builder.refreshSchedule;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
        this.lastRefreshId = builder.lastRefreshId;
        this.lastRefreshFailureReason = builder.lastRefreshFailureReason;
        this.terminationProtectionEnabled = builder.terminationProtectionEnabled;
    }

    /**
     * <p>
     * The ARN for the dashboard.
     * </p>
     * 
     * @return The ARN for the dashboard.
     */
    public final String dashboardArn() {
        return dashboardArn;
    }

    /**
     * <p>
     * The type of dashboard.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DashboardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of dashboard.
     * @see DashboardType
     */
    public final DashboardType type() {
        return DashboardType.fromValue(type);
    }

    /**
     * <p>
     * The type of dashboard.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DashboardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of dashboard.
     * @see DashboardType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The status of the dashboard.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DashboardStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the dashboard.
     * @see DashboardStatus
     */
    public final DashboardStatus status() {
        return DashboardStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the dashboard.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DashboardStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the dashboard.
     * @see DashboardStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Widgets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWidgets() {
        return widgets != null && !(widgets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of widgets for the dashboard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWidgets} method.
     * </p>
     * 
     * @return An array of widgets for the dashboard.
     */
    public final List<Widget> widgets() {
        return widgets;
    }

    /**
     * <p>
     * The refresh schedule for the dashboard, if configured.
     * </p>
     * 
     * @return The refresh schedule for the dashboard, if configured.
     */
    public final RefreshSchedule refreshSchedule() {
        return refreshSchedule;
    }

    /**
     * <p>
     * The timestamp that shows when the dashboard was created.
     * </p>
     * 
     * @return The timestamp that shows when the dashboard was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The timestamp that shows when the dashboard was last updated.
     * </p>
     * 
     * @return The timestamp that shows when the dashboard was last updated.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    /**
     * <p>
     * The ID of the last dashboard refresh.
     * </p>
     * 
     * @return The ID of the last dashboard refresh.
     */
    public final String lastRefreshId() {
        return lastRefreshId;
    }

    /**
     * <p>
     * Provides information about failures for the last scheduled refresh.
     * </p>
     * 
     * @return Provides information about failures for the last scheduled refresh.
     */
    public final String lastRefreshFailureReason() {
        return lastRefreshFailureReason;
    }

    /**
     * <p>
     * Indicates whether termination protection is enabled for the dashboard.
     * </p>
     * 
     * @return Indicates whether termination protection is enabled for the dashboard.
     */
    public final Boolean terminationProtectionEnabled() {
        return terminationProtectionEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dashboardArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasWidgets() ? widgets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(refreshSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastRefreshId());
        hashCode = 31 * hashCode + Objects.hashCode(lastRefreshFailureReason());
        hashCode = 31 * hashCode + Objects.hashCode(terminationProtectionEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDashboardResponse)) {
            return false;
        }
        GetDashboardResponse other = (GetDashboardResponse) obj;
        return Objects.equals(dashboardArn(), other.dashboardArn()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasWidgets() == other.hasWidgets()
                && Objects.equals(widgets(), other.widgets()) && Objects.equals(refreshSchedule(), other.refreshSchedule())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp())
                && Objects.equals(lastRefreshId(), other.lastRefreshId())
                && Objects.equals(lastRefreshFailureReason(), other.lastRefreshFailureReason())
                && Objects.equals(terminationProtectionEnabled(), other.terminationProtectionEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDashboardResponse").add("DashboardArn", dashboardArn()).add("Type", typeAsString())
                .add("Status", statusAsString()).add("Widgets", hasWidgets() ? widgets() : null)
                .add("RefreshSchedule", refreshSchedule()).add("CreatedTimestamp", createdTimestamp())
                .add("UpdatedTimestamp", updatedTimestamp()).add("LastRefreshId", lastRefreshId())
                .add("LastRefreshFailureReason", lastRefreshFailureReason())
                .add("TerminationProtectionEnabled", terminationProtectionEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardArn":
            return Optional.ofNullable(clazz.cast(dashboardArn()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Widgets":
            return Optional.ofNullable(clazz.cast(widgets()));
        case "RefreshSchedule":
            return Optional.ofNullable(clazz.cast(refreshSchedule()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        case "LastRefreshId":
            return Optional.ofNullable(clazz.cast(lastRefreshId()));
        case "LastRefreshFailureReason":
            return Optional.ofNullable(clazz.cast(lastRefreshFailureReason()));
        case "TerminationProtectionEnabled":
            return Optional.ofNullable(clazz.cast(terminationProtectionEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DashboardArn", DASHBOARD_ARN_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Widgets", WIDGETS_FIELD);
        map.put("RefreshSchedule", REFRESH_SCHEDULE_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        map.put("LastRefreshId", LAST_REFRESH_ID_FIELD);
        map.put("LastRefreshFailureReason", LAST_REFRESH_FAILURE_REASON_FIELD);
        map.put("TerminationProtectionEnabled", TERMINATION_PROTECTION_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDashboardResponse, T> g) {
        return obj -> g.apply((GetDashboardResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDashboardResponse> {
        /**
         * <p>
         * The ARN for the dashboard.
         * </p>
         * 
         * @param dashboardArn
         *        The ARN for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardArn(String dashboardArn);

        /**
         * <p>
         * The type of dashboard.
         * </p>
         * 
         * @param type
         *        The type of dashboard.
         * @see DashboardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashboardType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of dashboard.
         * </p>
         * 
         * @param type
         *        The type of dashboard.
         * @see DashboardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashboardType
         */
        Builder type(DashboardType type);

        /**
         * <p>
         * The status of the dashboard.
         * </p>
         * 
         * @param status
         *        The status of the dashboard.
         * @see DashboardStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashboardStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the dashboard.
         * </p>
         * 
         * @param status
         *        The status of the dashboard.
         * @see DashboardStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashboardStatus
         */
        Builder status(DashboardStatus status);

        /**
         * <p>
         * An array of widgets for the dashboard.
         * </p>
         * 
         * @param widgets
         *        An array of widgets for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder widgets(Collection<Widget> widgets);

        /**
         * <p>
         * An array of widgets for the dashboard.
         * </p>
         * 
         * @param widgets
         *        An array of widgets for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder widgets(Widget... widgets);

        /**
         * <p>
         * An array of widgets for the dashboard.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtrail.model.Widget.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cloudtrail.model.Widget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtrail.model.Widget.Builder#build()} is called immediately and its
         * result is passed to {@link #widgets(List<Widget>)}.
         * 
         * @param widgets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtrail.model.Widget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #widgets(java.util.Collection<Widget>)
         */
        Builder widgets(Consumer<Widget.Builder>... widgets);

        /**
         * <p>
         * The refresh schedule for the dashboard, if configured.
         * </p>
         * 
         * @param refreshSchedule
         *        The refresh schedule for the dashboard, if configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshSchedule(RefreshSchedule refreshSchedule);

        /**
         * <p>
         * The refresh schedule for the dashboard, if configured.
         * </p>
         * This is a convenience method that creates an instance of the {@link RefreshSchedule.Builder} avoiding the
         * need to create one manually via {@link RefreshSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RefreshSchedule.Builder#build()} is called immediately and its
         * result is passed to {@link #refreshSchedule(RefreshSchedule)}.
         * 
         * @param refreshSchedule
         *        a consumer that will call methods on {@link RefreshSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #refreshSchedule(RefreshSchedule)
         */
        default Builder refreshSchedule(Consumer<RefreshSchedule.Builder> refreshSchedule) {
            return refreshSchedule(RefreshSchedule.builder().applyMutation(refreshSchedule).build());
        }

        /**
         * <p>
         * The timestamp that shows when the dashboard was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp that shows when the dashboard was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The timestamp that shows when the dashboard was last updated.
         * </p>
         * 
         * @param updatedTimestamp
         *        The timestamp that shows when the dashboard was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);

        /**
         * <p>
         * The ID of the last dashboard refresh.
         * </p>
         * 
         * @param lastRefreshId
         *        The ID of the last dashboard refresh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRefreshId(String lastRefreshId);

        /**
         * <p>
         * Provides information about failures for the last scheduled refresh.
         * </p>
         * 
         * @param lastRefreshFailureReason
         *        Provides information about failures for the last scheduled refresh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRefreshFailureReason(String lastRefreshFailureReason);

        /**
         * <p>
         * Indicates whether termination protection is enabled for the dashboard.
         * </p>
         * 
         * @param terminationProtectionEnabled
         *        Indicates whether termination protection is enabled for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private String dashboardArn;

        private String type;

        private String status;

        private List<Widget> widgets = DefaultSdkAutoConstructList.getInstance();

        private RefreshSchedule refreshSchedule;

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private String lastRefreshId;

        private String lastRefreshFailureReason;

        private Boolean terminationProtectionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDashboardResponse model) {
            super(model);
            dashboardArn(model.dashboardArn);
            type(model.type);
            status(model.status);
            widgets(model.widgets);
            refreshSchedule(model.refreshSchedule);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
            lastRefreshId(model.lastRefreshId);
            lastRefreshFailureReason(model.lastRefreshFailureReason);
            terminationProtectionEnabled(model.terminationProtectionEnabled);
        }

        public final String getDashboardArn() {
            return dashboardArn;
        }

        public final void setDashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
        }

        @Override
        public final Builder dashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DashboardType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DashboardStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<Widget.Builder> getWidgets() {
            List<Widget.Builder> result = WidgetListCopier.copyToBuilder(this.widgets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWidgets(Collection<Widget.BuilderImpl> widgets) {
            this.widgets = WidgetListCopier.copyFromBuilder(widgets);
        }

        @Override
        public final Builder widgets(Collection<Widget> widgets) {
            this.widgets = WidgetListCopier.copy(widgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder widgets(Widget... widgets) {
            widgets(Arrays.asList(widgets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder widgets(Consumer<Widget.Builder>... widgets) {
            widgets(Stream.of(widgets).map(c -> Widget.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final RefreshSchedule.Builder getRefreshSchedule() {
            return refreshSchedule != null ? refreshSchedule.toBuilder() : null;
        }

        public final void setRefreshSchedule(RefreshSchedule.BuilderImpl refreshSchedule) {
            this.refreshSchedule = refreshSchedule != null ? refreshSchedule.build() : null;
        }

        @Override
        public final Builder refreshSchedule(RefreshSchedule refreshSchedule) {
            this.refreshSchedule = refreshSchedule;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final String getLastRefreshId() {
            return lastRefreshId;
        }

        public final void setLastRefreshId(String lastRefreshId) {
            this.lastRefreshId = lastRefreshId;
        }

        @Override
        public final Builder lastRefreshId(String lastRefreshId) {
            this.lastRefreshId = lastRefreshId;
            return this;
        }

        public final String getLastRefreshFailureReason() {
            return lastRefreshFailureReason;
        }

        public final void setLastRefreshFailureReason(String lastRefreshFailureReason) {
            this.lastRefreshFailureReason = lastRefreshFailureReason;
        }

        @Override
        public final Builder lastRefreshFailureReason(String lastRefreshFailureReason) {
            this.lastRefreshFailureReason = lastRefreshFailureReason;
            return this;
        }

        public final Boolean getTerminationProtectionEnabled() {
            return terminationProtectionEnabled;
        }

        public final void setTerminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
        }

        @Override
        public final Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        @Override
        public GetDashboardResponse build() {
            return new GetDashboardResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
