/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEventConfigurationResponse extends CloudTrailResponse implements
        ToCopyableBuilder<GetEventConfigurationResponse.Builder, GetEventConfigurationResponse> {
    private static final SdkField<String> EVENT_DATA_STORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventDataStoreArn").getter(getter(GetEventConfigurationResponse::eventDataStoreArn))
            .setter(setter(Builder::eventDataStoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStoreArn").build()).build();

    private static final SdkField<String> MAX_EVENT_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxEventSize").getter(getter(GetEventConfigurationResponse::maxEventSizeAsString))
            .setter(setter(Builder::maxEventSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxEventSize").build()).build();

    private static final SdkField<List<ContextKeySelector>> CONTEXT_KEY_SELECTORS_FIELD = SdkField
            .<List<ContextKeySelector>> builder(MarshallingType.LIST)
            .memberName("ContextKeySelectors")
            .getter(getter(GetEventConfigurationResponse::contextKeySelectors))
            .setter(setter(Builder::contextKeySelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextKeySelectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContextKeySelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContextKeySelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORE_ARN_FIELD,
            MAX_EVENT_SIZE_FIELD, CONTEXT_KEY_SELECTORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String eventDataStoreArn;

    private final String maxEventSize;

    private final List<ContextKeySelector> contextKeySelectors;

    private GetEventConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.eventDataStoreArn = builder.eventDataStoreArn;
        this.maxEventSize = builder.maxEventSize;
        this.contextKeySelectors = builder.contextKeySelectors;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or ID suffix of the ARN of the event data store for which the event configuration
     * settings are returned.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or ID suffix of the ARN of the event data store for which the event
     *         configuration settings are returned.
     */
    public final String eventDataStoreArn() {
        return eventDataStoreArn;
    }

    /**
     * <p>
     * The maximum allowed size for events stored in the specified event data store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maxEventSize} will
     * return {@link MaxEventSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #maxEventSizeAsString}.
     * </p>
     * 
     * @return The maximum allowed size for events stored in the specified event data store.
     * @see MaxEventSize
     */
    public final MaxEventSize maxEventSize() {
        return MaxEventSize.fromValue(maxEventSize);
    }

    /**
     * <p>
     * The maximum allowed size for events stored in the specified event data store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maxEventSize} will
     * return {@link MaxEventSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #maxEventSizeAsString}.
     * </p>
     * 
     * @return The maximum allowed size for events stored in the specified event data store.
     * @see MaxEventSize
     */
    public final String maxEventSizeAsString() {
        return maxEventSize;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContextKeySelectors property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContextKeySelectors() {
        return contextKeySelectors != null && !(contextKeySelectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of context key selectors that are configured for the event data store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContextKeySelectors} method.
     * </p>
     * 
     * @return The list of context key selectors that are configured for the event data store.
     */
    public final List<ContextKeySelector> contextKeySelectors() {
        return contextKeySelectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventDataStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxEventSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasContextKeySelectors() ? contextKeySelectors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventConfigurationResponse)) {
            return false;
        }
        GetEventConfigurationResponse other = (GetEventConfigurationResponse) obj;
        return Objects.equals(eventDataStoreArn(), other.eventDataStoreArn())
                && Objects.equals(maxEventSizeAsString(), other.maxEventSizeAsString())
                && hasContextKeySelectors() == other.hasContextKeySelectors()
                && Objects.equals(contextKeySelectors(), other.contextKeySelectors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEventConfigurationResponse").add("EventDataStoreArn", eventDataStoreArn())
                .add("MaxEventSize", maxEventSizeAsString())
                .add("ContextKeySelectors", hasContextKeySelectors() ? contextKeySelectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventDataStoreArn":
            return Optional.ofNullable(clazz.cast(eventDataStoreArn()));
        case "MaxEventSize":
            return Optional.ofNullable(clazz.cast(maxEventSizeAsString()));
        case "ContextKeySelectors":
            return Optional.ofNullable(clazz.cast(contextKeySelectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventDataStoreArn", EVENT_DATA_STORE_ARN_FIELD);
        map.put("MaxEventSize", MAX_EVENT_SIZE_FIELD);
        map.put("ContextKeySelectors", CONTEXT_KEY_SELECTORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEventConfigurationResponse, T> g) {
        return obj -> g.apply((GetEventConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetEventConfigurationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) or ID suffix of the ARN of the event data store for which the event
         * configuration settings are returned.
         * </p>
         * 
         * @param eventDataStoreArn
         *        The Amazon Resource Name (ARN) or ID suffix of the ARN of the event data store for which the event
         *        configuration settings are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDataStoreArn(String eventDataStoreArn);

        /**
         * <p>
         * The maximum allowed size for events stored in the specified event data store.
         * </p>
         * 
         * @param maxEventSize
         *        The maximum allowed size for events stored in the specified event data store.
         * @see MaxEventSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaxEventSize
         */
        Builder maxEventSize(String maxEventSize);

        /**
         * <p>
         * The maximum allowed size for events stored in the specified event data store.
         * </p>
         * 
         * @param maxEventSize
         *        The maximum allowed size for events stored in the specified event data store.
         * @see MaxEventSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaxEventSize
         */
        Builder maxEventSize(MaxEventSize maxEventSize);

        /**
         * <p>
         * The list of context key selectors that are configured for the event data store.
         * </p>
         * 
         * @param contextKeySelectors
         *        The list of context key selectors that are configured for the event data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextKeySelectors(Collection<ContextKeySelector> contextKeySelectors);

        /**
         * <p>
         * The list of context key selectors that are configured for the event data store.
         * </p>
         * 
         * @param contextKeySelectors
         *        The list of context key selectors that are configured for the event data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextKeySelectors(ContextKeySelector... contextKeySelectors);

        /**
         * <p>
         * The list of context key selectors that are configured for the event data store.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtrail.model.ContextKeySelector.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.cloudtrail.model.ContextKeySelector#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtrail.model.ContextKeySelector.Builder#build()} is called
         * immediately and its result is passed to {@link #contextKeySelectors(List<ContextKeySelector>)}.
         * 
         * @param contextKeySelectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtrail.model.ContextKeySelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contextKeySelectors(java.util.Collection<ContextKeySelector>)
         */
        Builder contextKeySelectors(Consumer<ContextKeySelector.Builder>... contextKeySelectors);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private String eventDataStoreArn;

        private String maxEventSize;

        private List<ContextKeySelector> contextKeySelectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventConfigurationResponse model) {
            super(model);
            eventDataStoreArn(model.eventDataStoreArn);
            maxEventSize(model.maxEventSize);
            contextKeySelectors(model.contextKeySelectors);
        }

        public final String getEventDataStoreArn() {
            return eventDataStoreArn;
        }

        public final void setEventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
        }

        @Override
        public final Builder eventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
            return this;
        }

        public final String getMaxEventSize() {
            return maxEventSize;
        }

        public final void setMaxEventSize(String maxEventSize) {
            this.maxEventSize = maxEventSize;
        }

        @Override
        public final Builder maxEventSize(String maxEventSize) {
            this.maxEventSize = maxEventSize;
            return this;
        }

        @Override
        public final Builder maxEventSize(MaxEventSize maxEventSize) {
            this.maxEventSize(maxEventSize == null ? null : maxEventSize.toString());
            return this;
        }

        public final List<ContextKeySelector.Builder> getContextKeySelectors() {
            List<ContextKeySelector.Builder> result = ContextKeySelectorsCopier.copyToBuilder(this.contextKeySelectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContextKeySelectors(Collection<ContextKeySelector.BuilderImpl> contextKeySelectors) {
            this.contextKeySelectors = ContextKeySelectorsCopier.copyFromBuilder(contextKeySelectors);
        }

        @Override
        public final Builder contextKeySelectors(Collection<ContextKeySelector> contextKeySelectors) {
            this.contextKeySelectors = ContextKeySelectorsCopier.copy(contextKeySelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextKeySelectors(ContextKeySelector... contextKeySelectors) {
            contextKeySelectors(Arrays.asList(contextKeySelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextKeySelectors(Consumer<ContextKeySelector.Builder>... contextKeySelectors) {
            contextKeySelectors(Stream.of(contextKeySelectors).map(c -> ContextKeySelector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetEventConfigurationResponse build() {
            return new GetEventConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
