/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON string that contains a list of Insights types that are logged on a trail or event data store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InsightSelector implements SdkPojo, Serializable, ToCopyableBuilder<InsightSelector.Builder, InsightSelector> {
    private static final SdkField<String> INSIGHT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InsightType").getter(getter(InsightSelector::insightTypeAsString)).setter(setter(Builder::insightType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String insightType;

    private InsightSelector(BuilderImpl builder) {
        this.insightType = builder.insightType;
    }

    /**
     * <p>
     * The type of Insights events to log on a trail or event data store. <code>ApiCallRateInsight</code> and
     * <code>ApiErrorRateInsight</code> are valid Insight types.
     * </p>
     * <p>
     * The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are aggregated
     * per minute against a baseline API call volume.
     * </p>
     * <p>
     * The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes. The
     * error is shown if the API call is unsuccessful.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #insightType} will
     * return {@link InsightType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #insightTypeAsString}.
     * </p>
     * 
     * @return The type of Insights events to log on a trail or event data store. <code>ApiCallRateInsight</code> and
     *         <code>ApiErrorRateInsight</code> are valid Insight types.</p>
     *         <p>
     *         The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are
     *         aggregated per minute against a baseline API call volume.
     *         </p>
     *         <p>
     *         The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error
     *         codes. The error is shown if the API call is unsuccessful.
     * @see InsightType
     */
    public final InsightType insightType() {
        return InsightType.fromValue(insightType);
    }

    /**
     * <p>
     * The type of Insights events to log on a trail or event data store. <code>ApiCallRateInsight</code> and
     * <code>ApiErrorRateInsight</code> are valid Insight types.
     * </p>
     * <p>
     * The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are aggregated
     * per minute against a baseline API call volume.
     * </p>
     * <p>
     * The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes. The
     * error is shown if the API call is unsuccessful.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #insightType} will
     * return {@link InsightType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #insightTypeAsString}.
     * </p>
     * 
     * @return The type of Insights events to log on a trail or event data store. <code>ApiCallRateInsight</code> and
     *         <code>ApiErrorRateInsight</code> are valid Insight types.</p>
     *         <p>
     *         The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are
     *         aggregated per minute against a baseline API call volume.
     *         </p>
     *         <p>
     *         The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error
     *         codes. The error is shown if the API call is unsuccessful.
     * @see InsightType
     */
    public final String insightTypeAsString() {
        return insightType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(insightTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightSelector)) {
            return false;
        }
        InsightSelector other = (InsightSelector) obj;
        return Objects.equals(insightTypeAsString(), other.insightTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InsightSelector").add("InsightType", insightTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InsightType":
            return Optional.ofNullable(clazz.cast(insightTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InsightType", INSIGHT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InsightSelector, T> g) {
        return obj -> g.apply((InsightSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InsightSelector> {
        /**
         * <p>
         * The type of Insights events to log on a trail or event data store. <code>ApiCallRateInsight</code> and
         * <code>ApiErrorRateInsight</code> are valid Insight types.
         * </p>
         * <p>
         * The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are
         * aggregated per minute against a baseline API call volume.
         * </p>
         * <p>
         * The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes.
         * The error is shown if the API call is unsuccessful.
         * </p>
         * 
         * @param insightType
         *        The type of Insights events to log on a trail or event data store. <code>ApiCallRateInsight</code> and
         *        <code>ApiErrorRateInsight</code> are valid Insight types.</p>
         *        <p>
         *        The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are
         *        aggregated per minute against a baseline API call volume.
         *        </p>
         *        <p>
         *        The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error
         *        codes. The error is shown if the API call is unsuccessful.
         * @see InsightType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightType
         */
        Builder insightType(String insightType);

        /**
         * <p>
         * The type of Insights events to log on a trail or event data store. <code>ApiCallRateInsight</code> and
         * <code>ApiErrorRateInsight</code> are valid Insight types.
         * </p>
         * <p>
         * The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are
         * aggregated per minute against a baseline API call volume.
         * </p>
         * <p>
         * The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes.
         * The error is shown if the API call is unsuccessful.
         * </p>
         * 
         * @param insightType
         *        The type of Insights events to log on a trail or event data store. <code>ApiCallRateInsight</code> and
         *        <code>ApiErrorRateInsight</code> are valid Insight types.</p>
         *        <p>
         *        The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are
         *        aggregated per minute against a baseline API call volume.
         *        </p>
         *        <p>
         *        The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error
         *        codes. The error is shown if the API call is unsuccessful.
         * @see InsightType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightType
         */
        Builder insightType(InsightType insightType);
    }

    static final class BuilderImpl implements Builder {
        private String insightType;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightSelector model) {
            insightType(model.insightType);
        }

        public final String getInsightType() {
            return insightType;
        }

        public final void setInsightType(String insightType) {
            this.insightType = insightType;
        }

        @Override
        public final Builder insightType(String insightType) {
            this.insightType = insightType;
            return this;
        }

        @Override
        public final Builder insightType(InsightType insightType) {
            this.insightType(insightType == null ? null : insightType.toString());
            return this;
        }

        @Override
        public InsightSelector build() {
            return new InsightSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
