/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListImportsResponse extends CloudTrailResponse implements
        ToCopyableBuilder<ListImportsResponse.Builder, ListImportsResponse> {
    private static final SdkField<List<ImportsListItem>> IMPORTS_FIELD = SdkField
            .<List<ImportsListItem>> builder(MarshallingType.LIST)
            .memberName("Imports")
            .getter(getter(ListImportsResponse::imports))
            .setter(setter(Builder::imports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Imports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImportsListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportsListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListImportsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ImportsListItem> imports;

    private final String nextToken;

    private ListImportsResponse(BuilderImpl builder) {
        super(builder);
        this.imports = builder.imports;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Imports property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasImports() {
        return imports != null && !(imports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of returned imports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImports} method.
     * </p>
     * 
     * @return The list of returned imports.
     */
    public final List<ImportsListItem> imports() {
        return imports;
    }

    /**
     * <p>
     * A token you can use to get the next page of import results.
     * </p>
     * 
     * @return A token you can use to get the next page of import results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImports() ? imports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImportsResponse)) {
            return false;
        }
        ListImportsResponse other = (ListImportsResponse) obj;
        return hasImports() == other.hasImports() && Objects.equals(imports(), other.imports())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListImportsResponse").add("Imports", hasImports() ? imports() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Imports":
            return Optional.ofNullable(clazz.cast(imports()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Imports", IMPORTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListImportsResponse, T> g) {
        return obj -> g.apply((ListImportsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListImportsResponse> {
        /**
         * <p>
         * The list of returned imports.
         * </p>
         * 
         * @param imports
         *        The list of returned imports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imports(Collection<ImportsListItem> imports);

        /**
         * <p>
         * The list of returned imports.
         * </p>
         * 
         * @param imports
         *        The list of returned imports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imports(ImportsListItem... imports);

        /**
         * <p>
         * The list of returned imports.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtrail.model.ImportsListItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudtrail.model.ImportsListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtrail.model.ImportsListItem.Builder#build()} is called
         * immediately and its result is passed to {@link #imports(List<ImportsListItem>)}.
         * 
         * @param imports
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtrail.model.ImportsListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imports(java.util.Collection<ImportsListItem>)
         */
        Builder imports(Consumer<ImportsListItem.Builder>... imports);

        /**
         * <p>
         * A token you can use to get the next page of import results.
         * </p>
         * 
         * @param nextToken
         *        A token you can use to get the next page of import results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private List<ImportsListItem> imports = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImportsResponse model) {
            super(model);
            imports(model.imports);
            nextToken(model.nextToken);
        }

        public final List<ImportsListItem.Builder> getImports() {
            List<ImportsListItem.Builder> result = ImportsListCopier.copyToBuilder(this.imports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImports(Collection<ImportsListItem.BuilderImpl> imports) {
            this.imports = ImportsListCopier.copyFromBuilder(imports);
        }

        @Override
        public final Builder imports(Collection<ImportsListItem> imports) {
            this.imports = ImportsListCopier.copy(imports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imports(ImportsListItem... imports) {
            imports(Arrays.asList(imports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imports(Consumer<ImportsListItem.Builder>... imports) {
            imports(Stream.of(imports).map(c -> ImportsListItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListImportsResponse build() {
            return new ListImportsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
