/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A SQL string of criteria about events that you want to collect in an event data store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Query implements SdkPojo, Serializable, ToCopyableBuilder<Query.Builder, Query> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryId").getter(getter(Query::queryId)).setter(setter(Builder::queryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()).build();

    private static final SdkField<String> QUERY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryStatus").getter(getter(Query::queryStatusAsString)).setter(setter(Builder::queryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatus").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(Query::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD,
            QUERY_STATUS_FIELD, CREATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String queryId;

    private final String queryStatus;

    private final Instant creationTime;

    private Query(BuilderImpl builder) {
        this.queryId = builder.queryId;
        this.queryStatus = builder.queryStatus;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The ID of a query.
     * </p>
     * 
     * @return The ID of a query.
     */
    public final String queryId() {
        return queryId;
    }

    /**
     * <p>
     * The status of the query. This can be <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>,
     * <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryStatus} will
     * return {@link QueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryStatusAsString}.
     * </p>
     * 
     * @return The status of the query. This can be <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>,
     *         <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.
     * @see QueryStatus
     */
    public final QueryStatus queryStatus() {
        return QueryStatus.fromValue(queryStatus);
    }

    /**
     * <p>
     * The status of the query. This can be <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>,
     * <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryStatus} will
     * return {@link QueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryStatusAsString}.
     * </p>
     * 
     * @return The status of the query. This can be <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>,
     *         <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.
     * @see QueryStatus
     */
    public final String queryStatusAsString() {
        return queryStatus;
    }

    /**
     * <p>
     * The creation time of a query.
     * </p>
     * 
     * @return The creation time of a query.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryId());
        hashCode = 31 * hashCode + Objects.hashCode(queryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Query)) {
            return false;
        }
        Query other = (Query) obj;
        return Objects.equals(queryId(), other.queryId()) && Objects.equals(queryStatusAsString(), other.queryStatusAsString())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Query").add("QueryId", queryId()).add("QueryStatus", queryStatusAsString())
                .add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryId":
            return Optional.ofNullable(clazz.cast(queryId()));
        case "QueryStatus":
            return Optional.ofNullable(clazz.cast(queryStatusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QueryId", QUERY_ID_FIELD);
        map.put("QueryStatus", QUERY_STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Query, T> g) {
        return obj -> g.apply((Query) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Query> {
        /**
         * <p>
         * The ID of a query.
         * </p>
         * 
         * @param queryId
         *        The ID of a query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryId(String queryId);

        /**
         * <p>
         * The status of the query. This can be <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>,
         * <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.
         * </p>
         * 
         * @param queryStatus
         *        The status of the query. This can be <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>,
         *        <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.
         * @see QueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryStatus
         */
        Builder queryStatus(String queryStatus);

        /**
         * <p>
         * The status of the query. This can be <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>,
         * <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.
         * </p>
         * 
         * @param queryStatus
         *        The status of the query. This can be <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>,
         *        <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.
         * @see QueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryStatus
         */
        Builder queryStatus(QueryStatus queryStatus);

        /**
         * <p>
         * The creation time of a query.
         * </p>
         * 
         * @param creationTime
         *        The creation time of a query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String queryId;

        private String queryStatus;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Query model) {
            queryId(model.queryId);
            queryStatus(model.queryStatus);
            creationTime(model.creationTime);
        }

        public final String getQueryId() {
            return queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getQueryStatus() {
            return queryStatus;
        }

        public final void setQueryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
        }

        @Override
        public final Builder queryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
            return this;
        }

        @Override
        public final Builder queryStatus(QueryStatus queryStatus) {
            this.queryStatus(queryStatus == null ? null : queryStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public Query build() {
            return new Query(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
