/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings for the source S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ImportSource implements SdkPojo, Serializable, ToCopyableBuilder<S3ImportSource.Builder, S3ImportSource> {
    private static final SdkField<String> S3_LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3LocationUri").getter(getter(S3ImportSource::s3LocationUri)).setter(setter(Builder::s3LocationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3LocationUri").build()).build();

    private static final SdkField<String> S3_BUCKET_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketRegion").getter(getter(S3ImportSource::s3BucketRegion)).setter(setter(Builder::s3BucketRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketRegion").build()).build();

    private static final SdkField<String> S3_BUCKET_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketAccessRoleArn").getter(getter(S3ImportSource::s3BucketAccessRoleArn))
            .setter(setter(Builder::s3BucketAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketAccessRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_LOCATION_URI_FIELD,
            S3_BUCKET_REGION_FIELD, S3_BUCKET_ACCESS_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String s3LocationUri;

    private final String s3BucketRegion;

    private final String s3BucketAccessRoleArn;

    private S3ImportSource(BuilderImpl builder) {
        this.s3LocationUri = builder.s3LocationUri;
        this.s3BucketRegion = builder.s3BucketRegion;
        this.s3BucketAccessRoleArn = builder.s3BucketAccessRoleArn;
    }

    /**
     * <p>
     * The URI for the source S3 bucket.
     * </p>
     * 
     * @return The URI for the source S3 bucket.
     */
    public final String s3LocationUri() {
        return s3LocationUri;
    }

    /**
     * <p>
     * The Region associated with the source S3 bucket.
     * </p>
     * 
     * @return The Region associated with the source S3 bucket.
     */
    public final String s3BucketRegion() {
        return s3BucketRegion;
    }

    /**
     * <p>
     * The IAM ARN role used to access the source S3 bucket.
     * </p>
     * 
     * @return The IAM ARN role used to access the source S3 bucket.
     */
    public final String s3BucketAccessRoleArn() {
        return s3BucketAccessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3LocationUri());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketRegion());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketAccessRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ImportSource)) {
            return false;
        }
        S3ImportSource other = (S3ImportSource) obj;
        return Objects.equals(s3LocationUri(), other.s3LocationUri()) && Objects.equals(s3BucketRegion(), other.s3BucketRegion())
                && Objects.equals(s3BucketAccessRoleArn(), other.s3BucketAccessRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3ImportSource").add("S3LocationUri", s3LocationUri()).add("S3BucketRegion", s3BucketRegion())
                .add("S3BucketAccessRoleArn", s3BucketAccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3LocationUri":
            return Optional.ofNullable(clazz.cast(s3LocationUri()));
        case "S3BucketRegion":
            return Optional.ofNullable(clazz.cast(s3BucketRegion()));
        case "S3BucketAccessRoleArn":
            return Optional.ofNullable(clazz.cast(s3BucketAccessRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3LocationUri", S3_LOCATION_URI_FIELD);
        map.put("S3BucketRegion", S3_BUCKET_REGION_FIELD);
        map.put("S3BucketAccessRoleArn", S3_BUCKET_ACCESS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ImportSource, T> g) {
        return obj -> g.apply((S3ImportSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ImportSource> {
        /**
         * <p>
         * The URI for the source S3 bucket.
         * </p>
         * 
         * @param s3LocationUri
         *        The URI for the source S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3LocationUri(String s3LocationUri);

        /**
         * <p>
         * The Region associated with the source S3 bucket.
         * </p>
         * 
         * @param s3BucketRegion
         *        The Region associated with the source S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketRegion(String s3BucketRegion);

        /**
         * <p>
         * The IAM ARN role used to access the source S3 bucket.
         * </p>
         * 
         * @param s3BucketAccessRoleArn
         *        The IAM ARN role used to access the source S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketAccessRoleArn(String s3BucketAccessRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String s3LocationUri;

        private String s3BucketRegion;

        private String s3BucketAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ImportSource model) {
            s3LocationUri(model.s3LocationUri);
            s3BucketRegion(model.s3BucketRegion);
            s3BucketAccessRoleArn(model.s3BucketAccessRoleArn);
        }

        public final String getS3LocationUri() {
            return s3LocationUri;
        }

        public final void setS3LocationUri(String s3LocationUri) {
            this.s3LocationUri = s3LocationUri;
        }

        @Override
        public final Builder s3LocationUri(String s3LocationUri) {
            this.s3LocationUri = s3LocationUri;
            return this;
        }

        public final String getS3BucketRegion() {
            return s3BucketRegion;
        }

        public final void setS3BucketRegion(String s3BucketRegion) {
            this.s3BucketRegion = s3BucketRegion;
        }

        @Override
        public final Builder s3BucketRegion(String s3BucketRegion) {
            this.s3BucketRegion = s3BucketRegion;
            return this;
        }

        public final String getS3BucketAccessRoleArn() {
            return s3BucketAccessRoleArn;
        }

        public final void setS3BucketAccessRoleArn(String s3BucketAccessRoleArn) {
            this.s3BucketAccessRoleArn = s3BucketAccessRoleArn;
        }

        @Override
        public final Builder s3BucketAccessRoleArn(String s3BucketAccessRoleArn) {
            this.s3BucketAccessRoleArn = s3BucketAccessRoleArn;
            return this;
        }

        @Override
        public S3ImportSource build() {
            return new S3ImportSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
