/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDashboardRefreshRequest extends CloudTrailRequest implements
        ToCopyableBuilder<StartDashboardRefreshRequest.Builder, StartDashboardRefreshRequest> {
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardId").getter(getter(StartDashboardRefreshRequest::dashboardId))
            .setter(setter(Builder::dashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardId").build()).build();

    private static final SdkField<Map<String, String>> QUERY_PARAMETER_VALUES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("QueryParameterValues")
            .getter(getter(StartDashboardRefreshRequest::queryParameterValues))
            .setter(setter(Builder::queryParameterValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryParameterValues").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ID_FIELD,
            QUERY_PARAMETER_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dashboardId;

    private final Map<String, String> queryParameterValues;

    private StartDashboardRefreshRequest(BuilderImpl builder) {
        super(builder);
        this.dashboardId = builder.dashboardId;
        this.queryParameterValues = builder.queryParameterValues;
    }

    /**
     * <p>
     * The name or ARN of the dashboard.
     * </p>
     * 
     * @return The name or ARN of the dashboard.
     */
    public final String dashboardId() {
        return dashboardId;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryParameterValues property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQueryParameterValues() {
        return queryParameterValues != null && !(queryParameterValues instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The query parameter values for the dashboard
     * </p>
     * <p>
     * For custom dashboards, the following query parameters are valid: <code>$StartTime$</code>, <code>$EndTime$</code>
     * , and <code>$Period$</code>.
     * </p>
     * <p>
     * For managed dashboards, the following query parameters are valid: <code>$StartTime$</code>,
     * <code>$EndTime$</code>, <code>$Period$</code>, and <code>$EventDataStoreId$</code>. The
     * <code>$EventDataStoreId$</code> query parameter is required.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryParameterValues} method.
     * </p>
     * 
     * @return The query parameter values for the dashboard </p>
     *         <p>
     *         For custom dashboards, the following query parameters are valid: <code>$StartTime$</code>,
     *         <code>$EndTime$</code>, and <code>$Period$</code>.
     *         </p>
     *         <p>
     *         For managed dashboards, the following query parameters are valid: <code>$StartTime$</code>,
     *         <code>$EndTime$</code>, <code>$Period$</code>, and <code>$EventDataStoreId$</code>. The
     *         <code>$EventDataStoreId$</code> query parameter is required.
     */
    public final Map<String, String> queryParameterValues() {
        return queryParameterValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryParameterValues() ? queryParameterValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDashboardRefreshRequest)) {
            return false;
        }
        StartDashboardRefreshRequest other = (StartDashboardRefreshRequest) obj;
        return Objects.equals(dashboardId(), other.dashboardId()) && hasQueryParameterValues() == other.hasQueryParameterValues()
                && Objects.equals(queryParameterValues(), other.queryParameterValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDashboardRefreshRequest").add("DashboardId", dashboardId())
                .add("QueryParameterValues", hasQueryParameterValues() ? queryParameterValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardId":
            return Optional.ofNullable(clazz.cast(dashboardId()));
        case "QueryParameterValues":
            return Optional.ofNullable(clazz.cast(queryParameterValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DashboardId", DASHBOARD_ID_FIELD);
        map.put("QueryParameterValues", QUERY_PARAMETER_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDashboardRefreshRequest, T> g) {
        return obj -> g.apply((StartDashboardRefreshRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartDashboardRefreshRequest> {
        /**
         * <p>
         * The name or ARN of the dashboard.
         * </p>
         * 
         * @param dashboardId
         *        The name or ARN of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardId(String dashboardId);

        /**
         * <p>
         * The query parameter values for the dashboard
         * </p>
         * <p>
         * For custom dashboards, the following query parameters are valid: <code>$StartTime$</code>,
         * <code>$EndTime$</code>, and <code>$Period$</code>.
         * </p>
         * <p>
         * For managed dashboards, the following query parameters are valid: <code>$StartTime$</code>,
         * <code>$EndTime$</code>, <code>$Period$</code>, and <code>$EventDataStoreId$</code>. The
         * <code>$EventDataStoreId$</code> query parameter is required.
         * </p>
         * 
         * @param queryParameterValues
         *        The query parameter values for the dashboard </p>
         *        <p>
         *        For custom dashboards, the following query parameters are valid: <code>$StartTime$</code>,
         *        <code>$EndTime$</code>, and <code>$Period$</code>.
         *        </p>
         *        <p>
         *        For managed dashboards, the following query parameters are valid: <code>$StartTime$</code>,
         *        <code>$EndTime$</code>, <code>$Period$</code>, and <code>$EventDataStoreId$</code>. The
         *        <code>$EventDataStoreId$</code> query parameter is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryParameterValues(Map<String, String> queryParameterValues);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private String dashboardId;

        private Map<String, String> queryParameterValues = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartDashboardRefreshRequest model) {
            super(model);
            dashboardId(model.dashboardId);
            queryParameterValues(model.queryParameterValues);
        }

        public final String getDashboardId() {
            return dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final Map<String, String> getQueryParameterValues() {
            if (queryParameterValues instanceof SdkAutoConstructMap) {
                return null;
            }
            return queryParameterValues;
        }

        public final void setQueryParameterValues(Map<String, String> queryParameterValues) {
            this.queryParameterValues = QueryParameterValuesCopier.copy(queryParameterValues);
        }

        @Override
        public final Builder queryParameterValues(Map<String, String> queryParameterValues) {
            this.queryParameterValues = QueryParameterValuesCopier.copy(queryParameterValues);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDashboardRefreshRequest build() {
            return new StartDashboardRefreshRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
