/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cloudtrail.CloudTrailAsyncClient;
import software.amazon.awssdk.services.cloudtrail.CloudTrailServiceClientConfiguration;
import software.amazon.awssdk.services.cloudtrail.internal.CloudTrailServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cloudtrail.model.AccessDeniedException;
import software.amazon.awssdk.services.cloudtrail.model.AccountHasOngoingImportException;
import software.amazon.awssdk.services.cloudtrail.model.AccountNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.AccountNotRegisteredException;
import software.amazon.awssdk.services.cloudtrail.model.AccountRegisteredException;
import software.amazon.awssdk.services.cloudtrail.model.AddTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.AddTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.CancelQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.CancelQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.CannotDelegateManagementAccountException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelAlreadyExistsException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelArnInvalidException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelExistsForEdsException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelMaxLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailAccessNotEnabledException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailArnInvalidException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailInvalidClientTokenIdException;
import software.amazon.awssdk.services.cloudtrail.model.CloudWatchLogsDeliveryUnavailableException;
import software.amazon.awssdk.services.cloudtrail.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cloudtrail.model.ConflictException;
import software.amazon.awssdk.services.cloudtrail.model.CreateChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.CreateDashboardRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateDashboardResponse;
import software.amazon.awssdk.services.cloudtrail.model.CreateEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.CreateTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.DelegatedAdminAccountLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.DeleteChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteDashboardRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteDashboardResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeregisterOrganizationDelegatedAdminRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeregisterOrganizationDelegatedAdminResponse;
import software.amazon.awssdk.services.cloudtrail.model.DescribeQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.DescribeQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.DescribeTrailsRequest;
import software.amazon.awssdk.services.cloudtrail.model.DescribeTrailsResponse;
import software.amazon.awssdk.services.cloudtrail.model.DisableFederationRequest;
import software.amazon.awssdk.services.cloudtrail.model.DisableFederationResponse;
import software.amazon.awssdk.services.cloudtrail.model.EnableFederationRequest;
import software.amazon.awssdk.services.cloudtrail.model.EnableFederationResponse;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreAlreadyExistsException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreArnInvalidException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreFederationEnabledException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreHasOngoingImportException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreMaxLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreTerminationProtectedException;
import software.amazon.awssdk.services.cloudtrail.model.GenerateQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.GenerateQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.GenerateResponseException;
import software.amazon.awssdk.services.cloudtrail.model.GetChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetDashboardRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetDashboardResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetEventConfigurationRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetEventConfigurationResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetEventSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetEventSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetInsightSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetInsightSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailStatusRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailStatusResponse;
import software.amazon.awssdk.services.cloudtrail.model.ImportNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.InactiveEventDataStoreException;
import software.amazon.awssdk.services.cloudtrail.model.InactiveQueryException;
import software.amazon.awssdk.services.cloudtrail.model.InsightNotEnabledException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientDependencyServiceAccessPermissionException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientEncryptionPolicyException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientIamAccessPermissionException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientS3BucketPolicyException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientSnsTopicPolicyException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidCloudWatchLogsLogGroupArnException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidCloudWatchLogsRoleArnException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidDateRangeException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventCategoryException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventDataStoreCategoryException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventDataStoreStatusException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventSelectorsException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidHomeRegionException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidImportSourceException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidInsightSelectorsException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidKmsKeyIdException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidLookupAttributesException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidMaxResultsException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidNextTokenException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidParameterException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidQueryStatementException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidQueryStatusException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidS3BucketNameException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidS3PrefixException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidSnsTopicNameException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidSourceException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTagParameterException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTokenException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTrailNameException;
import software.amazon.awssdk.services.cloudtrail.model.KmsException;
import software.amazon.awssdk.services.cloudtrail.model.KmsKeyNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.ListChannelsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListChannelsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListDashboardsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListDashboardsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListImportsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListImportsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListQueriesRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListQueriesResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsResponse;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse;
import software.amazon.awssdk.services.cloudtrail.model.MaxConcurrentQueriesException;
import software.amazon.awssdk.services.cloudtrail.model.MaximumNumberOfTrailsExceededException;
import software.amazon.awssdk.services.cloudtrail.model.NoManagementAccountSlrExistsException;
import software.amazon.awssdk.services.cloudtrail.model.NotOrganizationManagementAccountException;
import software.amazon.awssdk.services.cloudtrail.model.NotOrganizationMasterAccountException;
import software.amazon.awssdk.services.cloudtrail.model.OperationNotPermittedException;
import software.amazon.awssdk.services.cloudtrail.model.OrganizationNotInAllFeaturesModeException;
import software.amazon.awssdk.services.cloudtrail.model.OrganizationsNotInUseException;
import software.amazon.awssdk.services.cloudtrail.model.PutEventConfigurationRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutEventConfigurationResponse;
import software.amazon.awssdk.services.cloudtrail.model.PutEventSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutEventSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.PutInsightSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutInsightSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.cloudtrail.model.QueryIdNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.RegisterOrganizationDelegatedAdminRequest;
import software.amazon.awssdk.services.cloudtrail.model.RegisterOrganizationDelegatedAdminResponse;
import software.amazon.awssdk.services.cloudtrail.model.RemoveTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.RemoveTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ResourceArnNotValidException;
import software.amazon.awssdk.services.cloudtrail.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.ResourcePolicyNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.ResourcePolicyNotValidException;
import software.amazon.awssdk.services.cloudtrail.model.ResourceTypeNotSupportedException;
import software.amazon.awssdk.services.cloudtrail.model.RestoreEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.RestoreEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.S3BucketDoesNotExistException;
import software.amazon.awssdk.services.cloudtrail.model.SearchSampleQueriesRequest;
import software.amazon.awssdk.services.cloudtrail.model.SearchSampleQueriesResponse;
import software.amazon.awssdk.services.cloudtrail.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.cloudtrail.model.StartDashboardRefreshRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartDashboardRefreshResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartEventDataStoreIngestionRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartEventDataStoreIngestionResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartLoggingRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartLoggingResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopEventDataStoreIngestionRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopEventDataStoreIngestionResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopLoggingRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopLoggingResponse;
import software.amazon.awssdk.services.cloudtrail.model.TagsLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.ThrottlingException;
import software.amazon.awssdk.services.cloudtrail.model.TrailAlreadyExistsException;
import software.amazon.awssdk.services.cloudtrail.model.TrailNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.TrailNotProvidedException;
import software.amazon.awssdk.services.cloudtrail.model.UnsupportedOperationException;
import software.amazon.awssdk.services.cloudtrail.model.UpdateChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.UpdateDashboardRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateDashboardResponse;
import software.amazon.awssdk.services.cloudtrail.model.UpdateEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.UpdateTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateTrailResponse;
import software.amazon.awssdk.services.cloudtrail.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CancelQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CreateChannelRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CreateDashboardRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CreateEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CreateTrailRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteChannelRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteDashboardRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteTrailRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeregisterOrganizationDelegatedAdminRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DescribeQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DescribeTrailsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DisableFederationRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.EnableFederationRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GenerateQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetChannelRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetDashboardRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetEventConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetEventSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetImportRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetInsightSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetQueryResultsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetTrailRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetTrailStatusRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListChannelsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListDashboardsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListEventDataStoresRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListImportFailuresRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListImportsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListInsightsMetricDataRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListPublicKeysRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListQueriesRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListTrailsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.LookupEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.PutEventConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.PutEventSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.PutInsightSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.RegisterOrganizationDelegatedAdminRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.RestoreEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.SearchSampleQueriesRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartDashboardRefreshRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartEventDataStoreIngestionRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartImportRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartLoggingRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StopEventDataStoreIngestionRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StopImportRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StopLoggingRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.UpdateChannelRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.UpdateDashboardRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.UpdateEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.UpdateTrailRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCloudTrailAsyncClient
implements CloudTrailAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCloudTrailAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudTrailAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"CloudTrail#2.34.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, addTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$addTags$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$addTags$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CancelQueryResponse> cancelQuery(CancelQueryRequest cancelQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, cancelQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CancelQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)cancelQueryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$cancelQuery$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$cancelQuery$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateChannelResponse> createChannel(CreateChannelRequest createChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, createChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$createChannel$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$createChannel$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDashboardResponse> createDashboard(CreateDashboardRequest createDashboardRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDashboardRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, createDashboardRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDashboard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDashboardResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDashboard").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDashboardRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDashboardRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$createDashboard$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$createDashboard$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateEventDataStoreResponse> createEventDataStore(CreateEventDataStoreRequest createEventDataStoreRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEventDataStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, createEventDataStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEventDataStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEventDataStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEventDataStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateEventDataStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createEventDataStoreRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$createEventDataStore$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$createEventDataStore$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTrailResponse> createTrail(CreateTrailRequest createTrailRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTrailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, createTrailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTrail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTrailResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateTrailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createTrailRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$createTrail$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$createTrail$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteChannelResponse> deleteChannel(DeleteChannelRequest deleteChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$deleteChannel$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$deleteChannel$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDashboardResponse> deleteDashboard(DeleteDashboardRequest deleteDashboardRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDashboardRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDashboardRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDashboard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDashboardResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDashboard").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDashboardRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDashboardRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$deleteDashboard$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$deleteDashboard$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEventDataStoreResponse> deleteEventDataStore(DeleteEventDataStoreRequest deleteEventDataStoreRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEventDataStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteEventDataStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEventDataStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEventDataStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventDataStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteEventDataStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteEventDataStoreRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$deleteEventDataStore$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$deleteEventDataStore$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteResourcePolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$deleteResourcePolicy$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$deleteResourcePolicy$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTrailResponse> deleteTrail(DeleteTrailRequest deleteTrailRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTrailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteTrailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTrail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTrailResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTrail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteTrailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteTrailRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$deleteTrail$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$deleteTrail$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeregisterOrganizationDelegatedAdminResponse> deregisterOrganizationDelegatedAdmin(DeregisterOrganizationDelegatedAdminRequest deregisterOrganizationDelegatedAdminRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterOrganizationDelegatedAdminRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, deregisterOrganizationDelegatedAdminRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterOrganizationDelegatedAdmin");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterOrganizationDelegatedAdminResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterOrganizationDelegatedAdmin").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeregisterOrganizationDelegatedAdminRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deregisterOrganizationDelegatedAdminRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$deregisterOrganizationDelegatedAdmin$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$deregisterOrganizationDelegatedAdmin$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeQueryResponse> describeQuery(DescribeQueryRequest describeQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, describeQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeQueryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$describeQuery$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$describeQuery$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTrailsResponse> describeTrails(DescribeTrailsRequest describeTrailsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTrailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, describeTrailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTrails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrailsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTrailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTrailsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$describeTrails$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$describeTrails$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableFederationResponse> disableFederation(DisableFederationRequest disableFederationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableFederationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, disableFederationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableFederation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableFederationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableFederation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisableFederationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disableFederationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$disableFederation$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$disableFederation$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableFederationResponse> enableFederation(EnableFederationRequest enableFederationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableFederationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, enableFederationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableFederation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableFederationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableFederation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new EnableFederationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)enableFederationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$enableFederation$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$enableFederation$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GenerateQueryResponse> generateQuery(GenerateQueryRequest generateQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, generateQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GenerateQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)generateQueryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$generateQuery$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$generateQuery$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetChannelResponse> getChannel(GetChannelRequest getChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, getChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$getChannel$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$getChannel$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDashboardResponse> getDashboard(GetDashboardRequest getDashboardRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDashboardRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, getDashboardRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDashboard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDashboardResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDashboard").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDashboardRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDashboardRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$getDashboard$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$getDashboard$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetEventConfigurationResponse> getEventConfiguration(GetEventConfigurationRequest getEventConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEventConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, getEventConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEventConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEventConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEventConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetEventConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getEventConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$getEventConfiguration$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$getEventConfiguration$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetEventDataStoreResponse> getEventDataStore(GetEventDataStoreRequest getEventDataStoreRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEventDataStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, getEventDataStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEventDataStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEventDataStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEventDataStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetEventDataStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getEventDataStoreRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$getEventDataStore$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$getEventDataStore$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetEventSelectorsResponse> getEventSelectors(GetEventSelectorsRequest getEventSelectorsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEventSelectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, getEventSelectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEventSelectors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEventSelectorsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEventSelectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetEventSelectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getEventSelectorsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$getEventSelectors$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$getEventSelectors$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetImportResponse> getImport(GetImportRequest getImportRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getImportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, getImportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetImport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetImportResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetImport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetImportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getImportRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$getImport$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$getImport$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInsightSelectorsResponse> getInsightSelectors(GetInsightSelectorsRequest getInsightSelectorsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInsightSelectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, getInsightSelectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInsightSelectors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInsightSelectorsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInsightSelectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetInsightSelectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInsightSelectorsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$getInsightSelectors$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$getInsightSelectors$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetQueryResultsResponse> getQueryResults(GetQueryResultsRequest getQueryResultsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getQueryResultsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, getQueryResultsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQueryResults");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryResultsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryResults").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetQueryResultsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getQueryResultsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$getQueryResults$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$getQueryResults$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getResourcePolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$getResourcePolicy$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$getResourcePolicy$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTrailResponse> getTrail(GetTrailRequest getTrailRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTrailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, getTrailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTrail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTrailResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTrail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetTrailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getTrailRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$getTrail$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$getTrail$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTrailStatusResponse> getTrailStatus(GetTrailStatusRequest getTrailStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTrailStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, getTrailStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTrailStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTrailStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTrailStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetTrailStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getTrailStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$getTrailStatus$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$getTrailStatus$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListChannelsResponse> listChannels(ListChannelsRequest listChannelsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listChannelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, listChannelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListChannels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListChannelsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListChannels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListChannelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listChannelsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$listChannels$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$listChannels$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDashboardsResponse> listDashboards(ListDashboardsRequest listDashboardsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDashboardsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, listDashboardsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDashboards");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDashboardsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDashboards").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDashboardsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDashboardsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$listDashboards$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$listDashboards$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListEventDataStoresResponse> listEventDataStores(ListEventDataStoresRequest listEventDataStoresRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEventDataStoresRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, listEventDataStoresRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEventDataStores");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventDataStoresResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEventDataStores").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListEventDataStoresRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listEventDataStoresRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$listEventDataStores$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$listEventDataStores$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListImportFailuresResponse> listImportFailures(ListImportFailuresRequest listImportFailuresRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listImportFailuresRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, listImportFailuresRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListImportFailures");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListImportFailuresResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListImportFailures").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListImportFailuresRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listImportFailuresRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$listImportFailures$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$listImportFailures$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListImportsResponse> listImports(ListImportsRequest listImportsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listImportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, listImportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListImports");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListImportsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                    }
                    case "InvalidCloudWatchLogsLogGroupArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                    }
                    case "InvalidEventDataStoreCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                    }
                    case "InvalidSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                    }
                    case "EventDataStoreAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                    }
                    case "CloudTrailARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                    }
                    case "NotOrganizationMasterAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InvalidLookupAttributesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                    }
                    case "CloudTrailInvalidClientTokenIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                    }
                    case "OrganizationsNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "GenerateResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                    }
                    case "ChannelExistsForEDSException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidEventSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "InvalidEventDataStoreStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                    }
                    case "AccountNotRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                    }
                    case "EventDataStoreFederationEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                    }
                    case "NoManagementAccountSLRExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                    }
                    case "CloudTrailAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                    }
                    case "InvalidTrailNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                    }
                    case "InvalidImportSourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                    }
                    case "InsufficientEncryptionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                    }
                    case "ResourcePolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                    }
                    case "DelegatedAdminAccountLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                    }
                    case "EventDataStoreARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                    }
                    case "InvalidS3PrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                    }
                    case "InsufficientSnsTopicPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                    }
                    case "InvalidHomeRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                    }
                    case "InsufficientDependencyServiceAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                    }
                    case "ChannelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ChannelARNInvalidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                    }
                    case "QueryIdNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                    }
                    case "InactiveEventDataStoreException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                    }
                    case "TrailNotProvidedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                    }
                    case "InvalidQueryStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                    }
                    case "InvalidEventCategoryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                    }
                    case "KmsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "S3BucketDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                    }
                    case "CannotDelegateManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                    }
                    case "TagsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                    }
                    case "InvalidSnsTopicNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                    }
                    case "KmsKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                    }
                    case "AccountRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "AccountHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                    }
                    case "ResourceTypeNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidCloudWatchLogsRoleArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                    }
                    case "InvalidQueryStatementException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "AccountNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidMaxResultsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                    }
                    case "InvalidS3BucketNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                    }
                    case "CloudWatchLogsDeliveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                    }
                    case "InactiveQueryException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                    }
                    case "ChannelMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                    }
                    case "InvalidTagParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                    }
                    case "TrailNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                    }
                    case "MaximumNumberOfTrailsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                    }
                    case "EventDataStoreHasOngoingImportException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                    }
                    case "InvalidInsightSelectorsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                    }
                    case "InvalidDateRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                    }
                    case "NotOrganizationManagementAccountException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                    }
                    case "ChannelNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                    }
                    case "MaxConcurrentQueriesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                    }
                    case "InsufficientS3BucketPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                    }
                    case "TrailAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                    }
                    case "InsightNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListImports").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListImportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listImportsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailAsyncClient.lambda$listImports$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailAsyncClient.lambda$listImports$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListInsightsMetricDataResponse> listInsightsMetricData(ListInsightsMetricDataRequest listInsightsMetricDataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listInsightsMetricDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailAsyncClient.resolveMetricPublishers(clientConfiguration, listInsightsMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInsightsMetricData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInsightsMetricDataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "EventDataStoreMaxLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                    }
                    case "EventDataStoreTerminationProtectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                    }
                    case "ResourcePolicyNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                    }
                    case "InvalidKmsKeyIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                    }
                    case "InsufficientIAMAccessPermissionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                    }
                    case "ResourceARNNotValidException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotVa