/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportStatistics> {
    private static final SdkField<Long> PREFIXES_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PrefixesFound").getter(ImportStatistics.getter(ImportStatistics::prefixesFound)).setter(ImportStatistics.setter(Builder::prefixesFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixesFound").build()}).build();
    private static final SdkField<Long> PREFIXES_COMPLETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PrefixesCompleted").getter(ImportStatistics.getter(ImportStatistics::prefixesCompleted)).setter(ImportStatistics.setter(Builder::prefixesCompleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixesCompleted").build()}).build();
    private static final SdkField<Long> FILES_COMPLETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FilesCompleted").getter(ImportStatistics.getter(ImportStatistics::filesCompleted)).setter(ImportStatistics.setter(Builder::filesCompleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilesCompleted").build()}).build();
    private static final SdkField<Long> EVENTS_COMPLETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EventsCompleted").getter(ImportStatistics.getter(ImportStatistics::eventsCompleted)).setter(ImportStatistics.setter(Builder::eventsCompleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventsCompleted").build()}).build();
    private static final SdkField<Long> FAILED_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FailedEntries").getter(ImportStatistics.getter(ImportStatistics::failedEntries)).setter(ImportStatistics.setter(Builder::failedEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedEntries").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIXES_FOUND_FIELD, PREFIXES_COMPLETED_FIELD, FILES_COMPLETED_FIELD, EVENTS_COMPLETED_FIELD, FAILED_ENTRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImportStatistics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long prefixesFound;
    private final Long prefixesCompleted;
    private final Long filesCompleted;
    private final Long eventsCompleted;
    private final Long failedEntries;

    private ImportStatistics(BuilderImpl builder) {
        this.prefixesFound = builder.prefixesFound;
        this.prefixesCompleted = builder.prefixesCompleted;
        this.filesCompleted = builder.filesCompleted;
        this.eventsCompleted = builder.eventsCompleted;
        this.failedEntries = builder.failedEntries;
    }

    public final Long prefixesFound() {
        return this.prefixesFound;
    }

    public final Long prefixesCompleted() {
        return this.prefixesCompleted;
    }

    public final Long filesCompleted() {
        return this.filesCompleted;
    }

    public final Long eventsCompleted() {
        return this.eventsCompleted;
    }

    public final Long failedEntries() {
        return this.failedEntries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixesFound());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixesCompleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.filesCompleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventsCompleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedEntries());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportStatistics)) {
            return false;
        }
        ImportStatistics other = (ImportStatistics)obj;
        return Objects.equals(this.prefixesFound(), other.prefixesFound()) && Objects.equals(this.prefixesCompleted(), other.prefixesCompleted()) && Objects.equals(this.filesCompleted(), other.filesCompleted()) && Objects.equals(this.eventsCompleted(), other.eventsCompleted()) && Objects.equals(this.failedEntries(), other.failedEntries());
    }

    public final String toString() {
        return ToString.builder((String)"ImportStatistics").add("PrefixesFound", (Object)this.prefixesFound()).add("PrefixesCompleted", (Object)this.prefixesCompleted()).add("FilesCompleted", (Object)this.filesCompleted()).add("EventsCompleted", (Object)this.eventsCompleted()).add("FailedEntries", (Object)this.failedEntries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrefixesFound": {
                return Optional.ofNullable(clazz.cast(this.prefixesFound()));
            }
            case "PrefixesCompleted": {
                return Optional.ofNullable(clazz.cast(this.prefixesCompleted()));
            }
            case "FilesCompleted": {
                return Optional.ofNullable(clazz.cast(this.filesCompleted()));
            }
            case "EventsCompleted": {
                return Optional.ofNullable(clazz.cast(this.eventsCompleted()));
            }
            case "FailedEntries": {
                return Optional.ofNullable(clazz.cast(this.failedEntries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Long>> map = new HashMap<String, SdkField<Long>>();
        map.put("PrefixesFound", PREFIXES_FOUND_FIELD);
        map.put("PrefixesCompleted", PREFIXES_COMPLETED_FIELD);
        map.put("FilesCompleted", FILES_COMPLETED_FIELD);
        map.put("EventsCompleted", EVENTS_COMPLETED_FIELD);
        map.put("FailedEntries", FAILED_ENTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportStatistics, T> g) {
        return obj -> g.apply((ImportStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long prefixesFound;
        private Long prefixesCompleted;
        private Long filesCompleted;
        private Long eventsCompleted;
        private Long failedEntries;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportStatistics model) {
            this.prefixesFound(model.prefixesFound);
            this.prefixesCompleted(model.prefixesCompleted);
            this.filesCompleted(model.filesCompleted);
            this.eventsCompleted(model.eventsCompleted);
            this.failedEntries(model.failedEntries);
        }

        public final Long getPrefixesFound() {
            return this.prefixesFound;
        }

        public final void setPrefixesFound(Long prefixesFound) {
            this.prefixesFound = prefixesFound;
        }

        @Override
        public final Builder prefixesFound(Long prefixesFound) {
            this.prefixesFound = prefixesFound;
            return this;
        }

        public final Long getPrefixesCompleted() {
            return this.prefixesCompleted;
        }

        public final void setPrefixesCompleted(Long prefixesCompleted) {
            this.prefixesCompleted = prefixesCompleted;
        }

        @Override
        public final Builder prefixesCompleted(Long prefixesCompleted) {
            this.prefixesCompleted = prefixesCompleted;
            return this;
        }

        public final Long getFilesCompleted() {
            return this.filesCompleted;
        }

        public final void setFilesCompleted(Long filesCompleted) {
            this.filesCompleted = filesCompleted;
        }

        @Override
        public final Builder filesCompleted(Long filesCompleted) {
            this.filesCompleted = filesCompleted;
            return this;
        }

        public final Long getEventsCompleted() {
            return this.eventsCompleted;
        }

        public final void setEventsCompleted(Long eventsCompleted) {
            this.eventsCompleted = eventsCompleted;
        }

        @Override
        public final Builder eventsCompleted(Long eventsCompleted) {
            this.eventsCompleted = eventsCompleted;
            return this;
        }

        public final Long getFailedEntries() {
            return this.failedEntries;
        }

        public final void setFailedEntries(Long failedEntries) {
            this.failedEntries = failedEntries;
        }

        @Override
        public final Builder failedEntries(Long failedEntries) {
            this.failedEntries = failedEntries;
            return this;
        }

        public ImportStatistics build() {
            return new ImportStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportStatistics> {
        public Builder prefixesFound(Long var1);

        public Builder prefixesCompleted(Long var1);

        public Builder filesCompleted(Long var1);

        public Builder eventsCompleted(Long var1);

        public Builder failedEntries(Long var1);
    }
}

