/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the tags to add to a trail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddTagsRequest extends CloudTrailRequest implements ToCopyableBuilder<AddTagsRequest.Builder, AddTagsRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddTagsRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<List<Tag>> TAGS_LIST_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(AddTagsRequest::tagsList))
            .setter(setter(Builder::tagsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            TAGS_LIST_FIELD));

    private final String resourceId;

    private final List<Tag> tagsList;

    private AddTagsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.tagsList = builder.tagsList;
    }

    /**
     * <p>
     * Specifies the ARN of the trail to which one or more tags will be added. The format of a trail ARN is:
     * </p>
     * <p>
     * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     * </p>
     * 
     * @return Specifies the ARN of the trail to which one or more tags will be added. The format of a trail ARN is:</p>
     *         <p>
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Contains a list of CloudTrail tags, up to a limit of 50
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Contains a list of CloudTrail tags, up to a limit of 50
     */
    public List<Tag> tagsList() {
        return tagsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(tagsList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsRequest)) {
            return false;
        }
        AddTagsRequest other = (AddTagsRequest) obj;
        return Objects.equals(resourceId(), other.resourceId()) && Objects.equals(tagsList(), other.tagsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AddTagsRequest").add("ResourceId", resourceId()).add("TagsList", tagsList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "TagsList":
            return Optional.ofNullable(clazz.cast(tagsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddTagsRequest, T> g) {
        return obj -> g.apply((AddTagsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddTagsRequest> {
        /**
         * <p>
         * Specifies the ARN of the trail to which one or more tags will be added. The format of a trail ARN is:
         * </p>
         * <p>
         * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
         * </p>
         * 
         * @param resourceId
         *        Specifies the ARN of the trail to which one or more tags will be added. The format of a trail ARN
         *        is:</p>
         *        <p>
         *        <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Contains a list of CloudTrail tags, up to a limit of 50
         * </p>
         * 
         * @param tagsList
         *        Contains a list of CloudTrail tags, up to a limit of 50
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsList(Collection<Tag> tagsList);

        /**
         * <p>
         * Contains a list of CloudTrail tags, up to a limit of 50
         * </p>
         * 
         * @param tagsList
         *        Contains a list of CloudTrail tags, up to a limit of 50
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsList(Tag... tagsList);

        /**
         * <p>
         * Contains a list of CloudTrail tags, up to a limit of 50
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tagsList(List<Tag>)}.
         * 
         * @param tagsList
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagsList(List<Tag>)
         */
        Builder tagsList(Consumer<Tag.Builder>... tagsList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private String resourceId;

        private List<Tag> tagsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddTagsRequest model) {
            super(model);
            resourceId(model.resourceId);
            tagsList(model.tagsList);
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Collection<Tag.Builder> getTagsList() {
            return tagsList != null ? tagsList.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagsList(Collection<Tag> tagsList) {
            this.tagsList = TagsListCopier.copy(tagsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsList(Tag... tagsList) {
            tagsList(Arrays.asList(tagsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsList(Consumer<Tag.Builder>... tagsList) {
            tagsList(Stream.of(tagsList).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagsList(Collection<Tag.BuilderImpl> tagsList) {
            this.tagsList = TagsListCopier.copyFromBuilder(tagsList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddTagsRequest build() {
            return new AddTagsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
