/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtraildata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An event from a source outside of Amazon Web Services that you want CloudTrail to log.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuditEvent implements SdkPojo, Serializable, ToCopyableBuilder<AuditEvent.Builder, AuditEvent> {
    private static final SdkField<String> EVENT_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventData").getter(getter(AuditEvent::eventData)).setter(setter(Builder::eventData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventData").build()).build();

    private static final SdkField<String> EVENT_DATA_CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventDataChecksum").getter(getter(AuditEvent::eventDataChecksum))
            .setter(setter(Builder::eventDataChecksum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventDataChecksum").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AuditEvent::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_FIELD,
            EVENT_DATA_CHECKSUM_FIELD, ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eventData;

    private final String eventDataChecksum;

    private final String id;

    private AuditEvent(BuilderImpl builder) {
        this.eventData = builder.eventData;
        this.eventDataChecksum = builder.eventDataChecksum;
        this.id = builder.id;
    }

    /**
     * <p>
     * The content of an audit event that comes from the event, such as <code>userIdentity</code>,
     * <code>userAgent</code>, and <code>eventSource</code>.
     * </p>
     * 
     * @return The content of an audit event that comes from the event, such as <code>userIdentity</code>,
     *         <code>userAgent</code>, and <code>eventSource</code>.
     */
    public final String eventData() {
        return eventData;
    }

    /**
     * <p>
     * A checksum is a base64-SHA256 algorithm that helps you verify that CloudTrail receives the event that matches
     * with the checksum. Calculate the checksum by running a command like the following:
     * </p>
     * <p>
     * <code>printf %s <i>$eventdata</i> | openssl dgst -binary -sha256 | base64</code>
     * </p>
     * 
     * @return A checksum is a base64-SHA256 algorithm that helps you verify that CloudTrail receives the event that
     *         matches with the checksum. Calculate the checksum by running a command like the following:</p>
     *         <p>
     *         <code>printf %s <i>$eventdata</i> | openssl dgst -binary -sha256 | base64</code>
     */
    public final String eventDataChecksum() {
        return eventDataChecksum;
    }

    /**
     * <p>
     * The original event ID from the source event.
     * </p>
     * 
     * @return The original event ID from the source event.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventData());
        hashCode = 31 * hashCode + Objects.hashCode(eventDataChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditEvent)) {
            return false;
        }
        AuditEvent other = (AuditEvent) obj;
        return Objects.equals(eventData(), other.eventData()) && Objects.equals(eventDataChecksum(), other.eventDataChecksum())
                && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuditEvent").add("EventData", eventData()).add("EventDataChecksum", eventDataChecksum())
                .add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventData":
            return Optional.ofNullable(clazz.cast(eventData()));
        case "eventDataChecksum":
            return Optional.ofNullable(clazz.cast(eventDataChecksum()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eventData", EVENT_DATA_FIELD);
        map.put("eventDataChecksum", EVENT_DATA_CHECKSUM_FIELD);
        map.put("id", ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuditEvent, T> g) {
        return obj -> g.apply((AuditEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuditEvent> {
        /**
         * <p>
         * The content of an audit event that comes from the event, such as <code>userIdentity</code>,
         * <code>userAgent</code>, and <code>eventSource</code>.
         * </p>
         * 
         * @param eventData
         *        The content of an audit event that comes from the event, such as <code>userIdentity</code>,
         *        <code>userAgent</code>, and <code>eventSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventData(String eventData);

        /**
         * <p>
         * A checksum is a base64-SHA256 algorithm that helps you verify that CloudTrail receives the event that matches
         * with the checksum. Calculate the checksum by running a command like the following:
         * </p>
         * <p>
         * <code>printf %s <i>$eventdata</i> | openssl dgst -binary -sha256 | base64</code>
         * </p>
         * 
         * @param eventDataChecksum
         *        A checksum is a base64-SHA256 algorithm that helps you verify that CloudTrail receives the event that
         *        matches with the checksum. Calculate the checksum by running a command like the following:</p>
         *        <p>
         *        <code>printf %s <i>$eventdata</i> | openssl dgst -binary -sha256 | base64</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDataChecksum(String eventDataChecksum);

        /**
         * <p>
         * The original event ID from the source event.
         * </p>
         * 
         * @param id
         *        The original event ID from the source event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    static final class BuilderImpl implements Builder {
        private String eventData;

        private String eventDataChecksum;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditEvent model) {
            eventData(model.eventData);
            eventDataChecksum(model.eventDataChecksum);
            id(model.id);
        }

        public final String getEventData() {
            return eventData;
        }

        public final void setEventData(String eventData) {
            this.eventData = eventData;
        }

        @Override
        public final Builder eventData(String eventData) {
            this.eventData = eventData;
            return this;
        }

        public final String getEventDataChecksum() {
            return eventDataChecksum;
        }

        public final void setEventDataChecksum(String eventDataChecksum) {
            this.eventDataChecksum = eventDataChecksum;
        }

        @Override
        public final Builder eventDataChecksum(String eventDataChecksum) {
            this.eventDataChecksum = eventDataChecksum;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public AuditEvent build() {
            return new AuditEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
