/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtraildata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAuditEventsRequest extends CloudTrailDataRequest implements
        ToCopyableBuilder<PutAuditEventsRequest.Builder, PutAuditEventsRequest> {
    private static final SdkField<List<AuditEvent>> AUDIT_EVENTS_FIELD = SdkField
            .<List<AuditEvent>> builder(MarshallingType.LIST)
            .memberName("auditEvents")
            .getter(getter(PutAuditEventsRequest::auditEvents))
            .setter(setter(Builder::auditEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuditEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuditEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelArn").getter(getter(PutAuditEventsRequest::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("channelArn").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalId").getter(getter(PutAuditEventsRequest::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("externalId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_EVENTS_FIELD,
            CHANNEL_ARN_FIELD, EXTERNAL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AuditEvent> auditEvents;

    private final String channelArn;

    private final String externalId;

    private PutAuditEventsRequest(BuilderImpl builder) {
        super(builder);
        this.auditEvents = builder.auditEvents;
        this.channelArn = builder.channelArn;
        this.externalId = builder.externalId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuditEvents property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuditEvents() {
        return auditEvents != null && !(auditEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The JSON payload of events that you want to ingest. You can also point to the JSON event payload in a file.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuditEvents} method.
     * </p>
     * 
     * @return The JSON payload of events that you want to ingest. You can also point to the JSON event payload in a
     *         file.
     */
    public final List<AuditEvent> auditEvents() {
        return auditEvents;
    }

    /**
     * <p>
     * The ARN or ID (the ARN suffix) of a channel.
     * </p>
     * 
     * @return The ARN or ID (the ARN suffix) of a channel.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * A unique identifier that is conditionally required when the channel's resource policy includes an external ID.
     * This value can be any string, such as a passphrase or account number.
     * </p>
     * 
     * @return A unique identifier that is conditionally required when the channel's resource policy includes an
     *         external ID. This value can be any string, such as a passphrase or account number.
     */
    public final String externalId() {
        return externalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAuditEvents() ? auditEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAuditEventsRequest)) {
            return false;
        }
        PutAuditEventsRequest other = (PutAuditEventsRequest) obj;
        return hasAuditEvents() == other.hasAuditEvents() && Objects.equals(auditEvents(), other.auditEvents())
                && Objects.equals(channelArn(), other.channelArn()) && Objects.equals(externalId(), other.externalId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAuditEventsRequest").add("AuditEvents", hasAuditEvents() ? auditEvents() : null)
                .add("ChannelArn", channelArn()).add("ExternalId", externalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "auditEvents":
            return Optional.ofNullable(clazz.cast(auditEvents()));
        case "channelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("auditEvents", AUDIT_EVENTS_FIELD);
        map.put("channelArn", CHANNEL_ARN_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAuditEventsRequest, T> g) {
        return obj -> g.apply((PutAuditEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutAuditEventsRequest> {
        /**
         * <p>
         * The JSON payload of events that you want to ingest. You can also point to the JSON event payload in a file.
         * </p>
         * 
         * @param auditEvents
         *        The JSON payload of events that you want to ingest. You can also point to the JSON event payload in a
         *        file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditEvents(Collection<AuditEvent> auditEvents);

        /**
         * <p>
         * The JSON payload of events that you want to ingest. You can also point to the JSON event payload in a file.
         * </p>
         * 
         * @param auditEvents
         *        The JSON payload of events that you want to ingest. You can also point to the JSON event payload in a
         *        file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditEvents(AuditEvent... auditEvents);

        /**
         * <p>
         * The JSON payload of events that you want to ingest. You can also point to the JSON event payload in a file.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtraildata.model.AuditEvent.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudtraildata.model.AuditEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtraildata.model.AuditEvent.Builder#build()} is called immediately
         * and its result is passed to {@link #auditEvents(List<AuditEvent>)}.
         * 
         * @param auditEvents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtraildata.model.AuditEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auditEvents(java.util.Collection<AuditEvent>)
         */
        Builder auditEvents(Consumer<AuditEvent.Builder>... auditEvents);

        /**
         * <p>
         * The ARN or ID (the ARN suffix) of a channel.
         * </p>
         * 
         * @param channelArn
         *        The ARN or ID (the ARN suffix) of a channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * A unique identifier that is conditionally required when the channel's resource policy includes an external
         * ID. This value can be any string, such as a passphrase or account number.
         * </p>
         * 
         * @param externalId
         *        A unique identifier that is conditionally required when the channel's resource policy includes an
         *        external ID. This value can be any string, such as a passphrase or account number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailDataRequest.BuilderImpl implements Builder {
        private List<AuditEvent> auditEvents = DefaultSdkAutoConstructList.getInstance();

        private String channelArn;

        private String externalId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAuditEventsRequest model) {
            super(model);
            auditEvents(model.auditEvents);
            channelArn(model.channelArn);
            externalId(model.externalId);
        }

        public final List<AuditEvent.Builder> getAuditEvents() {
            List<AuditEvent.Builder> result = AuditEventsCopier.copyToBuilder(this.auditEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuditEvents(Collection<AuditEvent.BuilderImpl> auditEvents) {
            this.auditEvents = AuditEventsCopier.copyFromBuilder(auditEvents);
        }

        @Override
        public final Builder auditEvents(Collection<AuditEvent> auditEvents) {
            this.auditEvents = AuditEventsCopier.copy(auditEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditEvents(AuditEvent... auditEvents) {
            auditEvents(Arrays.asList(auditEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditEvents(Consumer<AuditEvent.Builder>... auditEvents) {
            auditEvents(Stream.of(auditEvents).map(c -> AuditEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAuditEventsRequest build() {
            return new PutAuditEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
