/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.publishers.cloudwatch.internal.transform;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.metrics.MetricCategory;
import software.amazon.awssdk.metrics.MetricCollection;
import software.amazon.awssdk.metrics.MetricLevel;
import software.amazon.awssdk.metrics.SdkMetric;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.transform.DetailedMetricAggregator;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.transform.MetricAggregator;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.transform.SummaryMetricAggregator;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.transform.TimeBucketedMetrics;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.StatisticSet;
import software.amazon.awssdk.utils.MetricValueNormalizer;

@SdkInternalApi
@NotThreadSafe
public class MetricCollectionAggregator {
    public static final int MAX_METRIC_DATA_PER_REQUEST = 20;
    public static final int MAX_VALUES_PER_REQUEST = 300;
    private static final ApiName API_NAME = ApiName.builder().name("hll").version("cw-mp").build();
    private final String namespace;
    private final TimeBucketedMetrics timeBucketedMetrics;

    public MetricCollectionAggregator(String namespace, Set<SdkMetric<String>> dimensions, Set<MetricCategory> metricCategories, MetricLevel metricLevel, Set<SdkMetric<?>> detailedMetrics) {
        this.namespace = namespace;
        this.timeBucketedMetrics = new TimeBucketedMetrics(dimensions, metricCategories, metricLevel, detailedMetrics);
    }

    public void addCollection(MetricCollection collection) {
        this.timeBucketedMetrics.addMetrics(collection);
    }

    public List<PutMetricDataRequest> getRequests() {
        ArrayList<PutMetricDataRequest> requests = new ArrayList<PutMetricDataRequest>();
        ArrayList<MetricDatum> requestMetricDatums = new ArrayList<MetricDatum>();
        ValuesInRequestCounter valuesInRequestCounter = new ValuesInRequestCounter();
        Map<Instant, Collection<MetricAggregator>> metrics = this.timeBucketedMetrics.timeBucketedMetrics();
        for (Map.Entry<Instant, Collection<MetricAggregator>> entry : metrics.entrySet()) {
            Instant timeBucket = entry.getKey();
            for (MetricAggregator metric : entry.getValue()) {
                if (requestMetricDatums.size() >= 20) {
                    requests.add(this.newPutRequest(requestMetricDatums));
                    requestMetricDatums.clear();
                }
                metric.ifSummary(summaryAggregator -> requestMetricDatums.add(this.summaryMetricDatum(timeBucket, (SummaryMetricAggregator)summaryAggregator)));
                metric.ifDetailed(detailedAggregator -> {
                    int valuesAdded;
                    Collection<DetailedMetricAggregator.DetailedMetrics> detailedMetrics = detailedAggregator.detailedMetrics();
                    for (int startIndex = 0; startIndex < detailedMetrics.size(); startIndex += valuesAdded) {
                        if (valuesInRequestCounter.get() >= 300) {
                            requests.add(this.newPutRequest(requestMetricDatums));
                            requestMetricDatums.clear();
                            valuesInRequestCounter.reset();
                        }
                        MetricDatum data = this.detailedMetricDatum(timeBucket, (DetailedMetricAggregator)detailedAggregator, startIndex, 300 - valuesInRequestCounter.get());
                        valuesAdded = data.values().size();
                        valuesInRequestCounter.add(valuesAdded);
                        requestMetricDatums.add(data);
                    }
                });
            }
        }
        if (!requestMetricDatums.isEmpty()) {
            requests.add(this.newPutRequest(requestMetricDatums));
        }
        this.timeBucketedMetrics.reset();
        return requests;
    }

    private MetricDatum detailedMetricDatum(Instant timeBucket, DetailedMetricAggregator metric, int metricStartIndex, int maxElements) {
        ArrayList values = new ArrayList();
        ArrayList counts = new ArrayList();
        Stream<DetailedMetricAggregator.DetailedMetrics> boundedMetrics = metric.detailedMetrics().stream().skip(metricStartIndex).limit(maxElements);
        boundedMetrics.forEach(detailedMetrics -> {
            values.add(MetricValueNormalizer.normalize((double)detailedMetrics.metricValue()));
            counts.add(Double.valueOf(detailedMetrics.metricCount()));
        });
        return (MetricDatum)MetricDatum.builder().timestamp(timeBucket).metricName(metric.metric().name()).dimensions(metric.dimensions()).unit(metric.unit()).values(values).counts(counts).build();
    }

    private MetricDatum summaryMetricDatum(Instant timeBucket, SummaryMetricAggregator metric) {
        StatisticSet stats = (StatisticSet)StatisticSet.builder().minimum(Double.valueOf(MetricValueNormalizer.normalize((double)metric.min()))).maximum(Double.valueOf(MetricValueNormalizer.normalize((double)metric.max()))).sum(Double.valueOf(MetricValueNormalizer.normalize((double)metric.sum()))).sampleCount(Double.valueOf(metric.count())).build();
        return (MetricDatum)MetricDatum.builder().timestamp(timeBucket).metricName(metric.metric().name()).dimensions(metric.dimensions()).unit(metric.unit()).statisticValues(stats).build();
    }

    private PutMetricDataRequest newPutRequest(List<MetricDatum> metricData) {
        return (PutMetricDataRequest)PutMetricDataRequest.builder().overrideConfiguration(r -> r.addApiName(API_NAME)).namespace(this.namespace).metricData(metricData).build();
    }

    private static class ValuesInRequestCounter {
        private int valuesInRequest;

        private ValuesInRequestCounter() {
        }

        private void add(int i) {
            this.valuesInRequest += i;
        }

        private int get() {
            return this.valuesInRequest;
        }

        private void reset() {
            this.valuesInRequest = 0;
        }
    }
}

