/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.publishers.cloudwatch.internal.transform;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.metrics.MetricCategory;
import software.amazon.awssdk.metrics.MetricCollection;
import software.amazon.awssdk.metrics.MetricLevel;
import software.amazon.awssdk.metrics.MetricRecord;
import software.amazon.awssdk.metrics.SdkMetric;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.transform.DetailedMetricAggregator;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.transform.MetricAggregator;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.transform.MetricAggregatorKey;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.transform.SummaryMetricAggregator;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.utils.MetricValueNormalizer;

@SdkInternalApi
class TimeBucketedMetrics {
    private final Map<Instant, Map<MetricAggregatorKey, MetricAggregator>> timeBucketedMetrics = new HashMap<Instant, Map<MetricAggregatorKey, MetricAggregator>>();
    private final Set<SdkMetric<String>> dimensions;
    private final Set<SdkMetric<?>> detailedMetrics;
    private final Set<MetricCategory> metricCategories;
    private final MetricLevel metricLevel;
    private final boolean metricCategoriesContainsAll;

    TimeBucketedMetrics(Set<SdkMetric<String>> dimensions, Set<MetricCategory> metricCategories, MetricLevel metricLevel, Set<SdkMetric<?>> detailedMetrics) {
        this.dimensions = dimensions;
        this.detailedMetrics = detailedMetrics;
        this.metricCategories = metricCategories;
        this.metricLevel = metricLevel;
        this.metricCategoriesContainsAll = metricCategories.contains(MetricCategory.ALL);
    }

    public void addMetrics(MetricCollection metrics) {
        Instant bucket = this.getBucket(metrics);
        this.addMetricsToBucket(metrics, bucket);
    }

    public void reset() {
        this.timeBucketedMetrics.clear();
    }

    public Map<Instant, Collection<MetricAggregator>> timeBucketedMetrics() {
        return this.timeBucketedMetrics.entrySet().stream().collect(Collectors.toMap(e -> (Instant)e.getKey(), e -> ((Map)e.getValue()).values()));
    }

    private Instant getBucket(MetricCollection metrics) {
        return metrics.creationTime().truncatedTo(ChronoUnit.MINUTES);
    }

    private void addMetricsToBucket(MetricCollection metrics, Instant bucketId) {
        this.aggregateMetrics(metrics, this.timeBucketedMetrics.computeIfAbsent(bucketId, i -> new HashMap()));
    }

    private void aggregateMetrics(MetricCollection metrics, Map<MetricAggregatorKey, MetricAggregator> bucket) {
        List<Dimension> dimensions = this.dimensions(metrics);
        this.extractAllMetrics(metrics).forEach(metricRecord -> {
            MetricAggregatorKey aggregatorKey = new MetricAggregatorKey(metricRecord.metric(), dimensions);
            this.valueFor((MetricRecord<?>)metricRecord).ifPresent(metricValue -> bucket.computeIfAbsent(aggregatorKey, m -> this.newAggregator(aggregatorKey)).addMetricValue(MetricValueNormalizer.normalize((double)metricValue)));
        });
    }

    private List<Dimension> dimensions(MetricCollection metricCollection) {
        ArrayList<Dimension> result = new ArrayList<Dimension>();
        for (MetricRecord metricRecord : metricCollection) {
            if (!this.dimensions.contains(metricRecord.metric())) continue;
            result.add((Dimension)Dimension.builder().name(metricRecord.metric().name()).value((String)metricRecord.value()).build());
        }
        result.sort(Comparator.comparing(Dimension::name).reversed());
        return result;
    }

    private List<MetricRecord<?>> extractAllMetrics(MetricCollection metrics) {
        ArrayList result = new ArrayList();
        this.extractAllMetrics(metrics, result);
        return result;
    }

    private void extractAllMetrics(MetricCollection metrics, List<MetricRecord<?>> extractedMetrics) {
        for (MetricRecord metric : metrics) {
            extractedMetrics.add(metric);
        }
        metrics.children().forEach(child -> this.extractAllMetrics((MetricCollection)child, extractedMetrics));
    }

    private MetricAggregator newAggregator(MetricAggregatorKey aggregatorKey) {
        SdkMetric<?> metric = aggregatorKey.metric();
        StandardUnit metricUnit = this.unitFor(metric);
        if (this.detailedMetrics.contains(metric)) {
            return new DetailedMetricAggregator(aggregatorKey, metricUnit);
        }
        return new SummaryMetricAggregator(aggregatorKey, metricUnit);
    }

    private StandardUnit unitFor(SdkMetric<?> metric) {
        Class metricType = metric.valueClass();
        if (Duration.class.isAssignableFrom(metricType)) {
            return StandardUnit.MILLISECONDS;
        }
        return StandardUnit.NONE;
    }

    private Optional<Double> valueFor(MetricRecord<?> metricRecord) {
        if (!this.shouldReport(metricRecord)) {
            return Optional.empty();
        }
        Class metricType = metricRecord.metric().valueClass();
        if (Duration.class.isAssignableFrom(metricType)) {
            Duration durationMetricValue = (Duration)metricRecord.value();
            long millis = durationMetricValue.toMillis();
            return Optional.of(Double.valueOf(millis));
        }
        if (Number.class.isAssignableFrom(metricType)) {
            Number numberMetricValue = (Number)metricRecord.value();
            return Optional.of(numberMetricValue.doubleValue());
        }
        if (Boolean.class.isAssignableFrom(metricType)) {
            Boolean booleanMetricValue = (Boolean)metricRecord.value();
            return Optional.of(booleanMetricValue != false ? 1.0 : 0.0);
        }
        return Optional.empty();
    }

    private boolean shouldReport(MetricRecord<?> metricRecord) {
        return this.isSupportedCategory(metricRecord) && this.isSupportedLevel(metricRecord);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSupportedCategory(MetricRecord<?> metricRecord) {
        if (this.metricCategoriesContainsAll) return true;
        if (!metricRecord.metric().categories().stream().anyMatch(this.metricCategories::contains)) return false;
        return true;
    }

    private boolean isSupportedLevel(MetricRecord<?> metricRecord) {
        return this.metricLevel.includesLevel(metricRecord.metric().level());
    }
}

