/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Date;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Encapsulates the statistical data that Amazon CloudWatch computes from metric data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Datapoint implements ToCopyableBuilder<Datapoint.Builder, Datapoint> {
    private final Date timestamp;

    private final Double sampleCount;

    private final Double average;

    private final Double sum;

    private final Double minimum;

    private final Double maximum;

    private final String unit;

    private final Map<String, Double> extendedStatistics;

    private Datapoint(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.sampleCount = builder.sampleCount;
        this.average = builder.average;
        this.sum = builder.sum;
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
        this.unit = builder.unit;
        this.extendedStatistics = builder.extendedStatistics;
    }

    /**
     * <p>
     * The time stamp used for the data point.
     * </p>
     * 
     * @return The time stamp used for the data point.
     */
    public Date timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The number of metric values that contributed to the aggregate value of this data point.
     * </p>
     * 
     * @return The number of metric values that contributed to the aggregate value of this data point.
     */
    public Double sampleCount() {
        return sampleCount;
    }

    /**
     * <p>
     * The average of the metric values that correspond to the data point.
     * </p>
     * 
     * @return The average of the metric values that correspond to the data point.
     */
    public Double average() {
        return average;
    }

    /**
     * <p>
     * The sum of the metric values for the data point.
     * </p>
     * 
     * @return The sum of the metric values for the data point.
     */
    public Double sum() {
        return sum;
    }

    /**
     * <p>
     * The minimum metric value for the data point.
     * </p>
     * 
     * @return The minimum metric value for the data point.
     */
    public Double minimum() {
        return minimum;
    }

    /**
     * <p>
     * The maximum metric value for the data point.
     * </p>
     * 
     * @return The maximum metric value for the data point.
     */
    public Double maximum() {
        return maximum;
    }

    /**
     * <p>
     * The standard unit for the data point.
     * </p>
     * 
     * @return The standard unit for the data point.
     * @see StandardUnit
     */
    public String unit() {
        return unit;
    }

    /**
     * <p>
     * The percentile statistic for the data point.
     * </p>
     * 
     * @return The percentile statistic for the data point.
     */
    public Map<String, Double> extendedStatistics() {
        return extendedStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((timestamp() == null) ? 0 : timestamp().hashCode());
        hashCode = 31 * hashCode + ((sampleCount() == null) ? 0 : sampleCount().hashCode());
        hashCode = 31 * hashCode + ((average() == null) ? 0 : average().hashCode());
        hashCode = 31 * hashCode + ((sum() == null) ? 0 : sum().hashCode());
        hashCode = 31 * hashCode + ((minimum() == null) ? 0 : minimum().hashCode());
        hashCode = 31 * hashCode + ((maximum() == null) ? 0 : maximum().hashCode());
        hashCode = 31 * hashCode + ((unit() == null) ? 0 : unit().hashCode());
        hashCode = 31 * hashCode + ((extendedStatistics() == null) ? 0 : extendedStatistics().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Datapoint)) {
            return false;
        }
        Datapoint other = (Datapoint) obj;
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        if (other.sampleCount() == null ^ this.sampleCount() == null) {
            return false;
        }
        if (other.sampleCount() != null && !other.sampleCount().equals(this.sampleCount())) {
            return false;
        }
        if (other.average() == null ^ this.average() == null) {
            return false;
        }
        if (other.average() != null && !other.average().equals(this.average())) {
            return false;
        }
        if (other.sum() == null ^ this.sum() == null) {
            return false;
        }
        if (other.sum() != null && !other.sum().equals(this.sum())) {
            return false;
        }
        if (other.minimum() == null ^ this.minimum() == null) {
            return false;
        }
        if (other.minimum() != null && !other.minimum().equals(this.minimum())) {
            return false;
        }
        if (other.maximum() == null ^ this.maximum() == null) {
            return false;
        }
        if (other.maximum() != null && !other.maximum().equals(this.maximum())) {
            return false;
        }
        if (other.unit() == null ^ this.unit() == null) {
            return false;
        }
        if (other.unit() != null && !other.unit().equals(this.unit())) {
            return false;
        }
        if (other.extendedStatistics() == null ^ this.extendedStatistics() == null) {
            return false;
        }
        if (other.extendedStatistics() != null && !other.extendedStatistics().equals(this.extendedStatistics())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (timestamp() != null) {
            sb.append("Timestamp: ").append(timestamp()).append(",");
        }
        if (sampleCount() != null) {
            sb.append("SampleCount: ").append(sampleCount()).append(",");
        }
        if (average() != null) {
            sb.append("Average: ").append(average()).append(",");
        }
        if (sum() != null) {
            sb.append("Sum: ").append(sum()).append(",");
        }
        if (minimum() != null) {
            sb.append("Minimum: ").append(minimum()).append(",");
        }
        if (maximum() != null) {
            sb.append("Maximum: ").append(maximum()).append(",");
        }
        if (unit() != null) {
            sb.append("Unit: ").append(unit()).append(",");
        }
        if (extendedStatistics() != null) {
            sb.append("ExtendedStatistics: ").append(extendedStatistics()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Datapoint> {
        /**
         * <p>
         * The time stamp used for the data point.
         * </p>
         * 
         * @param timestamp
         *        The time stamp used for the data point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Date timestamp);

        /**
         * <p>
         * The number of metric values that contributed to the aggregate value of this data point.
         * </p>
         * 
         * @param sampleCount
         *        The number of metric values that contributed to the aggregate value of this data point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleCount(Double sampleCount);

        /**
         * <p>
         * The average of the metric values that correspond to the data point.
         * </p>
         * 
         * @param average
         *        The average of the metric values that correspond to the data point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder average(Double average);

        /**
         * <p>
         * The sum of the metric values for the data point.
         * </p>
         * 
         * @param sum
         *        The sum of the metric values for the data point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sum(Double sum);

        /**
         * <p>
         * The minimum metric value for the data point.
         * </p>
         * 
         * @param minimum
         *        The minimum metric value for the data point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimum(Double minimum);

        /**
         * <p>
         * The maximum metric value for the data point.
         * </p>
         * 
         * @param maximum
         *        The maximum metric value for the data point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximum(Double maximum);

        /**
         * <p>
         * The standard unit for the data point.
         * </p>
         * 
         * @param unit
         *        The standard unit for the data point.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The standard unit for the data point.
         * </p>
         * 
         * @param unit
         *        The standard unit for the data point.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardUnit
         */
        Builder unit(StandardUnit unit);

        /**
         * <p>
         * The percentile statistic for the data point.
         * </p>
         * 
         * @param extendedStatistics
         *        The percentile statistic for the data point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedStatistics(Map<String, Double> extendedStatistics);
    }

    private static final class BuilderImpl implements Builder {
        private Date timestamp;

        private Double sampleCount;

        private Double average;

        private Double sum;

        private Double minimum;

        private Double maximum;

        private String unit;

        private Map<String, Double> extendedStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(Datapoint model) {
            setTimestamp(model.timestamp);
            setSampleCount(model.sampleCount);
            setAverage(model.average);
            setSum(model.sum);
            setMinimum(model.minimum);
            setMaximum(model.maximum);
            setUnit(model.unit);
            setExtendedStatistics(model.extendedStatistics);
        }

        public final Date getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Date timestamp) {
            this.timestamp = StandardMemberCopier.copy(timestamp);
            return this;
        }

        public final void setTimestamp(Date timestamp) {
            this.timestamp = StandardMemberCopier.copy(timestamp);
        }

        public final Double getSampleCount() {
            return sampleCount;
        }

        @Override
        public final Builder sampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
            return this;
        }

        public final void setSampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
        }

        public final Double getAverage() {
            return average;
        }

        @Override
        public final Builder average(Double average) {
            this.average = average;
            return this;
        }

        public final void setAverage(Double average) {
            this.average = average;
        }

        public final Double getSum() {
            return sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        public final Double getMinimum() {
            return minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        public final Double getMaximum() {
            return maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        public final String getUnit() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final void setUnit(StandardUnit unit) {
            this.unit(unit.toString());
        }

        public final Map<String, Double> getExtendedStatistics() {
            return extendedStatistics;
        }

        @Override
        public final Builder extendedStatistics(Map<String, Double> extendedStatistics) {
            this.extendedStatistics = DatapointValueMapCopier.copy(extendedStatistics);
            return this;
        }

        public final void setExtendedStatistics(Map<String, Double> extendedStatistics) {
            this.extendedStatistics = DatapointValueMapCopier.copy(extendedStatistics);
        }

        @Override
        public Datapoint build() {
            return new Datapoint(this);
        }
    }
}
