/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAlarmHistoryRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeAlarmHistoryRequest.Builder, DescribeAlarmHistoryRequest> {
    private final String alarmName;

    private final String historyItemType;

    private final Date startDate;

    private final Date endDate;

    private final Integer maxRecords;

    private final String nextToken;

    private DescribeAlarmHistoryRequest(BuilderImpl builder) {
        this.alarmName = builder.alarmName;
        this.historyItemType = builder.historyItemType;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the alarm.
     * </p>
     * 
     * @return The name of the alarm.
     */
    public String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * The type of alarm histories to retrieve.
     * </p>
     * 
     * @return The type of alarm histories to retrieve.
     * @see HistoryItemType
     */
    public String historyItemType() {
        return historyItemType;
    }

    /**
     * <p>
     * The starting date to retrieve alarm history.
     * </p>
     * 
     * @return The starting date to retrieve alarm history.
     */
    public Date startDate() {
        return startDate;
    }

    /**
     * <p>
     * The ending date to retrieve alarm history.
     * </p>
     * 
     * @return The ending date to retrieve alarm history.
     */
    public Date endDate() {
        return endDate;
    }

    /**
     * <p>
     * The maximum number of alarm history records to retrieve.
     * </p>
     * 
     * @return The maximum number of alarm history records to retrieve.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * The token returned by a previous call to indicate that there is more data available.
     * </p>
     * 
     * @return The token returned by a previous call to indicate that there is more data available.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((alarmName() == null) ? 0 : alarmName().hashCode());
        hashCode = 31 * hashCode + ((historyItemType() == null) ? 0 : historyItemType().hashCode());
        hashCode = 31 * hashCode + ((startDate() == null) ? 0 : startDate().hashCode());
        hashCode = 31 * hashCode + ((endDate() == null) ? 0 : endDate().hashCode());
        hashCode = 31 * hashCode + ((maxRecords() == null) ? 0 : maxRecords().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmHistoryRequest)) {
            return false;
        }
        DescribeAlarmHistoryRequest other = (DescribeAlarmHistoryRequest) obj;
        if (other.alarmName() == null ^ this.alarmName() == null) {
            return false;
        }
        if (other.alarmName() != null && !other.alarmName().equals(this.alarmName())) {
            return false;
        }
        if (other.historyItemType() == null ^ this.historyItemType() == null) {
            return false;
        }
        if (other.historyItemType() != null && !other.historyItemType().equals(this.historyItemType())) {
            return false;
        }
        if (other.startDate() == null ^ this.startDate() == null) {
            return false;
        }
        if (other.startDate() != null && !other.startDate().equals(this.startDate())) {
            return false;
        }
        if (other.endDate() == null ^ this.endDate() == null) {
            return false;
        }
        if (other.endDate() != null && !other.endDate().equals(this.endDate())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (alarmName() != null) {
            sb.append("AlarmName: ").append(alarmName()).append(",");
        }
        if (historyItemType() != null) {
            sb.append("HistoryItemType: ").append(historyItemType()).append(",");
        }
        if (startDate() != null) {
            sb.append("StartDate: ").append(startDate()).append(",");
        }
        if (endDate() != null) {
            sb.append("EndDate: ").append(endDate()).append(",");
        }
        if (maxRecords() != null) {
            sb.append("MaxRecords: ").append(maxRecords()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeAlarmHistoryRequest> {
        /**
         * <p>
         * The name of the alarm.
         * </p>
         * 
         * @param alarmName
         *        The name of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * The type of alarm histories to retrieve.
         * </p>
         * 
         * @param historyItemType
         *        The type of alarm histories to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HistoryItemType
         */
        Builder historyItemType(String historyItemType);

        /**
         * <p>
         * The type of alarm histories to retrieve.
         * </p>
         * 
         * @param historyItemType
         *        The type of alarm histories to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HistoryItemType
         */
        Builder historyItemType(HistoryItemType historyItemType);

        /**
         * <p>
         * The starting date to retrieve alarm history.
         * </p>
         * 
         * @param startDate
         *        The starting date to retrieve alarm history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Date startDate);

        /**
         * <p>
         * The ending date to retrieve alarm history.
         * </p>
         * 
         * @param endDate
         *        The ending date to retrieve alarm history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Date endDate);

        /**
         * <p>
         * The maximum number of alarm history records to retrieve.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of alarm history records to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * The token returned by a previous call to indicate that there is more data available.
         * </p>
         * 
         * @param nextToken
         *        The token returned by a previous call to indicate that there is more data available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private String alarmName;

        private String historyItemType;

        private Date startDate;

        private Date endDate;

        private Integer maxRecords;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmHistoryRequest model) {
            setAlarmName(model.alarmName);
            setHistoryItemType(model.historyItemType);
            setStartDate(model.startDate);
            setEndDate(model.endDate);
            setMaxRecords(model.maxRecords);
            setNextToken(model.nextToken);
        }

        public final String getAlarmName() {
            return alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getHistoryItemType() {
            return historyItemType;
        }

        @Override
        public final Builder historyItemType(String historyItemType) {
            this.historyItemType = historyItemType;
            return this;
        }

        @Override
        public final Builder historyItemType(HistoryItemType historyItemType) {
            this.historyItemType(historyItemType.toString());
            return this;
        }

        public final void setHistoryItemType(String historyItemType) {
            this.historyItemType = historyItemType;
        }

        public final void setHistoryItemType(HistoryItemType historyItemType) {
            this.historyItemType(historyItemType.toString());
        }

        public final Date getStartDate() {
            return startDate;
        }

        @Override
        public final Builder startDate(Date startDate) {
            this.startDate = StandardMemberCopier.copy(startDate);
            return this;
        }

        public final void setStartDate(Date startDate) {
            this.startDate = StandardMemberCopier.copy(startDate);
        }

        public final Date getEndDate() {
            return endDate;
        }

        @Override
        public final Builder endDate(Date endDate) {
            this.endDate = StandardMemberCopier.copy(endDate);
            return this;
        }

        public final void setEndDate(Date endDate) {
            this.endDate = StandardMemberCopier.copy(endDate);
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAlarmHistoryRequest build() {
            return new DescribeAlarmHistoryRequest(this);
        }
    }
}
