/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAlarmsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeAlarmsRequest.Builder, DescribeAlarmsRequest> {
    private final List<String> alarmNames;

    private final String alarmNamePrefix;

    private final String stateValue;

    private final String actionPrefix;

    private final Integer maxRecords;

    private final String nextToken;

    private DescribeAlarmsRequest(BuilderImpl builder) {
        this.alarmNames = builder.alarmNames;
        this.alarmNamePrefix = builder.alarmNamePrefix;
        this.stateValue = builder.stateValue;
        this.actionPrefix = builder.actionPrefix;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The names of the alarms.
     * </p>
     * 
     * @return The names of the alarms.
     */
    public List<String> alarmNames() {
        return alarmNames;
    }

    /**
     * <p>
     * The alarm name prefix. You cannot specify <code>AlarmNames</code> if this parameter is specified.
     * </p>
     * 
     * @return The alarm name prefix. You cannot specify <code>AlarmNames</code> if this parameter is specified.
     */
    public String alarmNamePrefix() {
        return alarmNamePrefix;
    }

    /**
     * <p>
     * The state value to be used in matching alarms.
     * </p>
     * 
     * @return The state value to be used in matching alarms.
     * @see StateValue
     */
    public String stateValue() {
        return stateValue;
    }

    /**
     * <p>
     * The action name prefix.
     * </p>
     * 
     * @return The action name prefix.
     */
    public String actionPrefix() {
        return actionPrefix;
    }

    /**
     * <p>
     * The maximum number of alarm descriptions to retrieve.
     * </p>
     * 
     * @return The maximum number of alarm descriptions to retrieve.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * The token returned by a previous call to indicate that there is more data available.
     * </p>
     * 
     * @return The token returned by a previous call to indicate that there is more data available.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((alarmNames() == null) ? 0 : alarmNames().hashCode());
        hashCode = 31 * hashCode + ((alarmNamePrefix() == null) ? 0 : alarmNamePrefix().hashCode());
        hashCode = 31 * hashCode + ((stateValue() == null) ? 0 : stateValue().hashCode());
        hashCode = 31 * hashCode + ((actionPrefix() == null) ? 0 : actionPrefix().hashCode());
        hashCode = 31 * hashCode + ((maxRecords() == null) ? 0 : maxRecords().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmsRequest)) {
            return false;
        }
        DescribeAlarmsRequest other = (DescribeAlarmsRequest) obj;
        if (other.alarmNames() == null ^ this.alarmNames() == null) {
            return false;
        }
        if (other.alarmNames() != null && !other.alarmNames().equals(this.alarmNames())) {
            return false;
        }
        if (other.alarmNamePrefix() == null ^ this.alarmNamePrefix() == null) {
            return false;
        }
        if (other.alarmNamePrefix() != null && !other.alarmNamePrefix().equals(this.alarmNamePrefix())) {
            return false;
        }
        if (other.stateValue() == null ^ this.stateValue() == null) {
            return false;
        }
        if (other.stateValue() != null && !other.stateValue().equals(this.stateValue())) {
            return false;
        }
        if (other.actionPrefix() == null ^ this.actionPrefix() == null) {
            return false;
        }
        if (other.actionPrefix() != null && !other.actionPrefix().equals(this.actionPrefix())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (alarmNames() != null) {
            sb.append("AlarmNames: ").append(alarmNames()).append(",");
        }
        if (alarmNamePrefix() != null) {
            sb.append("AlarmNamePrefix: ").append(alarmNamePrefix()).append(",");
        }
        if (stateValue() != null) {
            sb.append("StateValue: ").append(stateValue()).append(",");
        }
        if (actionPrefix() != null) {
            sb.append("ActionPrefix: ").append(actionPrefix()).append(",");
        }
        if (maxRecords() != null) {
            sb.append("MaxRecords: ").append(maxRecords()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeAlarmsRequest> {
        /**
         * <p>
         * The names of the alarms.
         * </p>
         * 
         * @param alarmNames
         *        The names of the alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmNames(Collection<String> alarmNames);

        /**
         * <p>
         * The names of the alarms.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setAlarmNames(java.util.Collection)} or {@link #withAlarmNames(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param alarmNames
         *        The names of the alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmNames(String... alarmNames);

        /**
         * <p>
         * The alarm name prefix. You cannot specify <code>AlarmNames</code> if this parameter is specified.
         * </p>
         * 
         * @param alarmNamePrefix
         *        The alarm name prefix. You cannot specify <code>AlarmNames</code> if this parameter is specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmNamePrefix(String alarmNamePrefix);

        /**
         * <p>
         * The state value to be used in matching alarms.
         * </p>
         * 
         * @param stateValue
         *        The state value to be used in matching alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateValue
         */
        Builder stateValue(String stateValue);

        /**
         * <p>
         * The state value to be used in matching alarms.
         * </p>
         * 
         * @param stateValue
         *        The state value to be used in matching alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateValue
         */
        Builder stateValue(StateValue stateValue);

        /**
         * <p>
         * The action name prefix.
         * </p>
         * 
         * @param actionPrefix
         *        The action name prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionPrefix(String actionPrefix);

        /**
         * <p>
         * The maximum number of alarm descriptions to retrieve.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of alarm descriptions to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * The token returned by a previous call to indicate that there is more data available.
         * </p>
         * 
         * @param nextToken
         *        The token returned by a previous call to indicate that there is more data available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> alarmNames = new SdkInternalList<>();

        private String alarmNamePrefix;

        private String stateValue;

        private String actionPrefix;

        private Integer maxRecords;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmsRequest model) {
            setAlarmNames(model.alarmNames);
            setAlarmNamePrefix(model.alarmNamePrefix);
            setStateValue(model.stateValue);
            setActionPrefix(model.actionPrefix);
            setMaxRecords(model.maxRecords);
            setNextToken(model.nextToken);
        }

        public final Collection<String> getAlarmNames() {
            return alarmNames;
        }

        @Override
        public final Builder alarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmNames(String... alarmNames) {
            if (this.alarmNames == null) {
                this.alarmNames = new SdkInternalList<>(alarmNames.length);
            }
            for (String e : alarmNames) {
                this.alarmNames.add(e);
            }
            return this;
        }

        public final void setAlarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
        }

        @SafeVarargs
        public final void setAlarmNames(String... alarmNames) {
            if (this.alarmNames == null) {
                this.alarmNames = new SdkInternalList<>(alarmNames.length);
            }
            for (String e : alarmNames) {
                this.alarmNames.add(e);
            }
        }

        public final String getAlarmNamePrefix() {
            return alarmNamePrefix;
        }

        @Override
        public final Builder alarmNamePrefix(String alarmNamePrefix) {
            this.alarmNamePrefix = alarmNamePrefix;
            return this;
        }

        public final void setAlarmNamePrefix(String alarmNamePrefix) {
            this.alarmNamePrefix = alarmNamePrefix;
        }

        public final String getStateValue() {
            return stateValue;
        }

        @Override
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        @Override
        public final Builder stateValue(StateValue stateValue) {
            this.stateValue(stateValue.toString());
            return this;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        public final void setStateValue(StateValue stateValue) {
            this.stateValue(stateValue.toString());
        }

        public final String getActionPrefix() {
            return actionPrefix;
        }

        @Override
        public final Builder actionPrefix(String actionPrefix) {
            this.actionPrefix = actionPrefix;
            return this;
        }

        public final void setActionPrefix(String actionPrefix) {
            this.actionPrefix = actionPrefix;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAlarmsRequest build() {
            return new DescribeAlarmsRequest(this);
        }
    }
}
