/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutMetricAlarmRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutMetricAlarmRequest.Builder, PutMetricAlarmRequest> {
    private final String alarmName;

    private final String alarmDescription;

    private final Boolean actionsEnabled;

    private final List<String> okActions;

    private final List<String> alarmActions;

    private final List<String> insufficientDataActions;

    private final String metricName;

    private final String namespace;

    private final String statistic;

    private final String extendedStatistic;

    private final List<Dimension> dimensions;

    private final Integer period;

    private final String unit;

    private final Integer evaluationPeriods;

    private final Double threshold;

    private final String comparisonOperator;

    private final String treatMissingData;

    private final String evaluateLowSampleCountPercentile;

    private PutMetricAlarmRequest(BuilderImpl builder) {
        this.alarmName = builder.alarmName;
        this.alarmDescription = builder.alarmDescription;
        this.actionsEnabled = builder.actionsEnabled;
        this.okActions = builder.okActions;
        this.alarmActions = builder.alarmActions;
        this.insufficientDataActions = builder.insufficientDataActions;
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
        this.statistic = builder.statistic;
        this.extendedStatistic = builder.extendedStatistic;
        this.dimensions = builder.dimensions;
        this.period = builder.period;
        this.unit = builder.unit;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.threshold = builder.threshold;
        this.comparisonOperator = builder.comparisonOperator;
        this.treatMissingData = builder.treatMissingData;
        this.evaluateLowSampleCountPercentile = builder.evaluateLowSampleCountPercentile;
    }

    /**
     * <p>
     * The name for the alarm. This name must be unique within the AWS account.
     * </p>
     * 
     * @return The name for the alarm. This name must be unique within the AWS account.
     */
    public String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * The description for the alarm.
     * </p>
     * 
     * @return The description for the alarm.
     */
    public String alarmDescription() {
        return alarmDescription;
    }

    /**
     * <p>
     * Indicates whether actions should be executed during any changes to the alarm state.
     * </p>
     * 
     * @return Indicates whether actions should be executed during any changes to the alarm state.
     */
    public Boolean actionsEnabled() {
        return actionsEnabled;
    }

    /**
     * <p>
     * The actions to execute when this alarm transitions to an <code>OK</code> state from any other state. Each action
     * is specified as an Amazon Resource Name (ARN).
     * </p>
     * <p>
     * Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
     * arn:aws:automate:<i>region</i>:ec2:recover
     * </p>
     * <p>
     * Valid Values (for use with IAM roles):
     * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
     * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
     * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
     * </p>
     * 
     * @return The actions to execute when this alarm transitions to an <code>OK</code> state from any other state. Each
     *         action is specified as an Amazon Resource Name (ARN).</p>
     *         <p>
     *         Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
     *         arn:aws:automate:<i>region</i>:ec2:recover
     *         </p>
     *         <p>
     *         Valid Values (for use with IAM roles):
     *         arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
     *         arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
     *         arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
     */
    public List<String> okActions() {
        return okActions;
    }

    /**
     * <p>
     * The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state. Each
     * action is specified as an Amazon Resource Name (ARN).
     * </p>
     * <p>
     * Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
     * arn:aws:automate:<i>region</i>:ec2:recover
     * </p>
     * <p>
     * Valid Values (for use with IAM roles):
     * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
     * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
     * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
     * </p>
     * 
     * @return The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state.
     *         Each action is specified as an Amazon Resource Name (ARN).</p>
     *         <p>
     *         Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
     *         arn:aws:automate:<i>region</i>:ec2:recover
     *         </p>
     *         <p>
     *         Valid Values (for use with IAM roles):
     *         arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
     *         arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
     *         arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
     */
    public List<String> alarmActions() {
        return alarmActions;
    }

    /**
     * <p>
     * The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other
     * state. Each action is specified as an Amazon Resource Name (ARN).
     * </p>
     * <p>
     * Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
     * arn:aws:automate:<i>region</i>:ec2:recover
     * </p>
     * <p>
     * Valid Values (for use with IAM roles):
     * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
     * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
     * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
     * </p>
     * 
     * @return The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any
     *         other state. Each action is specified as an Amazon Resource Name (ARN).</p>
     *         <p>
     *         Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
     *         arn:aws:automate:<i>region</i>:ec2:recover
     *         </p>
     *         <p>
     *         Valid Values (for use with IAM roles):
     *         arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
     *         arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
     *         arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
     */
    public List<String> insufficientDataActions() {
        return insufficientDataActions;
    }

    /**
     * <p>
     * The name for the metric associated with the alarm.
     * </p>
     * 
     * @return The name for the metric associated with the alarm.
     */
    public String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The namespace for the metric associated with the alarm.
     * </p>
     * 
     * @return The namespace for the metric associated with the alarm.
     */
    public String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use
     * <code>ExtendedStatistic</code>.
     * </p>
     * 
     * @return The statistic for the metric associated with the alarm, other than percentile. For percentile statistics,
     *         use <code>ExtendedStatistic</code>.
     * @see Statistic
     */
    public String statistic() {
        return statistic;
    }

    /**
     * <p>
     * The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
     * </p>
     * 
     * @return The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
     */
    public String extendedStatistic() {
        return extendedStatistic;
    }

    /**
     * <p>
     * The dimensions for the metric associated with the alarm.
     * </p>
     * 
     * @return The dimensions for the metric associated with the alarm.
     */
    public List<Dimension> dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The period, in seconds, over which the specified statistic is applied.
     * </p>
     * 
     * @return The period, in seconds, over which the specified statistic is applied.
     */
    public Integer period() {
        return period;
    }

    /**
     * <p>
     * The unit of measure for the statistic. For example, the units for the Amazon EC2 NetworkIn metric are Bytes
     * because NetworkIn tracks the number of bytes that an instance receives on all network interfaces. You can also
     * specify a unit when you create a custom metric. Units help provide conceptual meaning to your data. Metric data
     * points that specify a unit of measure, such as Percent, are aggregated separately.
     * </p>
     * <p>
     * If you specify a unit, you must use a unit that is appropriate for the metric. Otherwise, the Amazon CloudWatch
     * alarm can get stuck in the <code>INSUFFICIENT DATA</code> state.
     * </p>
     * 
     * @return The unit of measure for the statistic. For example, the units for the Amazon EC2 NetworkIn metric are
     *         Bytes because NetworkIn tracks the number of bytes that an instance receives on all network interfaces.
     *         You can also specify a unit when you create a custom metric. Units help provide conceptual meaning to
     *         your data. Metric data points that specify a unit of measure, such as Percent, are aggregated
     *         separately.</p>
     *         <p>
     *         If you specify a unit, you must use a unit that is appropriate for the metric. Otherwise, the Amazon
     *         CloudWatch alarm can get stuck in the <code>INSUFFICIENT DATA</code> state.
     * @see StandardUnit
     */
    public String unit() {
        return unit;
    }

    /**
     * <p>
     * The number of periods over which data is compared to the specified threshold.
     * </p>
     * 
     * @return The number of periods over which data is compared to the specified threshold.
     */
    public Integer evaluationPeriods() {
        return evaluationPeriods;
    }

    /**
     * <p>
     * The value against which the specified statistic is compared.
     * </p>
     * 
     * @return The value against which the specified statistic is compared.
     */
    public Double threshold() {
        return threshold;
    }

    /**
     * <p>
     * The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic
     * value is used as the first operand.
     * </p>
     * 
     * @return The arithmetic operation to use when comparing the specified statistic and threshold. The specified
     *         statistic value is used as the first operand.
     * @see ComparisonOperator
     */
    public String comparisonOperator() {
        return comparisonOperator;
    }

    /**
     * <p>
     * Sets how this alarm is to handle missing data points. If <code>TreatMissingData</code> is omitted, the default
     * behavior of <code>missing</code> is used. For more information, see <a href=
     * "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data"
     * >Configuring How CloudWatch Alarms Treats Missing Data</a>.
     * </p>
     * <p>
     * Valid Values: <code>breaching | notBreaching | ignore | missing</code>
     * </p>
     * 
     * @return Sets how this alarm is to handle missing data points. If <code>TreatMissingData</code> is omitted, the
     *         default behavior of <code>missing</code> is used. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data"
     *         >Configuring How CloudWatch Alarms Treats Missing Data</a>.</p>
     *         <p>
     *         Valid Values: <code>breaching | notBreaching | ignore | missing</code>
     */
    public String treatMissingData() {
        return treatMissingData;
    }

    /**
     * <p>
     * Used only for alarms based on percentiles. If you specify <code>ignore</code>, the alarm state will not change
     * during periods with too few data points to be statistically significant. If you specify <code>evaluate</code> or
     * omit this parameter, the alarm will always be evaluated and possibly change state no matter how many data points
     * are available. For more information, see <a href=
     * "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#percentiles-with-low-samples"
     * >Percentile-Based CloudWatch Alarms and Low Data Samples</a>.
     * </p>
     * <p>
     * Valid Values: <code>evaluate | ignore</code>
     * </p>
     * 
     * @return Used only for alarms based on percentiles. If you specify <code>ignore</code>, the alarm state will not
     *         change during periods with too few data points to be statistically significant. If you specify
     *         <code>evaluate</code> or omit this parameter, the alarm will always be evaluated and possibly change
     *         state no matter how many data points are available. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#percentiles-with-low-samples"
     *         >Percentile-Based CloudWatch Alarms and Low Data Samples</a>.</p>
     *         <p>
     *         Valid Values: <code>evaluate | ignore</code>
     */
    public String evaluateLowSampleCountPercentile() {
        return evaluateLowSampleCountPercentile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((alarmName() == null) ? 0 : alarmName().hashCode());
        hashCode = 31 * hashCode + ((alarmDescription() == null) ? 0 : alarmDescription().hashCode());
        hashCode = 31 * hashCode + ((actionsEnabled() == null) ? 0 : actionsEnabled().hashCode());
        hashCode = 31 * hashCode + ((okActions() == null) ? 0 : okActions().hashCode());
        hashCode = 31 * hashCode + ((alarmActions() == null) ? 0 : alarmActions().hashCode());
        hashCode = 31 * hashCode + ((insufficientDataActions() == null) ? 0 : insufficientDataActions().hashCode());
        hashCode = 31 * hashCode + ((metricName() == null) ? 0 : metricName().hashCode());
        hashCode = 31 * hashCode + ((namespace() == null) ? 0 : namespace().hashCode());
        hashCode = 31 * hashCode + ((statistic() == null) ? 0 : statistic().hashCode());
        hashCode = 31 * hashCode + ((extendedStatistic() == null) ? 0 : extendedStatistic().hashCode());
        hashCode = 31 * hashCode + ((dimensions() == null) ? 0 : dimensions().hashCode());
        hashCode = 31 * hashCode + ((period() == null) ? 0 : period().hashCode());
        hashCode = 31 * hashCode + ((unit() == null) ? 0 : unit().hashCode());
        hashCode = 31 * hashCode + ((evaluationPeriods() == null) ? 0 : evaluationPeriods().hashCode());
        hashCode = 31 * hashCode + ((threshold() == null) ? 0 : threshold().hashCode());
        hashCode = 31 * hashCode + ((comparisonOperator() == null) ? 0 : comparisonOperator().hashCode());
        hashCode = 31 * hashCode + ((treatMissingData() == null) ? 0 : treatMissingData().hashCode());
        hashCode = 31 * hashCode
                + ((evaluateLowSampleCountPercentile() == null) ? 0 : evaluateLowSampleCountPercentile().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricAlarmRequest)) {
            return false;
        }
        PutMetricAlarmRequest other = (PutMetricAlarmRequest) obj;
        if (other.alarmName() == null ^ this.alarmName() == null) {
            return false;
        }
        if (other.alarmName() != null && !other.alarmName().equals(this.alarmName())) {
            return false;
        }
        if (other.alarmDescription() == null ^ this.alarmDescription() == null) {
            return false;
        }
        if (other.alarmDescription() != null && !other.alarmDescription().equals(this.alarmDescription())) {
            return false;
        }
        if (other.actionsEnabled() == null ^ this.actionsEnabled() == null) {
            return false;
        }
        if (other.actionsEnabled() != null && !other.actionsEnabled().equals(this.actionsEnabled())) {
            return false;
        }
        if (other.okActions() == null ^ this.okActions() == null) {
            return false;
        }
        if (other.okActions() != null && !other.okActions().equals(this.okActions())) {
            return false;
        }
        if (other.alarmActions() == null ^ this.alarmActions() == null) {
            return false;
        }
        if (other.alarmActions() != null && !other.alarmActions().equals(this.alarmActions())) {
            return false;
        }
        if (other.insufficientDataActions() == null ^ this.insufficientDataActions() == null) {
            return false;
        }
        if (other.insufficientDataActions() != null && !other.insufficientDataActions().equals(this.insufficientDataActions())) {
            return false;
        }
        if (other.metricName() == null ^ this.metricName() == null) {
            return false;
        }
        if (other.metricName() != null && !other.metricName().equals(this.metricName())) {
            return false;
        }
        if (other.namespace() == null ^ this.namespace() == null) {
            return false;
        }
        if (other.namespace() != null && !other.namespace().equals(this.namespace())) {
            return false;
        }
        if (other.statistic() == null ^ this.statistic() == null) {
            return false;
        }
        if (other.statistic() != null && !other.statistic().equals(this.statistic())) {
            return false;
        }
        if (other.extendedStatistic() == null ^ this.extendedStatistic() == null) {
            return false;
        }
        if (other.extendedStatistic() != null && !other.extendedStatistic().equals(this.extendedStatistic())) {
            return false;
        }
        if (other.dimensions() == null ^ this.dimensions() == null) {
            return false;
        }
        if (other.dimensions() != null && !other.dimensions().equals(this.dimensions())) {
            return false;
        }
        if (other.period() == null ^ this.period() == null) {
            return false;
        }
        if (other.period() != null && !other.period().equals(this.period())) {
            return false;
        }
        if (other.unit() == null ^ this.unit() == null) {
            return false;
        }
        if (other.unit() != null && !other.unit().equals(this.unit())) {
            return false;
        }
        if (other.evaluationPeriods() == null ^ this.evaluationPeriods() == null) {
            return false;
        }
        if (other.evaluationPeriods() != null && !other.evaluationPeriods().equals(this.evaluationPeriods())) {
            return false;
        }
        if (other.threshold() == null ^ this.threshold() == null) {
            return false;
        }
        if (other.threshold() != null && !other.threshold().equals(this.threshold())) {
            return false;
        }
        if (other.comparisonOperator() == null ^ this.comparisonOperator() == null) {
            return false;
        }
        if (other.comparisonOperator() != null && !other.comparisonOperator().equals(this.comparisonOperator())) {
            return false;
        }
        if (other.treatMissingData() == null ^ this.treatMissingData() == null) {
            return false;
        }
        if (other.treatMissingData() != null && !other.treatMissingData().equals(this.treatMissingData())) {
            return false;
        }
        if (other.evaluateLowSampleCountPercentile() == null ^ this.evaluateLowSampleCountPercentile() == null) {
            return false;
        }
        if (other.evaluateLowSampleCountPercentile() != null
                && !other.evaluateLowSampleCountPercentile().equals(this.evaluateLowSampleCountPercentile())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (alarmName() != null) {
            sb.append("AlarmName: ").append(alarmName()).append(",");
        }
        if (alarmDescription() != null) {
            sb.append("AlarmDescription: ").append(alarmDescription()).append(",");
        }
        if (actionsEnabled() != null) {
            sb.append("ActionsEnabled: ").append(actionsEnabled()).append(",");
        }
        if (okActions() != null) {
            sb.append("OKActions: ").append(okActions()).append(",");
        }
        if (alarmActions() != null) {
            sb.append("AlarmActions: ").append(alarmActions()).append(",");
        }
        if (insufficientDataActions() != null) {
            sb.append("InsufficientDataActions: ").append(insufficientDataActions()).append(",");
        }
        if (metricName() != null) {
            sb.append("MetricName: ").append(metricName()).append(",");
        }
        if (namespace() != null) {
            sb.append("Namespace: ").append(namespace()).append(",");
        }
        if (statistic() != null) {
            sb.append("Statistic: ").append(statistic()).append(",");
        }
        if (extendedStatistic() != null) {
            sb.append("ExtendedStatistic: ").append(extendedStatistic()).append(",");
        }
        if (dimensions() != null) {
            sb.append("Dimensions: ").append(dimensions()).append(",");
        }
        if (period() != null) {
            sb.append("Period: ").append(period()).append(",");
        }
        if (unit() != null) {
            sb.append("Unit: ").append(unit()).append(",");
        }
        if (evaluationPeriods() != null) {
            sb.append("EvaluationPeriods: ").append(evaluationPeriods()).append(",");
        }
        if (threshold() != null) {
            sb.append("Threshold: ").append(threshold()).append(",");
        }
        if (comparisonOperator() != null) {
            sb.append("ComparisonOperator: ").append(comparisonOperator()).append(",");
        }
        if (treatMissingData() != null) {
            sb.append("TreatMissingData: ").append(treatMissingData()).append(",");
        }
        if (evaluateLowSampleCountPercentile() != null) {
            sb.append("EvaluateLowSampleCountPercentile: ").append(evaluateLowSampleCountPercentile()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutMetricAlarmRequest> {
        /**
         * <p>
         * The name for the alarm. This name must be unique within the AWS account.
         * </p>
         * 
         * @param alarmName
         *        The name for the alarm. This name must be unique within the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * The description for the alarm.
         * </p>
         * 
         * @param alarmDescription
         *        The description for the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmDescription(String alarmDescription);

        /**
         * <p>
         * Indicates whether actions should be executed during any changes to the alarm state.
         * </p>
         * 
         * @param actionsEnabled
         *        Indicates whether actions should be executed during any changes to the alarm state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsEnabled(Boolean actionsEnabled);

        /**
         * <p>
         * The actions to execute when this alarm transitions to an <code>OK</code> state from any other state. Each
         * action is specified as an Amazon Resource Name (ARN).
         * </p>
         * <p>
         * Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         * arn:aws:automate:<i>region</i>:ec2:recover
         * </p>
         * <p>
         * Valid Values (for use with IAM roles):
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * </p>
         * 
         * @param okActions
         *        The actions to execute when this alarm transitions to an <code>OK</code> state from any other state.
         *        Each action is specified as an Amazon Resource Name (ARN).</p>
         *        <p>
         *        Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         *        arn:aws:automate:<i>region</i>:ec2:recover
         *        </p>
         *        <p>
         *        Valid Values (for use with IAM roles):
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder okActions(Collection<String> okActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to an <code>OK</code> state from any other state. Each
         * action is specified as an Amazon Resource Name (ARN).
         * </p>
         * <p>
         * Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         * arn:aws:automate:<i>region</i>:ec2:recover
         * </p>
         * <p>
         * Valid Values (for use with IAM roles):
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setOKActions(java.util.Collection)} or {@link #withOKActions(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param okActions
         *        The actions to execute when this alarm transitions to an <code>OK</code> state from any other state.
         *        Each action is specified as an Amazon Resource Name (ARN).</p>
         *        <p>
         *        Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         *        arn:aws:automate:<i>region</i>:ec2:recover
         *        </p>
         *        <p>
         *        Valid Values (for use with IAM roles):
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder okActions(String... okActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state. Each
         * action is specified as an Amazon Resource Name (ARN).
         * </p>
         * <p>
         * Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         * arn:aws:automate:<i>region</i>:ec2:recover
         * </p>
         * <p>
         * Valid Values (for use with IAM roles):
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * </p>
         * 
         * @param alarmActions
         *        The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other
         *        state. Each action is specified as an Amazon Resource Name (ARN).</p>
         *        <p>
         *        Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         *        arn:aws:automate:<i>region</i>:ec2:recover
         *        </p>
         *        <p>
         *        Valid Values (for use with IAM roles):
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmActions(Collection<String> alarmActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state. Each
         * action is specified as an Amazon Resource Name (ARN).
         * </p>
         * <p>
         * Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         * arn:aws:automate:<i>region</i>:ec2:recover
         * </p>
         * <p>
         * Valid Values (for use with IAM roles):
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setAlarmActions(java.util.Collection)} or {@link #withAlarmActions(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param alarmActions
         *        The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other
         *        state. Each action is specified as an Amazon Resource Name (ARN).</p>
         *        <p>
         *        Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         *        arn:aws:automate:<i>region</i>:ec2:recover
         *        </p>
         *        <p>
         *        Valid Values (for use with IAM roles):
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmActions(String... alarmActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other
         * state. Each action is specified as an Amazon Resource Name (ARN).
         * </p>
         * <p>
         * Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         * arn:aws:automate:<i>region</i>:ec2:recover
         * </p>
         * <p>
         * Valid Values (for use with IAM roles):
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * </p>
         * 
         * @param insufficientDataActions
         *        The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from
         *        any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
         *        <p>
         *        Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         *        arn:aws:automate:<i>region</i>:ec2:recover
         *        </p>
         *        <p>
         *        Valid Values (for use with IAM roles):
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insufficientDataActions(Collection<String> insufficientDataActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other
         * state. Each action is specified as an Amazon Resource Name (ARN).
         * </p>
         * <p>
         * Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         * arn:aws:automate:<i>region</i>:ec2:recover
         * </p>
         * <p>
         * Valid Values (for use with IAM roles):
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInsufficientDataActions(java.util.Collection)} or
         * {@link #withInsufficientDataActions(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param insufficientDataActions
         *        The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from
         *        any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
         *        <p>
         *        Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         *        arn:aws:automate:<i>region</i>:ec2:recover
         *        </p>
         *        <p>
         *        Valid Values (for use with IAM roles):
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insufficientDataActions(String... insufficientDataActions);

        /**
         * <p>
         * The name for the metric associated with the alarm.
         * </p>
         * 
         * @param metricName
         *        The name for the metric associated with the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The namespace for the metric associated with the alarm.
         * </p>
         * 
         * @param namespace
         *        The namespace for the metric associated with the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use
         * <code>ExtendedStatistic</code>.
         * </p>
         * 
         * @param statistic
         *        The statistic for the metric associated with the alarm, other than percentile. For percentile
         *        statistics, use <code>ExtendedStatistic</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Statistic
         */
        Builder statistic(String statistic);

        /**
         * <p>
         * The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use
         * <code>ExtendedStatistic</code>.
         * </p>
         * 
         * @param statistic
         *        The statistic for the metric associated with the alarm, other than percentile. For percentile
         *        statistics, use <code>ExtendedStatistic</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Statistic
         */
        Builder statistic(Statistic statistic);

        /**
         * <p>
         * The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
         * </p>
         * 
         * @param extendedStatistic
         *        The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and
         *        p100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedStatistic(String extendedStatistic);

        /**
         * <p>
         * The dimensions for the metric associated with the alarm.
         * </p>
         * 
         * @param dimensions
         *        The dimensions for the metric associated with the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<Dimension> dimensions);

        /**
         * <p>
         * The dimensions for the metric associated with the alarm.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDimensions(java.util.Collection)} or {@link #withDimensions(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param dimensions
         *        The dimensions for the metric associated with the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Dimension... dimensions);

        /**
         * <p>
         * The period, in seconds, over which the specified statistic is applied.
         * </p>
         * 
         * @param period
         *        The period, in seconds, over which the specified statistic is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * <p>
         * The unit of measure for the statistic. For example, the units for the Amazon EC2 NetworkIn metric are Bytes
         * because NetworkIn tracks the number of bytes that an instance receives on all network interfaces. You can
         * also specify a unit when you create a custom metric. Units help provide conceptual meaning to your data.
         * Metric data points that specify a unit of measure, such as Percent, are aggregated separately.
         * </p>
         * <p>
         * If you specify a unit, you must use a unit that is appropriate for the metric. Otherwise, the Amazon
         * CloudWatch alarm can get stuck in the <code>INSUFFICIENT DATA</code> state.
         * </p>
         * 
         * @param unit
         *        The unit of measure for the statistic. For example, the units for the Amazon EC2 NetworkIn metric are
         *        Bytes because NetworkIn tracks the number of bytes that an instance receives on all network
         *        interfaces. You can also specify a unit when you create a custom metric. Units help provide conceptual
         *        meaning to your data. Metric data points that specify a unit of measure, such as Percent, are
         *        aggregated separately.</p>
         *        <p>
         *        If you specify a unit, you must use a unit that is appropriate for the metric. Otherwise, the Amazon
         *        CloudWatch alarm can get stuck in the <code>INSUFFICIENT DATA</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit of measure for the statistic. For example, the units for the Amazon EC2 NetworkIn metric are Bytes
         * because NetworkIn tracks the number of bytes that an instance receives on all network interfaces. You can
         * also specify a unit when you create a custom metric. Units help provide conceptual meaning to your data.
         * Metric data points that specify a unit of measure, such as Percent, are aggregated separately.
         * </p>
         * <p>
         * If you specify a unit, you must use a unit that is appropriate for the metric. Otherwise, the Amazon
         * CloudWatch alarm can get stuck in the <code>INSUFFICIENT DATA</code> state.
         * </p>
         * 
         * @param unit
         *        The unit of measure for the statistic. For example, the units for the Amazon EC2 NetworkIn metric are
         *        Bytes because NetworkIn tracks the number of bytes that an instance receives on all network
         *        interfaces. You can also specify a unit when you create a custom metric. Units help provide conceptual
         *        meaning to your data. Metric data points that specify a unit of measure, such as Percent, are
         *        aggregated separately.</p>
         *        <p>
         *        If you specify a unit, you must use a unit that is appropriate for the metric. Otherwise, the Amazon
         *        CloudWatch alarm can get stuck in the <code>INSUFFICIENT DATA</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardUnit
         */
        Builder unit(StandardUnit unit);

        /**
         * <p>
         * The number of periods over which data is compared to the specified threshold.
         * </p>
         * 
         * @param evaluationPeriods
         *        The number of periods over which data is compared to the specified threshold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationPeriods(Integer evaluationPeriods);

        /**
         * <p>
         * The value against which the specified statistic is compared.
         * </p>
         * 
         * @param threshold
         *        The value against which the specified statistic is compared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Double threshold);

        /**
         * <p>
         * The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic
         * value is used as the first operand.
         * </p>
         * 
         * @param comparisonOperator
         *        The arithmetic operation to use when comparing the specified statistic and threshold. The specified
         *        statistic value is used as the first operand.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(String comparisonOperator);

        /**
         * <p>
         * The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic
         * value is used as the first operand.
         * </p>
         * 
         * @param comparisonOperator
         *        The arithmetic operation to use when comparing the specified statistic and threshold. The specified
         *        statistic value is used as the first operand.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(ComparisonOperator comparisonOperator);

        /**
         * <p>
         * Sets how this alarm is to handle missing data points. If <code>TreatMissingData</code> is omitted, the
         * default behavior of <code>missing</code> is used. For more information, see <a href=
         * "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data"
         * >Configuring How CloudWatch Alarms Treats Missing Data</a>.
         * </p>
         * <p>
         * Valid Values: <code>breaching | notBreaching | ignore | missing</code>
         * </p>
         * 
         * @param treatMissingData
         *        Sets how this alarm is to handle missing data points. If <code>TreatMissingData</code> is omitted, the
         *        default behavior of <code>missing</code> is used. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data"
         *        >Configuring How CloudWatch Alarms Treats Missing Data</a>.</p>
         *        <p>
         *        Valid Values: <code>breaching | notBreaching | ignore | missing</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatMissingData(String treatMissingData);

        /**
         * <p>
         * Used only for alarms based on percentiles. If you specify <code>ignore</code>, the alarm state will not
         * change during periods with too few data points to be statistically significant. If you specify
         * <code>evaluate</code> or omit this parameter, the alarm will always be evaluated and possibly change state no
         * matter how many data points are available. For more information, see <a href=
         * "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#percentiles-with-low-samples"
         * >Percentile-Based CloudWatch Alarms and Low Data Samples</a>.
         * </p>
         * <p>
         * Valid Values: <code>evaluate | ignore</code>
         * </p>
         * 
         * @param evaluateLowSampleCountPercentile
         *        Used only for alarms based on percentiles. If you specify <code>ignore</code>, the alarm state will
         *        not change during periods with too few data points to be statistically significant. If you specify
         *        <code>evaluate</code> or omit this parameter, the alarm will always be evaluated and possibly change
         *        state no matter how many data points are available. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#percentiles-with-low-samples"
         *        >Percentile-Based CloudWatch Alarms and Low Data Samples</a>.</p>
         *        <p>
         *        Valid Values: <code>evaluate | ignore</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile);
    }

    private static final class BuilderImpl implements Builder {
        private String alarmName;

        private String alarmDescription;

        private Boolean actionsEnabled;

        private List<String> okActions = new SdkInternalList<>();

        private List<String> alarmActions = new SdkInternalList<>();

        private List<String> insufficientDataActions = new SdkInternalList<>();

        private String metricName;

        private String namespace;

        private String statistic;

        private String extendedStatistic;

        private List<Dimension> dimensions = new SdkInternalList<>();

        private Integer period;

        private String unit;

        private Integer evaluationPeriods;

        private Double threshold;

        private String comparisonOperator;

        private String treatMissingData;

        private String evaluateLowSampleCountPercentile;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetricAlarmRequest model) {
            setAlarmName(model.alarmName);
            setAlarmDescription(model.alarmDescription);
            setActionsEnabled(model.actionsEnabled);
            setOKActions(model.okActions);
            setAlarmActions(model.alarmActions);
            setInsufficientDataActions(model.insufficientDataActions);
            setMetricName(model.metricName);
            setNamespace(model.namespace);
            setStatistic(model.statistic);
            setExtendedStatistic(model.extendedStatistic);
            setDimensions(model.dimensions);
            setPeriod(model.period);
            setUnit(model.unit);
            setEvaluationPeriods(model.evaluationPeriods);
            setThreshold(model.threshold);
            setComparisonOperator(model.comparisonOperator);
            setTreatMissingData(model.treatMissingData);
            setEvaluateLowSampleCountPercentile(model.evaluateLowSampleCountPercentile);
        }

        public final String getAlarmName() {
            return alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getAlarmDescription() {
            return alarmDescription;
        }

        @Override
        public final Builder alarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
            return this;
        }

        public final void setAlarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
        }

        public final Boolean getActionsEnabled() {
            return actionsEnabled;
        }

        @Override
        public final Builder actionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        public final void setActionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
        }

        public final Collection<String> getOKActions() {
            return okActions;
        }

        @Override
        public final Builder okActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder okActions(String... okActions) {
            if (this.okActions == null) {
                this.okActions = new SdkInternalList<>(okActions.length);
            }
            for (String e : okActions) {
                this.okActions.add(e);
            }
            return this;
        }

        public final void setOKActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
        }

        @SafeVarargs
        public final void setOKActions(String... okActions) {
            if (this.okActions == null) {
                this.okActions = new SdkInternalList<>(okActions.length);
            }
            for (String e : okActions) {
                this.okActions.add(e);
            }
        }

        public final Collection<String> getAlarmActions() {
            return alarmActions;
        }

        @Override
        public final Builder alarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmActions(String... alarmActions) {
            if (this.alarmActions == null) {
                this.alarmActions = new SdkInternalList<>(alarmActions.length);
            }
            for (String e : alarmActions) {
                this.alarmActions.add(e);
            }
            return this;
        }

        public final void setAlarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
        }

        @SafeVarargs
        public final void setAlarmActions(String... alarmActions) {
            if (this.alarmActions == null) {
                this.alarmActions = new SdkInternalList<>(alarmActions.length);
            }
            for (String e : alarmActions) {
                this.alarmActions.add(e);
            }
        }

        public final Collection<String> getInsufficientDataActions() {
            return insufficientDataActions;
        }

        @Override
        public final Builder insufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insufficientDataActions(String... insufficientDataActions) {
            if (this.insufficientDataActions == null) {
                this.insufficientDataActions = new SdkInternalList<>(insufficientDataActions.length);
            }
            for (String e : insufficientDataActions) {
                this.insufficientDataActions.add(e);
            }
            return this;
        }

        public final void setInsufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
        }

        @SafeVarargs
        public final void setInsufficientDataActions(String... insufficientDataActions) {
            if (this.insufficientDataActions == null) {
                this.insufficientDataActions = new SdkInternalList<>(insufficientDataActions.length);
            }
            for (String e : insufficientDataActions) {
                this.insufficientDataActions.add(e);
            }
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getStatistic() {
            return statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(Statistic statistic) {
            this.statistic(statistic.toString());
            return this;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        public final void setStatistic(Statistic statistic) {
            this.statistic(statistic.toString());
        }

        public final String getExtendedStatistic() {
            return extendedStatistic;
        }

        @Override
        public final Builder extendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
            return this;
        }

        public final void setExtendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
        }

        public final Collection<Dimension> getDimensions() {
            return dimensions;
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension... dimensions) {
            if (this.dimensions == null) {
                this.dimensions = new SdkInternalList<>(dimensions.length);
            }
            for (Dimension e : dimensions) {
                this.dimensions.add(e);
            }
            return this;
        }

        public final void setDimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
        }

        @SafeVarargs
        public final void setDimensions(Dimension... dimensions) {
            if (this.dimensions == null) {
                this.dimensions = new SdkInternalList<>(dimensions.length);
            }
            for (Dimension e : dimensions) {
                this.dimensions.add(e);
            }
        }

        public final Integer getPeriod() {
            return period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final String getUnit() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final void setUnit(StandardUnit unit) {
            this.unit(unit.toString());
        }

        public final Integer getEvaluationPeriods() {
            return evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        public final Double getThreshold() {
            return threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public final String getComparisonOperator() {
            return comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final void setComparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
        }

        public final String getTreatMissingData() {
            return treatMissingData;
        }

        @Override
        public final Builder treatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        public final void setTreatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
        }

        public final String getEvaluateLowSampleCountPercentile() {
            return evaluateLowSampleCountPercentile;
        }

        @Override
        public final Builder evaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
            return this;
        }

        public final void setEvaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
        }

        @Override
        public PutMetricAlarmRequest build() {
            return new PutMetricAlarmRequest(this);
        }
    }
}
