/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import static software.amazon.awssdk.util.StringUtils.isNullOrEmpty;

import java.util.stream.Stream;
import javax.annotation.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum StandardUnit {
    Seconds("Seconds"),

    Microseconds("Microseconds"),

    Milliseconds("Milliseconds"),

    Bytes("Bytes"),

    Kilobytes("Kilobytes"),

    Megabytes("Megabytes"),

    Gigabytes("Gigabytes"),

    Terabytes("Terabytes"),

    Bits("Bits"),

    Kilobits("Kilobits"),

    Megabits("Megabits"),

    Gigabits("Gigabits"),

    Terabits("Terabits"),

    Percent("Percent"),

    Count("Count"),

    BytesSecond("Bytes/Second"),

    KilobytesSecond("Kilobytes/Second"),

    MegabytesSecond("Megabytes/Second"),

    GigabytesSecond("Gigabytes/Second"),

    TerabytesSecond("Terabytes/Second"),

    BitsSecond("Bits/Second"),

    KilobitsSecond("Kilobits/Second"),

    MegabitsSecond("Megabits/Second"),

    GigabitsSecond("Gigabits/Second"),

    TerabitsSecond("Terabits/Second"),

    CountSecond("Count/Second"),

    None("None");

    private final String value;

    private StandardUnit(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *        real value
     * @return StandardUnit corresponding to the value
     */
    public static StandardUnit fromValue(String value) {
        if (isNullOrEmpty(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(StandardUnit.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}
