/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a set of statistics that describes a specific metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StatisticSet implements ToCopyableBuilder<StatisticSet.Builder, StatisticSet> {
    private final Double sampleCount;

    private final Double sum;

    private final Double minimum;

    private final Double maximum;

    private StatisticSet(BuilderImpl builder) {
        this.sampleCount = builder.sampleCount;
        this.sum = builder.sum;
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
    }

    /**
     * <p>
     * The number of samples used for the statistic set.
     * </p>
     * 
     * @return The number of samples used for the statistic set.
     */
    public Double sampleCount() {
        return sampleCount;
    }

    /**
     * <p>
     * The sum of values for the sample set.
     * </p>
     * 
     * @return The sum of values for the sample set.
     */
    public Double sum() {
        return sum;
    }

    /**
     * <p>
     * The minimum value of the sample set.
     * </p>
     * 
     * @return The minimum value of the sample set.
     */
    public Double minimum() {
        return minimum;
    }

    /**
     * <p>
     * The maximum value of the sample set.
     * </p>
     * 
     * @return The maximum value of the sample set.
     */
    public Double maximum() {
        return maximum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((sampleCount() == null) ? 0 : sampleCount().hashCode());
        hashCode = 31 * hashCode + ((sum() == null) ? 0 : sum().hashCode());
        hashCode = 31 * hashCode + ((minimum() == null) ? 0 : minimum().hashCode());
        hashCode = 31 * hashCode + ((maximum() == null) ? 0 : maximum().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatisticSet)) {
            return false;
        }
        StatisticSet other = (StatisticSet) obj;
        if (other.sampleCount() == null ^ this.sampleCount() == null) {
            return false;
        }
        if (other.sampleCount() != null && !other.sampleCount().equals(this.sampleCount())) {
            return false;
        }
        if (other.sum() == null ^ this.sum() == null) {
            return false;
        }
        if (other.sum() != null && !other.sum().equals(this.sum())) {
            return false;
        }
        if (other.minimum() == null ^ this.minimum() == null) {
            return false;
        }
        if (other.minimum() != null && !other.minimum().equals(this.minimum())) {
            return false;
        }
        if (other.maximum() == null ^ this.maximum() == null) {
            return false;
        }
        if (other.maximum() != null && !other.maximum().equals(this.maximum())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (sampleCount() != null) {
            sb.append("SampleCount: ").append(sampleCount()).append(",");
        }
        if (sum() != null) {
            sb.append("Sum: ").append(sum()).append(",");
        }
        if (minimum() != null) {
            sb.append("Minimum: ").append(minimum()).append(",");
        }
        if (maximum() != null) {
            sb.append("Maximum: ").append(maximum()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, StatisticSet> {
        /**
         * <p>
         * The number of samples used for the statistic set.
         * </p>
         * 
         * @param sampleCount
         *        The number of samples used for the statistic set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleCount(Double sampleCount);

        /**
         * <p>
         * The sum of values for the sample set.
         * </p>
         * 
         * @param sum
         *        The sum of values for the sample set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sum(Double sum);

        /**
         * <p>
         * The minimum value of the sample set.
         * </p>
         * 
         * @param minimum
         *        The minimum value of the sample set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimum(Double minimum);

        /**
         * <p>
         * The maximum value of the sample set.
         * </p>
         * 
         * @param maximum
         *        The maximum value of the sample set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximum(Double maximum);
    }

    private static final class BuilderImpl implements Builder {
        private Double sampleCount;

        private Double sum;

        private Double minimum;

        private Double maximum;

        private BuilderImpl() {
        }

        private BuilderImpl(StatisticSet model) {
            setSampleCount(model.sampleCount);
            setSum(model.sum);
            setMinimum(model.minimum);
            setMaximum(model.maximum);
        }

        public final Double getSampleCount() {
            return sampleCount;
        }

        @Override
        public final Builder sampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
            return this;
        }

        public final void setSampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
        }

        public final Double getSum() {
            return sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        public final Double getMinimum() {
            return minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        public final Double getMaximum() {
            return maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        @Override
        public StatisticSet build() {
            return new StatisticSet(this);
        }
    }
}
