/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * GetMetricStatisticsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetMetricStatisticsRequestMarshaller implements
        Marshaller<Request<GetMetricStatisticsRequest>, GetMetricStatisticsRequest> {

    public Request<GetMetricStatisticsRequest> marshall(GetMetricStatisticsRequest getMetricStatisticsRequest) {

        if (getMetricStatisticsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<GetMetricStatisticsRequest> request = new DefaultRequest<GetMetricStatisticsRequest>(getMetricStatisticsRequest,
                "CloudWatchClient");
        request.addParameter("Action", "GetMetricStatistics");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (getMetricStatisticsRequest.namespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString(getMetricStatisticsRequest.namespace()));
        }

        if (getMetricStatisticsRequest.metricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString(getMetricStatisticsRequest.metricName()));
        }

        software.amazon.awssdk.runtime.SdkInternalList<Dimension> dimensionsList = (software.amazon.awssdk.runtime.SdkInternalList<Dimension>) getMetricStatisticsRequest
                .dimensions();
        if (!dimensionsList.isEmpty() || !dimensionsList.isAutoConstruct()) {
            int dimensionsListIndex = 1;

            for (Dimension dimensionsListValue : dimensionsList) {

                if (dimensionsListValue.name() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name",
                            StringUtils.fromString(dimensionsListValue.name()));
                }

                if (dimensionsListValue.value() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value",
                            StringUtils.fromString(dimensionsListValue.value()));
                }
                dimensionsListIndex++;
            }
        }

        if (getMetricStatisticsRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate(getMetricStatisticsRequest.startTime()));
        }

        if (getMetricStatisticsRequest.endTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate(getMetricStatisticsRequest.endTime()));
        }

        if (getMetricStatisticsRequest.period() != null) {
            request.addParameter("Period", StringUtils.fromInteger(getMetricStatisticsRequest.period()));
        }

        software.amazon.awssdk.runtime.SdkInternalList<String> statisticsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) getMetricStatisticsRequest
                .statistics();
        if (!statisticsList.isEmpty() || !statisticsList.isAutoConstruct()) {
            int statisticsListIndex = 1;

            for (String statisticsListValue : statisticsList) {
                if (statisticsListValue != null) {
                    request.addParameter("Statistics.member." + statisticsListIndex, StringUtils.fromString(statisticsListValue));
                }
                statisticsListIndex++;
            }
        }

        software.amazon.awssdk.runtime.SdkInternalList<String> extendedStatisticsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) getMetricStatisticsRequest
                .extendedStatistics();
        if (!extendedStatisticsList.isEmpty() || !extendedStatisticsList.isAutoConstruct()) {
            int extendedStatisticsListIndex = 1;

            for (String extendedStatisticsListValue : extendedStatisticsList) {
                if (extendedStatisticsListValue != null) {
                    request.addParameter("ExtendedStatistics.member." + extendedStatisticsListIndex,
                            StringUtils.fromString(extendedStatisticsListValue));
                }
                extendedStatisticsListIndex++;
            }
        }

        if (getMetricStatisticsRequest.unit() != null) {
            request.addParameter("Unit", StringUtils.fromString(getMetricStatisticsRequest.unit()));
        }

        return request;
    }

}
