/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudwatch.model.AlarmNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteAlarmsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteAlarmsRequest> {
    private final List<String> alarmNames;

    private DeleteAlarmsRequest(BuilderImpl builder) {
        this.alarmNames = builder.alarmNames;
    }

    public List<String> alarmNames() {
        return this.alarmNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.alarmNames() == null ? 0 : this.alarmNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAlarmsRequest)) {
            return false;
        }
        DeleteAlarmsRequest other = (DeleteAlarmsRequest)((Object)obj);
        if (other.alarmNames() == null ^ this.alarmNames() == null) {
            return false;
        }
        return other.alarmNames() == null || other.alarmNames().equals(this.alarmNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.alarmNames() != null) {
            sb.append("AlarmNames: ").append(this.alarmNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> alarmNames = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAlarmsRequest model) {
            this.setAlarmNames(model.alarmNames);
        }

        public final Collection<String> getAlarmNames() {
            return this.alarmNames;
        }

        @Override
        public final Builder alarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmNames(String ... alarmNames) {
            if (this.alarmNames == null) {
                this.alarmNames = new SdkInternalList(alarmNames.length);
            }
            for (String e : alarmNames) {
                this.alarmNames.add(e);
            }
            return this;
        }

        public final void setAlarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
        }

        @SafeVarargs
        public final void setAlarmNames(String ... alarmNames) {
            if (this.alarmNames == null) {
                this.alarmNames = new SdkInternalList(alarmNames.length);
            }
            for (String e : alarmNames) {
                this.alarmNames.add(e);
            }
        }

        public DeleteAlarmsRequest build() {
            return new DeleteAlarmsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteAlarmsRequest> {
        public Builder alarmNames(Collection<String> var1);

        public Builder alarmNames(String ... var1);
    }
}

