/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.DimensionsCopier;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.services.cloudwatch.model.Statistic;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAlarmsForMetricRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeAlarmsForMetricRequest> {
    private final String metricName;
    private final String namespace;
    private final String statistic;
    private final String extendedStatistic;
    private final List<Dimension> dimensions;
    private final Integer period;
    private final String unit;

    private DescribeAlarmsForMetricRequest(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
        this.statistic = builder.statistic;
        this.extendedStatistic = builder.extendedStatistic;
        this.dimensions = builder.dimensions;
        this.period = builder.period;
        this.unit = builder.unit;
    }

    public String metricName() {
        return this.metricName;
    }

    public String namespace() {
        return this.namespace;
    }

    public String statistic() {
        return this.statistic;
    }

    public String extendedStatistic() {
        return this.extendedStatistic;
    }

    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    public Integer period() {
        return this.period;
    }

    public String unit() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.metricName() == null ? 0 : this.metricName().hashCode());
        hashCode = 31 * hashCode + (this.namespace() == null ? 0 : this.namespace().hashCode());
        hashCode = 31 * hashCode + (this.statistic() == null ? 0 : this.statistic().hashCode());
        hashCode = 31 * hashCode + (this.extendedStatistic() == null ? 0 : this.extendedStatistic().hashCode());
        hashCode = 31 * hashCode + (this.dimensions() == null ? 0 : this.dimensions().hashCode());
        hashCode = 31 * hashCode + (this.period() == null ? 0 : this.period().hashCode());
        hashCode = 31 * hashCode + (this.unit() == null ? 0 : this.unit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmsForMetricRequest)) {
            return false;
        }
        DescribeAlarmsForMetricRequest other = (DescribeAlarmsForMetricRequest)((Object)obj);
        if (other.metricName() == null ^ this.metricName() == null) {
            return false;
        }
        if (other.metricName() != null && !other.metricName().equals(this.metricName())) {
            return false;
        }
        if (other.namespace() == null ^ this.namespace() == null) {
            return false;
        }
        if (other.namespace() != null && !other.namespace().equals(this.namespace())) {
            return false;
        }
        if (other.statistic() == null ^ this.statistic() == null) {
            return false;
        }
        if (other.statistic() != null && !other.statistic().equals(this.statistic())) {
            return false;
        }
        if (other.extendedStatistic() == null ^ this.extendedStatistic() == null) {
            return false;
        }
        if (other.extendedStatistic() != null && !other.extendedStatistic().equals(this.extendedStatistic())) {
            return false;
        }
        if (other.dimensions() == null ^ this.dimensions() == null) {
            return false;
        }
        if (other.dimensions() != null && !other.dimensions().equals(this.dimensions())) {
            return false;
        }
        if (other.period() == null ^ this.period() == null) {
            return false;
        }
        if (other.period() != null && !other.period().equals(this.period())) {
            return false;
        }
        if (other.unit() == null ^ this.unit() == null) {
            return false;
        }
        return other.unit() == null || other.unit().equals(this.unit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metricName() != null) {
            sb.append("MetricName: ").append(this.metricName()).append(",");
        }
        if (this.namespace() != null) {
            sb.append("Namespace: ").append(this.namespace()).append(",");
        }
        if (this.statistic() != null) {
            sb.append("Statistic: ").append(this.statistic()).append(",");
        }
        if (this.extendedStatistic() != null) {
            sb.append("ExtendedStatistic: ").append(this.extendedStatistic()).append(",");
        }
        if (this.dimensions() != null) {
            sb.append("Dimensions: ").append(this.dimensions()).append(",");
        }
        if (this.period() != null) {
            sb.append("Period: ").append(this.period()).append(",");
        }
        if (this.unit() != null) {
            sb.append("Unit: ").append(this.unit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String metricName;
        private String namespace;
        private String statistic;
        private String extendedStatistic;
        private List<Dimension> dimensions = new SdkInternalList();
        private Integer period;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmsForMetricRequest model) {
            this.setMetricName(model.metricName);
            this.setNamespace(model.namespace);
            this.setStatistic(model.statistic);
            this.setExtendedStatistic(model.extendedStatistic);
            this.setDimensions(model.dimensions);
            this.setPeriod(model.period);
            this.setUnit(model.unit);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getStatistic() {
            return this.statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(Statistic statistic) {
            this.statistic(statistic.toString());
            return this;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        public final void setStatistic(Statistic statistic) {
            this.statistic(statistic.toString());
        }

        public final String getExtendedStatistic() {
            return this.extendedStatistic;
        }

        @Override
        public final Builder extendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
            return this;
        }

        public final void setExtendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
        }

        public final Collection<Dimension> getDimensions() {
            return this.dimensions;
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension ... dimensions) {
            if (this.dimensions == null) {
                this.dimensions = new SdkInternalList(dimensions.length);
            }
            for (Dimension e : dimensions) {
                this.dimensions.add(e);
            }
            return this;
        }

        public final void setDimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
        }

        @SafeVarargs
        public final void setDimensions(Dimension ... dimensions) {
            if (this.dimensions == null) {
                this.dimensions = new SdkInternalList(dimensions.length);
            }
            for (Dimension e : dimensions) {
                this.dimensions.add(e);
            }
        }

        public final Integer getPeriod() {
            return this.period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final void setUnit(StandardUnit unit) {
            this.unit(unit.toString());
        }

        public DescribeAlarmsForMetricRequest build() {
            return new DescribeAlarmsForMetricRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAlarmsForMetricRequest> {
        public Builder metricName(String var1);

        public Builder namespace(String var1);

        public Builder statistic(String var1);

        public Builder statistic(Statistic var1);

        public Builder extendedStatistic(String var1);

        public Builder dimensions(Collection<Dimension> var1);

        public Builder dimensions(Dimension ... var1);

        public Builder period(Integer var1);

        public Builder unit(String var1);

        public Builder unit(StandardUnit var1);
    }
}

