/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudwatch.model.MetricAlarm;
import software.amazon.awssdk.services.cloudwatch.model.MetricAlarmsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAlarmsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeAlarmsResponse> {
    private final List<MetricAlarm> metricAlarms;
    private final String nextToken;

    private DescribeAlarmsResponse(BuilderImpl builder) {
        this.metricAlarms = builder.metricAlarms;
        this.nextToken = builder.nextToken;
    }

    public List<MetricAlarm> metricAlarms() {
        return this.metricAlarms;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.metricAlarms() == null ? 0 : this.metricAlarms().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmsResponse)) {
            return false;
        }
        DescribeAlarmsResponse other = (DescribeAlarmsResponse)((Object)obj);
        if (other.metricAlarms() == null ^ this.metricAlarms() == null) {
            return false;
        }
        if (other.metricAlarms() != null && !other.metricAlarms().equals(this.metricAlarms())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metricAlarms() != null) {
            sb.append("MetricAlarms: ").append(this.metricAlarms()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<MetricAlarm> metricAlarms = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmsResponse model) {
            this.setMetricAlarms(model.metricAlarms);
            this.setNextToken(model.nextToken);
        }

        public final Collection<MetricAlarm> getMetricAlarms() {
            return this.metricAlarms;
        }

        @Override
        public final Builder metricAlarms(Collection<MetricAlarm> metricAlarms) {
            this.metricAlarms = MetricAlarmsCopier.copy(metricAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricAlarms(MetricAlarm ... metricAlarms) {
            if (this.metricAlarms == null) {
                this.metricAlarms = new SdkInternalList(metricAlarms.length);
            }
            for (MetricAlarm e : metricAlarms) {
                this.metricAlarms.add(e);
            }
            return this;
        }

        public final void setMetricAlarms(Collection<MetricAlarm> metricAlarms) {
            this.metricAlarms = MetricAlarmsCopier.copy(metricAlarms);
        }

        @SafeVarargs
        public final void setMetricAlarms(MetricAlarm ... metricAlarms) {
            if (this.metricAlarms == null) {
                this.metricAlarms = new SdkInternalList(metricAlarms.length);
            }
            for (MetricAlarm e : metricAlarms) {
                this.metricAlarms.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeAlarmsResponse build() {
            return new DescribeAlarmsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAlarmsResponse> {
        public Builder metricAlarms(Collection<MetricAlarm> var1);

        public Builder metricAlarms(MetricAlarm ... var1);

        public Builder nextToken(String var1);
    }
}

