/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudwatch.model.DimensionFilter;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListMetricsRequestMarshaller
implements Marshaller<Request<ListMetricsRequest>, ListMetricsRequest> {
    public Request<ListMetricsRequest> marshall(ListMetricsRequest listMetricsRequest) {
        SdkInternalList dimensionsList;
        if (listMetricsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listMetricsRequest, "CloudWatchClient");
        request.addParameter("Action", "ListMetrics");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (listMetricsRequest.namespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString((String)listMetricsRequest.namespace()));
        }
        if (listMetricsRequest.metricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString((String)listMetricsRequest.metricName()));
        }
        if (!(dimensionsList = (SdkInternalList)listMetricsRequest.dimensions()).isEmpty() || !dimensionsList.isAutoConstruct()) {
            int dimensionsListIndex = 1;
            for (DimensionFilter dimensionsListValue : dimensionsList) {
                if (dimensionsListValue.name() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.name()));
                }
                if (dimensionsListValue.value() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.value()));
                }
                ++dimensionsListIndex;
            }
        }
        if (listMetricsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listMetricsRequest.nextToken()));
        }
        return request;
    }
}

