/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest;
import software.amazon.awssdk.util.StringUtils;

public class PutMetricAlarmRequestMarshaller
implements Marshaller<Request<PutMetricAlarmRequest>, PutMetricAlarmRequest> {
    public Request<PutMetricAlarmRequest> marshall(PutMetricAlarmRequest putMetricAlarmRequest) {
        SdkInternalList dimensionsList;
        SdkInternalList insufficientDataActionsList;
        SdkInternalList alarmActionsList;
        SdkInternalList oKActionsList;
        if (putMetricAlarmRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putMetricAlarmRequest, "CloudWatchClient");
        request.addParameter("Action", "PutMetricAlarm");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putMetricAlarmRequest.alarmName() != null) {
            request.addParameter("AlarmName", StringUtils.fromString((String)putMetricAlarmRequest.alarmName()));
        }
        if (putMetricAlarmRequest.alarmDescription() != null) {
            request.addParameter("AlarmDescription", StringUtils.fromString((String)putMetricAlarmRequest.alarmDescription()));
        }
        if (putMetricAlarmRequest.actionsEnabled() != null) {
            request.addParameter("ActionsEnabled", StringUtils.fromBoolean((Boolean)putMetricAlarmRequest.actionsEnabled()));
        }
        if (!(oKActionsList = (SdkInternalList)putMetricAlarmRequest.okActions()).isEmpty() || !oKActionsList.isAutoConstruct()) {
            int oKActionsListIndex = 1;
            for (Object oKActionsListValue : oKActionsList) {
                if (oKActionsListValue != null) {
                    request.addParameter("OKActions.member." + oKActionsListIndex, StringUtils.fromString((String)oKActionsListValue));
                }
                ++oKActionsListIndex;
            }
        }
        if (!(alarmActionsList = (SdkInternalList)putMetricAlarmRequest.alarmActions()).isEmpty() || !alarmActionsList.isAutoConstruct()) {
            int alarmActionsListIndex = 1;
            for (Object alarmActionsListValue : alarmActionsList) {
                if (alarmActionsListValue != null) {
                    request.addParameter("AlarmActions.member." + alarmActionsListIndex, StringUtils.fromString((String)alarmActionsListValue));
                }
                ++alarmActionsListIndex;
            }
        }
        if (!(insufficientDataActionsList = (SdkInternalList)putMetricAlarmRequest.insufficientDataActions()).isEmpty() || !insufficientDataActionsList.isAutoConstruct()) {
            int insufficientDataActionsListIndex = 1;
            for (String insufficientDataActionsListValue : insufficientDataActionsList) {
                if (insufficientDataActionsListValue != null) {
                    request.addParameter("InsufficientDataActions.member." + insufficientDataActionsListIndex, StringUtils.fromString((String)insufficientDataActionsListValue));
                }
                ++insufficientDataActionsListIndex;
            }
        }
        if (putMetricAlarmRequest.metricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString((String)putMetricAlarmRequest.metricName()));
        }
        if (putMetricAlarmRequest.namespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString((String)putMetricAlarmRequest.namespace()));
        }
        if (putMetricAlarmRequest.statistic() != null) {
            request.addParameter("Statistic", StringUtils.fromString((String)putMetricAlarmRequest.statistic()));
        }
        if (putMetricAlarmRequest.extendedStatistic() != null) {
            request.addParameter("ExtendedStatistic", StringUtils.fromString((String)putMetricAlarmRequest.extendedStatistic()));
        }
        if (!(dimensionsList = (SdkInternalList)putMetricAlarmRequest.dimensions()).isEmpty() || !dimensionsList.isAutoConstruct()) {
            int dimensionsListIndex = 1;
            for (Dimension dimensionsListValue : dimensionsList) {
                if (dimensionsListValue.name() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.name()));
                }
                if (dimensionsListValue.value() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.value()));
                }
                ++dimensionsListIndex;
            }
        }
        if (putMetricAlarmRequest.period() != null) {
            request.addParameter("Period", StringUtils.fromInteger((Integer)putMetricAlarmRequest.period()));
        }
        if (putMetricAlarmRequest.unit() != null) {
            request.addParameter("Unit", StringUtils.fromString((String)putMetricAlarmRequest.unit()));
        }
        if (putMetricAlarmRequest.evaluationPeriods() != null) {
            request.addParameter("EvaluationPeriods", StringUtils.fromInteger((Integer)putMetricAlarmRequest.evaluationPeriods()));
        }
        if (putMetricAlarmRequest.threshold() != null) {
            request.addParameter("Threshold", StringUtils.fromDouble((Double)putMetricAlarmRequest.threshold()));
        }
        if (putMetricAlarmRequest.comparisonOperator() != null) {
            request.addParameter("ComparisonOperator", StringUtils.fromString((String)putMetricAlarmRequest.comparisonOperator()));
        }
        if (putMetricAlarmRequest.treatMissingData() != null) {
            request.addParameter("TreatMissingData", StringUtils.fromString((String)putMetricAlarmRequest.treatMissingData()));
        }
        if (putMetricAlarmRequest.evaluateLowSampleCountPercentile() != null) {
            request.addParameter("EvaluateLowSampleCountPercentile", StringUtils.fromString((String)putMetricAlarmRequest.evaluateLowSampleCountPercentile()));
        }
        return request;
    }
}

