/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAlarmsForMetricResponse extends CloudWatchResponse implements
        ToCopyableBuilder<DescribeAlarmsForMetricResponse.Builder, DescribeAlarmsForMetricResponse> {
    private final List<MetricAlarm> metricAlarms;

    private DescribeAlarmsForMetricResponse(BuilderImpl builder) {
        super(builder);
        this.metricAlarms = builder.metricAlarms;
    }

    /**
     * <p>
     * The information for each alarm with the specified metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The information for each alarm with the specified metric.
     */
    public List<MetricAlarm> metricAlarms() {
        return metricAlarms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricAlarms());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmsForMetricResponse)) {
            return false;
        }
        DescribeAlarmsForMetricResponse other = (DescribeAlarmsForMetricResponse) obj;
        return Objects.equals(metricAlarms(), other.metricAlarms());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAlarmsForMetricResponse").add("MetricAlarms", metricAlarms()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricAlarms":
            return Optional.of(clazz.cast(metricAlarms()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudWatchResponse.Builder, CopyableBuilder<Builder, DescribeAlarmsForMetricResponse> {
        /**
         * <p>
         * The information for each alarm with the specified metric.
         * </p>
         * 
         * @param metricAlarms
         *        The information for each alarm with the specified metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAlarms(Collection<MetricAlarm> metricAlarms);

        /**
         * <p>
         * The information for each alarm with the specified metric.
         * </p>
         * 
         * @param metricAlarms
         *        The information for each alarm with the specified metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAlarms(MetricAlarm... metricAlarms);

        /**
         * <p>
         * The information for each alarm with the specified metric.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricAlarm>.Builder} avoiding the need to
         * create one manually via {@link List<MetricAlarm>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricAlarm>.Builder#build()} is called immediately and its
         * result is passed to {@link #metricAlarms(List<MetricAlarm>)}.
         * 
         * @param metricAlarms
         *        a consumer that will call methods on {@link List<MetricAlarm>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricAlarms(List<MetricAlarm>)
         */
        Builder metricAlarms(Consumer<MetricAlarm.Builder>... metricAlarms);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private List<MetricAlarm> metricAlarms;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmsForMetricResponse model) {
            super(model);
            metricAlarms(model.metricAlarms);
        }

        public final Collection<MetricAlarm.Builder> getMetricAlarms() {
            return metricAlarms != null ? metricAlarms.stream().map(MetricAlarm::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricAlarms(Collection<MetricAlarm> metricAlarms) {
            this.metricAlarms = MetricAlarmsCopier.copy(metricAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricAlarms(MetricAlarm... metricAlarms) {
            metricAlarms(Arrays.asList(metricAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricAlarms(Consumer<MetricAlarm.Builder>... metricAlarms) {
            metricAlarms(Stream.of(metricAlarms).map(c -> MetricAlarm.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricAlarms(Collection<MetricAlarm.BuilderImpl> metricAlarms) {
            this.metricAlarms = MetricAlarmsCopier.copyFromBuilder(metricAlarms);
        }

        @Override
        public DescribeAlarmsForMetricResponse build() {
            return new DescribeAlarmsForMetricResponse(this);
        }
    }
}
