/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutMetricDataRequest extends CloudWatchRequest implements
        ToCopyableBuilder<PutMetricDataRequest.Builder, PutMetricDataRequest> {
    private final String namespace;

    private final List<MetricDatum> metricData;

    private PutMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.namespace = builder.namespace;
        this.metricData = builder.metricData;
    }

    /**
     * <p>
     * The namespace for the metric data.
     * </p>
     * <p>
     * You cannot specify a namespace that begins with "AWS/". Namespaces that begin with "AWS/" are reserved for use by
     * Amazon Web Services products.
     * </p>
     * 
     * @return The namespace for the metric data.</p>
     *         <p>
     *         You cannot specify a namespace that begins with "AWS/". Namespaces that begin with "AWS/" are reserved
     *         for use by Amazon Web Services products.
     */
    public String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The data for the metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The data for the metric.
     */
    public List<MetricDatum> metricData() {
        return metricData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(metricData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricDataRequest)) {
            return false;
        }
        PutMetricDataRequest other = (PutMetricDataRequest) obj;
        return Objects.equals(namespace(), other.namespace()) && Objects.equals(metricData(), other.metricData());
    }

    @Override
    public String toString() {
        return ToString.builder("PutMetricDataRequest").add("Namespace", namespace()).add("MetricData", metricData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Namespace":
            return Optional.of(clazz.cast(namespace()));
        case "MetricData":
            return Optional.of(clazz.cast(metricData()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudWatchRequest.Builder, CopyableBuilder<Builder, PutMetricDataRequest> {
        /**
         * <p>
         * The namespace for the metric data.
         * </p>
         * <p>
         * You cannot specify a namespace that begins with "AWS/". Namespaces that begin with "AWS/" are reserved for
         * use by Amazon Web Services products.
         * </p>
         * 
         * @param namespace
         *        The namespace for the metric data.</p>
         *        <p>
         *        You cannot specify a namespace that begins with "AWS/". Namespaces that begin with "AWS/" are reserved
         *        for use by Amazon Web Services products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The data for the metric.
         * </p>
         * 
         * @param metricData
         *        The data for the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricData(Collection<MetricDatum> metricData);

        /**
         * <p>
         * The data for the metric.
         * </p>
         * 
         * @param metricData
         *        The data for the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricData(MetricDatum... metricData);

        /**
         * <p>
         * The data for the metric.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricDatum>.Builder} avoiding the need to
         * create one manually via {@link List<MetricDatum>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricDatum>.Builder#build()} is called immediately and its
         * result is passed to {@link #metricData(List<MetricDatum>)}.
         * 
         * @param metricData
         *        a consumer that will call methods on {@link List<MetricDatum>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricData(List<MetricDatum>)
         */
        Builder metricData(Consumer<MetricDatum.Builder>... metricData);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private String namespace;

        private List<MetricDatum> metricData;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetricDataRequest model) {
            super(model);
            namespace(model.namespace);
            metricData(model.metricData);
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final Collection<MetricDatum.Builder> getMetricData() {
            return metricData != null ? metricData.stream().map(MetricDatum::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricData(Collection<MetricDatum> metricData) {
            this.metricData = MetricDataCopier.copy(metricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(MetricDatum... metricData) {
            metricData(Arrays.asList(metricData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(Consumer<MetricDatum.Builder>... metricData) {
            metricData(Stream.of(metricData).map(c -> MetricDatum.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricData(Collection<MetricDatum.BuilderImpl> metricData) {
            this.metricData = MetricDataCopier.copyFromBuilder(metricData);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutMetricDataRequest build() {
            return new PutMetricDataRequest(this);
        }
    }
}
