/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.services.cloudwatch.model.Datapoint;
import software.amazon.awssdk.services.cloudwatch.model.DatapointsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetMetricStatisticsResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, GetMetricStatisticsResponse> {
    private final String label;
    private final List<Datapoint> datapoints;

    private GetMetricStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.label = builder.label;
        this.datapoints = builder.datapoints;
    }

    public String label() {
        return this.label;
    }

    public List<Datapoint> datapoints() {
        return this.datapoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.datapoints());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricStatisticsResponse)) {
            return false;
        }
        GetMetricStatisticsResponse other = (GetMetricStatisticsResponse)((Object)obj);
        return Objects.equals(this.label(), other.label()) && Objects.equals(this.datapoints(), other.datapoints());
    }

    public String toString() {
        return ToString.builder((String)"GetMetricStatisticsResponse").add("Label", (Object)this.label()).add("Datapoints", this.datapoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Label": {
                return Optional.of(clazz.cast(this.label()));
            }
            case "Datapoints": {
                return Optional.of(clazz.cast(this.datapoints()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private String label;
        private List<Datapoint> datapoints;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricStatisticsResponse model) {
            super(model);
            this.label(model.label);
            this.datapoints(model.datapoints);
        }

        public final String getLabel() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Collection<Datapoint.Builder> getDatapoints() {
            return this.datapoints != null ? (Collection)this.datapoints.stream().map(Datapoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder datapoints(Collection<Datapoint> datapoints) {
            this.datapoints = DatapointsCopier.copy(datapoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datapoints(Datapoint ... datapoints) {
            this.datapoints(Arrays.asList(datapoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datapoints(Consumer<Datapoint.Builder> ... datapoints) {
            this.datapoints(Stream.of(datapoints).map(c -> (Datapoint)((Datapoint.Builder)Datapoint.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDatapoints(Collection<Datapoint.BuilderImpl> datapoints) {
            this.datapoints = DatapointsCopier.copyFromBuilder(datapoints);
        }

        @Override
        public GetMetricStatisticsResponse build() {
            return new GetMetricStatisticsResponse(this);
        }
    }

    public static interface Builder
    extends CloudWatchResponse.Builder,
    CopyableBuilder<Builder, GetMetricStatisticsResponse> {
        public Builder label(String var1);

        public Builder datapoints(Collection<Datapoint> var1);

        public Builder datapoints(Datapoint ... var1);

        public Builder datapoints(Consumer<Datapoint.Builder> ... var1);
    }
}

