/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure defines the metric to be returned, along with the statistics, period, and units.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricStat implements SdkPojo, Serializable, ToCopyableBuilder<MetricStat.Builder, MetricStat> {
    private static final SdkField<Metric> METRIC_FIELD = SdkField.<Metric> builder(MarshallingType.SDK_POJO)
            .getter(getter(MetricStat::metric)).setter(setter(Builder::metric)).constructor(Metric::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()).build();

    private static final SdkField<Integer> PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(MetricStat::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()).build();

    private static final SdkField<String> STAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MetricStat::stat)).setter(setter(Builder::stat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stat").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MetricStat::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_FIELD, PERIOD_FIELD,
            STAT_FIELD, UNIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Metric metric;

    private final Integer period;

    private final String stat;

    private final String unit;

    private MetricStat(BuilderImpl builder) {
        this.metric = builder.metric;
        this.period = builder.period;
        this.stat = builder.stat;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * The metric to return, including the metric name, namespace, and dimensions.
     * </p>
     * 
     * @return The metric to return, including the metric name, namespace, and dimensions.
     */
    public Metric metric() {
        return metric;
    }

    /**
     * <p>
     * The period to use when retrieving the metric.
     * </p>
     * 
     * @return The period to use when retrieving the metric.
     */
    public Integer period() {
        return period;
    }

    /**
     * <p>
     * The statistic to return. It can include any CloudWatch statistic or extended statistic.
     * </p>
     * 
     * @return The statistic to return. It can include any CloudWatch statistic or extended statistic.
     */
    public String stat() {
        return stat;
    }

    /**
     * <p>
     * The unit to use for the returned data points.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link StandardUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit to use for the returned data points.
     * @see StandardUnit
     */
    public StandardUnit unit() {
        return StandardUnit.fromValue(unit);
    }

    /**
     * <p>
     * The unit to use for the returned data points.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link StandardUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit to use for the returned data points.
     * @see StandardUnit
     */
    public String unitAsString() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metric());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(stat());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricStat)) {
            return false;
        }
        MetricStat other = (MetricStat) obj;
        return Objects.equals(metric(), other.metric()) && Objects.equals(period(), other.period())
                && Objects.equals(stat(), other.stat()) && Objects.equals(unitAsString(), other.unitAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("MetricStat").add("Metric", metric()).add("Period", period()).add("Stat", stat())
                .add("Unit", unitAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metric":
            return Optional.ofNullable(clazz.cast(metric()));
        case "Period":
            return Optional.ofNullable(clazz.cast(period()));
        case "Stat":
            return Optional.ofNullable(clazz.cast(stat()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricStat, T> g) {
        return obj -> g.apply((MetricStat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricStat> {
        /**
         * <p>
         * The metric to return, including the metric name, namespace, and dimensions.
         * </p>
         * 
         * @param metric
         *        The metric to return, including the metric name, namespace, and dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metric(Metric metric);

        /**
         * <p>
         * The metric to return, including the metric name, namespace, and dimensions.
         * </p>
         * This is a convenience that creates an instance of the {@link Metric.Builder} avoiding the need to create one
         * manually via {@link Metric#builder()}.
         *
         * When the {@link Consumer} completes, {@link Metric.Builder#build()} is called immediately and its result is
         * passed to {@link #metric(Metric)}.
         * 
         * @param metric
         *        a consumer that will call methods on {@link Metric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metric(Metric)
         */
        default Builder metric(Consumer<Metric.Builder> metric) {
            return metric(Metric.builder().applyMutation(metric).build());
        }

        /**
         * <p>
         * The period to use when retrieving the metric.
         * </p>
         * 
         * @param period
         *        The period to use when retrieving the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * <p>
         * The statistic to return. It can include any CloudWatch statistic or extended statistic.
         * </p>
         * 
         * @param stat
         *        The statistic to return. It can include any CloudWatch statistic or extended statistic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stat(String stat);

        /**
         * <p>
         * The unit to use for the returned data points.
         * </p>
         * 
         * @param unit
         *        The unit to use for the returned data points.
         * @see StandardUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit to use for the returned data points.
         * </p>
         * 
         * @param unit
         *        The unit to use for the returned data points.
         * @see StandardUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardUnit
         */
        Builder unit(StandardUnit unit);
    }

    static final class BuilderImpl implements Builder {
        private Metric metric;

        private Integer period;

        private String stat;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricStat model) {
            metric(model.metric);
            period(model.period);
            stat(model.stat);
            unit(model.unit);
        }

        public final Metric.Builder getMetric() {
            return metric != null ? metric.toBuilder() : null;
        }

        @Override
        public final Builder metric(Metric metric) {
            this.metric = metric;
            return this;
        }

        public final void setMetric(Metric.BuilderImpl metric) {
            this.metric = metric != null ? metric.build() : null;
        }

        public final Integer getPeriod() {
            return period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final String getStat() {
            return stat;
        }

        @Override
        public final Builder stat(String stat) {
            this.stat = stat;
            return this;
        }

        public final void setStat(String stat) {
            this.stat = stat;
        }

        public final String getUnit() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public MetricStat build() {
            return new MetricStat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
