/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Generated;
import org.w3c.dom.Node;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AsyncClientHandler;
import software.amazon.awssdk.client.AwsAsyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkAsyncClientHandler;
import software.amazon.awssdk.http.DefaultErrorResponseHandler;
import software.amazon.awssdk.http.StaxResponseHandler;
import software.amazon.awssdk.runtime.transform.StandardErrorUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchException;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsResponse;
import software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsRequest;
import software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest;
import software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateResponse;
import software.amazon.awssdk.services.cloudwatch.transform.DeleteAlarmsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DeleteAlarmsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmHistoryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmHistoryResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmsForMetricRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmsForMetricResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DisableAlarmActionsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DisableAlarmActionsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.EnableAlarmActionsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.EnableAlarmActionsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetMetricStatisticsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetMetricStatisticsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.InternalServiceExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.InvalidFormatExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.InvalidNextTokenExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.InvalidParameterCombinationExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.InvalidParameterValueExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.LimitExceededExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ListMetricsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ListMetricsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.MissingRequiredParameterExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutMetricAlarmRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutMetricAlarmResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutMetricDataRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutMetricDataResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ResourceNotFoundExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.SetAlarmStateRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.SetAlarmStateResponseUnmarshaller;

/**
 * Internal implementation of {@link CloudWatchAsyncClient}.
 *
 * @see CloudWatchAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCloudWatchAsyncClient implements CloudWatchAsyncClient {
    private final AsyncClientHandler clientHandler;

    private final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers;

    protected DefaultCloudWatchAsyncClient(AwsAsyncClientParams clientParams) {
        this.clientHandler = new SdkAsyncClientHandler(new ClientHandlerParams().withAsyncClientParams(clientParams)
                .withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.exceptionUnmarshallers = init();
    }

    /**
     * <p>
     * Deletes the specified alarms. In the event of an error, no alarms are deleted.
     * </p>
     * 
     * @param deleteAlarmsRequest
     * @return A Java Future containing the result of the DeleteAlarms operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The named resource does not exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CloudWatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CloudWatchAsyncClient.DeleteAlarms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteAlarms" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAlarmsResponse> deleteAlarms(DeleteAlarmsRequest deleteAlarmsRequest) {

        StaxResponseHandler<DeleteAlarmsResponse> responseHandler = new StaxResponseHandler<DeleteAlarmsResponse>(
                new DeleteAlarmsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteAlarmsRequest, DeleteAlarmsResponse>()
                .withMarshaller(new DeleteAlarmsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteAlarmsRequest));
    }

    /**
     * <p>
     * Retrieves the history for the specified alarm. You can filter the results by date range or item type. If an alarm
     * name is not specified, the histories for all alarms are returned.
     * </p>
     * <p>
     * Note that Amazon CloudWatch retains the history of an alarm even if you delete the alarm.
     * </p>
     * 
     * @param describeAlarmHistoryRequest
     * @return A Java Future containing the result of the DescribeAlarmHistory operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token specified is invalid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CloudWatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CloudWatchAsyncClient.DescribeAlarmHistory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAlarmHistoryResponse> describeAlarmHistory() {
        return describeAlarmHistory(DescribeAlarmHistoryRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the history for the specified alarm. You can filter the results by date range or item type. If an alarm
     * name is not specified, the histories for all alarms are returned.
     * </p>
     * <p>
     * Note that Amazon CloudWatch retains the history of an alarm even if you delete the alarm.
     * </p>
     * 
     * @param describeAlarmHistoryRequest
     * @return A Java Future containing the result of the DescribeAlarmHistory operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token specified is invalid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CloudWatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CloudWatchAsyncClient.DescribeAlarmHistory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAlarmHistoryResponse> describeAlarmHistory(
            DescribeAlarmHistoryRequest describeAlarmHistoryRequest) {

        StaxResponseHandler<DescribeAlarmHistoryResponse> responseHandler = new StaxResponseHandler<DescribeAlarmHistoryResponse>(
                new DescribeAlarmHistoryResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeAlarmHistoryRequest, DescribeAlarmHistoryResponse>()
                .withMarshaller(new DescribeAlarmHistoryRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeAlarmHistoryRequest));
    }

    /**
     * <p>
     * Retrieves the specified alarms. If no alarms are specified, all alarms are returned. Alarms can be retrieved by
     * using only a prefix for the alarm name, the alarm state, or a prefix for any action.
     * </p>
     * 
     * @param describeAlarmsRequest
     * @return A Java Future containing the result of the DescribeAlarms operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token specified is invalid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CloudWatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CloudWatchAsyncClient.DescribeAlarms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarms" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAlarmsResponse> describeAlarms() {
        return describeAlarms(DescribeAlarmsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the specified alarms. If no alarms are specified, all alarms are returned. Alarms can be retrieved by
     * using only a prefix for the alarm name, the alarm state, or a prefix for any action.
     * </p>
     * 
     * @param describeAlarmsRequest
     * @return A Java Future containing the result of the DescribeAlarms operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token specified is invalid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CloudWatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CloudWatchAsyncClient.DescribeAlarms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarms" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAlarmsResponse> describeAlarms(DescribeAlarmsRequest describeAlarmsRequest) {

        StaxResponseHandler<DescribeAlarmsResponse> responseHandler = new StaxResponseHandler<DescribeAlarmsResponse>(
                new DescribeAlarmsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeAlarmsRequest, DescribeAlarmsResponse>()
                .withMarshaller(new DescribeAlarmsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeAlarmsRequest));
    }

    /**
     * <p>
     * Retrieves the alarms for the specified metric. Specify a statistic, period, or unit to filter the results.
     * </p>
     * 
     * @param describeAlarmsForMetricRequest
     * @return A Java Future containing the result of the DescribeAlarmsForMetric operation returned by the service.
     * @sample CloudWatchAsyncClient.DescribeAlarmsForMetric
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmsForMetric"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAlarmsForMetricResponse> describeAlarmsForMetric(
            DescribeAlarmsForMetricRequest describeAlarmsForMetricRequest) {

        StaxResponseHandler<DescribeAlarmsForMetricResponse> responseHandler = new StaxResponseHandler<DescribeAlarmsForMetricResponse>(
                new DescribeAlarmsForMetricResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeAlarmsForMetricRequest, DescribeAlarmsForMetricResponse>()
                .withMarshaller(new DescribeAlarmsForMetricRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeAlarmsForMetricRequest));
    }

    /**
     * <p>
     * Disables the actions for the specified alarms. When an alarm's actions are disabled, the alarm actions do not
     * execute when the alarm state changes.
     * </p>
     * 
     * @param disableAlarmActionsRequest
     * @return A Java Future containing the result of the DisableAlarmActions operation returned by the service.
     * @sample CloudWatchAsyncClient.DisableAlarmActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DisableAlarmActions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableAlarmActionsResponse> disableAlarmActions(
            DisableAlarmActionsRequest disableAlarmActionsRequest) {

        StaxResponseHandler<DisableAlarmActionsResponse> responseHandler = new StaxResponseHandler<DisableAlarmActionsResponse>(
                new DisableAlarmActionsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DisableAlarmActionsRequest, DisableAlarmActionsResponse>()
                .withMarshaller(new DisableAlarmActionsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(disableAlarmActionsRequest));
    }

    /**
     * <p>
     * Enables the actions for the specified alarms.
     * </p>
     * 
     * @param enableAlarmActionsRequest
     * @return A Java Future containing the result of the EnableAlarmActions operation returned by the service.
     * @sample CloudWatchAsyncClient.EnableAlarmActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/EnableAlarmActions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<EnableAlarmActionsResponse> enableAlarmActions(EnableAlarmActionsRequest enableAlarmActionsRequest) {

        StaxResponseHandler<EnableAlarmActionsResponse> responseHandler = new StaxResponseHandler<EnableAlarmActionsResponse>(
                new EnableAlarmActionsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<EnableAlarmActionsRequest, EnableAlarmActionsResponse>()
                .withMarshaller(new EnableAlarmActionsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(enableAlarmActionsRequest));
    }

    /**
     * <p>
     * Gets statistics for the specified metric.
     * </p>
     * <p>
     * Amazon CloudWatch retains metric data as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Data points with a period of 60 seconds (1 minute) are available for 15 days
     * </p>
     * </li>
     * <li>
     * <p>
     * Data points with a period of 300 seconds (5 minute) are available for 63 days
     * </p>
     * </li>
     * <li>
     * <p>
     * Data points with a period of 3600 seconds (1 hour) are available for 455 days (15 months)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that CloudWatch started retaining 5-minute and 1-hour metric data as of 9 July 2016.
     * </p>
     * <p>
     * The maximum number of data points returned from a single call is 1,440. If you request more than 1,440 data
     * points, Amazon CloudWatch returns an error. To reduce the number of data points, you can narrow the specified
     * time range and make multiple requests across adjacent time ranges, or you can increase the specified period. A
     * period can be as short as one minute (60 seconds). Note that data points are not returned in chronological order.
     * </p>
     * <p>
     * Amazon CloudWatch aggregates data points based on the length of the period that you specify. For example, if you
     * request statistics with a one-hour period, Amazon CloudWatch aggregates all data points with time stamps that
     * fall within each one-hour period. Therefore, the number of values aggregated by CloudWatch is larger than the
     * number of data points returned.
     * </p>
     * <p>
     * CloudWatch needs raw data points to calculate percentile statistics. If you publish data using a statistic set
     * instead, you cannot retrieve percentile statistics for this data unless one of the following conditions is true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The SampleCount of the statistic set is 1
     * </p>
     * </li>
     * <li>
     * <p>
     * The Min and the Max of the statistic set are equal
     * </p>
     * </li>
     * </ul>
     * <p>
     * For a list of metrics and dimensions supported by AWS services, see the <a
     * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CW_Support_For_AWS.html">Amazon CloudWatch
     * Metrics and Dimensions Reference</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * 
     * @param getMetricStatisticsRequest
     * @return A Java Future containing the result of the GetMetricStatistics operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of an input parameter is bad or out-of-range.</li>
     *         <li>MissingRequiredParameterException An input parameter that is required is missing.</li>
     *         <li>InvalidParameterCombinationException Parameters that cannot be used together were used together.</li>
     *         <li>InternalServiceException Request processing has failed due to some unknown error, exception, or
     *         failure.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CloudWatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CloudWatchAsyncClient.GetMetricStatistics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetMetricStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMetricStatisticsResponse> getMetricStatistics(
            GetMetricStatisticsRequest getMetricStatisticsRequest) {

        StaxResponseHandler<GetMetricStatisticsResponse> responseHandler = new StaxResponseHandler<GetMetricStatisticsResponse>(
                new GetMetricStatisticsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<GetMetricStatisticsRequest, GetMetricStatisticsResponse>()
                .withMarshaller(new GetMetricStatisticsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getMetricStatisticsRequest));
    }

    /**
     * <p>
     * List the specified metrics. You can use the returned metrics with <a>GetMetricStatistics</a> to obtain
     * statistical data.
     * </p>
     * <p>
     * Up to 500 results are returned for any one call. To retrieve additional results, use the returned token with
     * subsequent calls.
     * </p>
     * <p>
     * After you create a metric, allow up to fifteen minutes before the metric appears. Statistics about the metric,
     * however, are available sooner using <a>GetMetricStatistics</a>.
     * </p>
     * 
     * @param listMetricsRequest
     * @return A Java Future containing the result of the ListMetrics operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Request processing has failed due to some unknown error, exception, or
     *         failure.</li>
     *         <li>InvalidParameterValueException The value of an input parameter is bad or out-of-range.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CloudWatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CloudWatchAsyncClient.ListMetrics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/ListMetrics" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListMetricsResponse> listMetrics() {
        return listMetrics(ListMetricsRequest.builder().build());
    }

    /**
     * <p>
     * List the specified metrics. You can use the returned metrics with <a>GetMetricStatistics</a> to obtain
     * statistical data.
     * </p>
     * <p>
     * Up to 500 results are returned for any one call. To retrieve additional results, use the returned token with
     * subsequent calls.
     * </p>
     * <p>
     * After you create a metric, allow up to fifteen minutes before the metric appears. Statistics about the metric,
     * however, are available sooner using <a>GetMetricStatistics</a>.
     * </p>
     * 
     * @param listMetricsRequest
     * @return A Java Future containing the result of the ListMetrics operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Request processing has failed due to some unknown error, exception, or
     *         failure.</li>
     *         <li>InvalidParameterValueException The value of an input parameter is bad or out-of-range.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CloudWatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CloudWatchAsyncClient.ListMetrics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/ListMetrics" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListMetricsResponse> listMetrics(ListMetricsRequest listMetricsRequest) {

        StaxResponseHandler<ListMetricsResponse> responseHandler = new StaxResponseHandler<ListMetricsResponse>(
                new ListMetricsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ListMetricsRequest, ListMetricsResponse>()
                .withMarshaller(new ListMetricsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listMetricsRequest));
    }

    /**
     * <p>
     * Creates or updates an alarm and associates it with the specified metric. Optionally, this operation can associate
     * one or more Amazon SNS resources with the alarm.
     * </p>
     * <p>
     * When this operation creates an alarm, the alarm state is immediately set to <code>INSUFFICIENT_DATA</code>. The
     * alarm is evaluated and its state is set appropriately. Any actions associated with the state are then executed.
     * </p>
     * <p>
     * When you update an existing alarm, its state is left unchanged, but the update completely overwrites the previous
     * configuration of the alarm.
     * </p>
     * <p>
     * If you are an AWS Identity and Access Management (IAM) user, you must have Amazon EC2 permissions for some
     * operations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ec2:DescribeInstanceStatus</code> and <code>ec2:DescribeInstances</code> for all alarms on EC2 instance
     * status metrics
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:StopInstances</code> for alarms with stop actions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:TerminateInstances</code> for alarms with terminate actions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:DescribeInstanceRecoveryAttribute</code> and <code>ec2:RecoverInstances</code> for alarms with recover
     * actions
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you have read/write permissions for Amazon CloudWatch but not for Amazon EC2, you can still create an alarm,
     * but the stop or terminate actions won't be performed. However, if you are later granted the required permissions,
     * the alarm actions that you created earlier will be performed.
     * </p>
     * <p>
     * If you are using an IAM role (for example, an Amazon EC2 instance profile), you cannot stop or terminate the
     * instance using alarm actions. However, you can still see the alarm state and perform any other actions such as
     * Amazon SNS notifications or Auto Scaling policies.
     * </p>
     * <p>
     * If you are using temporary security credentials granted using the AWS Security Token Service (AWS STS), you
     * cannot stop or terminate an Amazon EC2 instance using alarm actions.
     * </p>
     * <p>
     * Note that you must create at least one stop, terminate, or reboot alarm using the Amazon EC2 or CloudWatch
     * console to create the <b>EC2ActionsAccess</b> IAM role. After this IAM role is created, you can create stop,
     * terminate, or reboot alarms using a command-line interface or an API.
     * </p>
     * 
     * @param putMetricAlarmRequest
     * @return A Java Future containing the result of the PutMetricAlarm operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The quota for alarms for this customer has already been reached.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CloudWatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CloudWatchAsyncClient.PutMetricAlarm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutMetricAlarm" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutMetricAlarmResponse> putMetricAlarm(PutMetricAlarmRequest putMetricAlarmRequest) {

        StaxResponseHandler<PutMetricAlarmResponse> responseHandler = new StaxResponseHandler<PutMetricAlarmResponse>(
                new PutMetricAlarmResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<PutMetricAlarmRequest, PutMetricAlarmResponse>()
                .withMarshaller(new PutMetricAlarmRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(putMetricAlarmRequest));
    }

    /**
     * <p>
     * Publishes metric data points to Amazon CloudWatch. Amazon CloudWatch associates the data points with the
     * specified metric. If the specified metric does not exist, Amazon CloudWatch creates the metric. When Amazon
     * CloudWatch creates a metric, it can take up to fifteen minutes for the metric to appear in calls to
     * <a>ListMetrics</a>.
     * </p>
     * <p>
     * Each <code>PutMetricData</code> request is limited to 40 KB in size for HTTP POST requests.
     * </p>
     * <p>
     * Although the <code>Value</code> parameter accepts numbers of type <code>Double</code>, Amazon CloudWatch rejects
     * values that are either too small or too large. Values must be in the range of 8.515920e-109 to 1.174271e+108
     * (Base 10) or 2e-360 to 2e360 (Base 2). In addition, special values (e.g., NaN, +Infinity, -Infinity) are not
     * supported.
     * </p>
     * <p>
     * You can use up to 10 dimensions per metric to further clarify what data the metric collects. For more information
     * on specifying dimensions, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html">Publishing
     * Metrics</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * <p>
     * Data points with time stamps from 24 hours ago or longer can take at least 48 hours to become available for
     * <a>GetMetricStatistics</a> from the time they are submitted.
     * </p>
     * <p>
     * CloudWatch needs raw data points to calculate percentile statistics. If you publish data using a statistic set
     * instead, you cannot retrieve percentile statistics for this data unless one of the following conditions is true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The SampleCount of the statistic set is 1
     * </p>
     * </li>
     * <li>
     * <p>
     * The Min and the Max of the statistic set are equal
     * </p>
     * </li>
     * </ul>
     * 
     * @param putMetricDataRequest
     * @return A Java Future containing the result of the PutMetricData operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of an input parameter is bad or out-of-range.</li>
     *         <li>MissingRequiredParameterException An input parameter that is required is missing.</li>
     *         <li>InvalidParameterCombinationException Parameters that cannot be used together were used together.</li>
     *         <li>InternalServiceException Request processing has failed due to some unknown error, exception, or
     *         failure.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CloudWatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CloudWatchAsyncClient.PutMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutMetricData" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutMetricDataResponse> putMetricData(PutMetricDataRequest putMetricDataRequest) {

        StaxResponseHandler<PutMetricDataResponse> responseHandler = new StaxResponseHandler<PutMetricDataResponse>(
                new PutMetricDataResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<PutMetricDataRequest, PutMetricDataResponse>()
                .withMarshaller(new PutMetricDataRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(putMetricDataRequest));
    }

    /**
     * <p>
     * Temporarily sets the state of an alarm for testing purposes. When the updated state differs from the previous
     * value, the action configured for the appropriate state is invoked. For example, if your alarm is configured to
     * send an Amazon SNS message when an alarm is triggered, temporarily changing the alarm state to <code>ALARM</code>
     * sends an Amazon SNS message. The alarm returns to its actual state (often within seconds). Because the alarm
     * state change happens very quickly, it is typically only visible in the alarm's <b>History</b> tab in the Amazon
     * CloudWatch console or through <a>DescribeAlarmHistory</a>.
     * </p>
     * 
     * @param setAlarmStateRequest
     * @return A Java Future containing the result of the SetAlarmState operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The named resource does not exist.</li>
     *         <li>InvalidFormatException Data was not syntactically valid JSON.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CloudWatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CloudWatchAsyncClient.SetAlarmState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/SetAlarmState" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SetAlarmStateResponse> setAlarmState(SetAlarmStateRequest setAlarmStateRequest) {

        StaxResponseHandler<SetAlarmStateResponse> responseHandler = new StaxResponseHandler<SetAlarmStateResponse>(
                new SetAlarmStateResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<SetAlarmStateRequest, SetAlarmStateResponse>()
                .withMarshaller(new SetAlarmStateRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(setAlarmStateRequest));
    }

    @Override
    public void close() throws Exception {
        clientHandler.close();
    }

    private List<Unmarshaller<AmazonServiceException, Node>> init() {
        List<Unmarshaller<AmazonServiceException, Node>> unmarshallers = new ArrayList<>();
        unmarshallers.add(new InvalidParameterCombinationExceptionUnmarshaller());
        unmarshallers.add(new InvalidFormatExceptionUnmarshaller());
        unmarshallers.add(new MissingRequiredParameterExceptionUnmarshaller());
        unmarshallers.add(new InvalidParameterValueExceptionUnmarshaller());
        unmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        unmarshallers.add(new InternalServiceExceptionUnmarshaller());
        unmarshallers.add(new InvalidNextTokenExceptionUnmarshaller());
        unmarshallers.add(new LimitExceededExceptionUnmarshaller());
        unmarshallers.add(new StandardErrorUnmarshaller(CloudWatchException.class));
        return unmarshallers;
    }
}
