/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAlarmsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeAlarmsResponse.Builder, DescribeAlarmsResponse> {
    private final List<MetricAlarm> metricAlarms;

    private final String nextToken;

    private DescribeAlarmsResponse(BuilderImpl builder) {
        this.metricAlarms = builder.metricAlarms;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The information for the specified alarms.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The information for the specified alarms.
     */
    public List<MetricAlarm> metricAlarms() {
        return metricAlarms;
    }

    /**
     * <p>
     * The token that marks the start of the next batch of returned results.
     * </p>
     * 
     * @return The token that marks the start of the next batch of returned results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((metricAlarms() == null) ? 0 : metricAlarms().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmsResponse)) {
            return false;
        }
        DescribeAlarmsResponse other = (DescribeAlarmsResponse) obj;
        if (other.metricAlarms() == null ^ this.metricAlarms() == null) {
            return false;
        }
        if (other.metricAlarms() != null && !other.metricAlarms().equals(this.metricAlarms())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (metricAlarms() != null) {
            sb.append("MetricAlarms: ").append(metricAlarms()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeAlarmsResponse> {
        /**
         * <p>
         * The information for the specified alarms.
         * </p>
         * 
         * @param metricAlarms
         *        The information for the specified alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAlarms(Collection<MetricAlarm> metricAlarms);

        /**
         * <p>
         * The information for the specified alarms.
         * </p>
         * 
         * @param metricAlarms
         *        The information for the specified alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAlarms(MetricAlarm... metricAlarms);

        /**
         * <p>
         * The token that marks the start of the next batch of returned results.
         * </p>
         * 
         * @param nextToken
         *        The token that marks the start of the next batch of returned results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<MetricAlarm> metricAlarms;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmsResponse model) {
            setMetricAlarms(model.metricAlarms);
            setNextToken(model.nextToken);
        }

        public final Collection<MetricAlarm> getMetricAlarms() {
            return metricAlarms;
        }

        @Override
        public final Builder metricAlarms(Collection<MetricAlarm> metricAlarms) {
            this.metricAlarms = MetricAlarmsCopier.copy(metricAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricAlarms(MetricAlarm... metricAlarms) {
            metricAlarms(Arrays.asList(metricAlarms));
            return this;
        }

        public final void setMetricAlarms(Collection<MetricAlarm> metricAlarms) {
            this.metricAlarms = MetricAlarmsCopier.copy(metricAlarms);
        }

        @SafeVarargs
        public final void setMetricAlarms(MetricAlarm... metricAlarms) {
            metricAlarms(Arrays.asList(metricAlarms));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAlarmsResponse build() {
            return new DescribeAlarmsResponse(this);
        }
    }
}
