/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutMetricDataRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutMetricDataRequest.Builder, PutMetricDataRequest> {
    private final String namespace;

    private final List<MetricDatum> metricData;

    private PutMetricDataRequest(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.metricData = builder.metricData;
    }

    /**
     * <p>
     * The namespace for the metric data.
     * </p>
     * <p>
     * You cannot specify a namespace that begins with "AWS/". Namespaces that begin with "AWS/" are reserved for use by
     * Amazon Web Services products.
     * </p>
     * 
     * @return The namespace for the metric data.</p>
     *         <p>
     *         You cannot specify a namespace that begins with "AWS/". Namespaces that begin with "AWS/" are reserved
     *         for use by Amazon Web Services products.
     */
    public String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The data for the metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The data for the metric.
     */
    public List<MetricDatum> metricData() {
        return metricData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((namespace() == null) ? 0 : namespace().hashCode());
        hashCode = 31 * hashCode + ((metricData() == null) ? 0 : metricData().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricDataRequest)) {
            return false;
        }
        PutMetricDataRequest other = (PutMetricDataRequest) obj;
        if (other.namespace() == null ^ this.namespace() == null) {
            return false;
        }
        if (other.namespace() != null && !other.namespace().equals(this.namespace())) {
            return false;
        }
        if (other.metricData() == null ^ this.metricData() == null) {
            return false;
        }
        if (other.metricData() != null && !other.metricData().equals(this.metricData())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (namespace() != null) {
            sb.append("Namespace: ").append(namespace()).append(",");
        }
        if (metricData() != null) {
            sb.append("MetricData: ").append(metricData()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutMetricDataRequest> {
        /**
         * <p>
         * The namespace for the metric data.
         * </p>
         * <p>
         * You cannot specify a namespace that begins with "AWS/". Namespaces that begin with "AWS/" are reserved for
         * use by Amazon Web Services products.
         * </p>
         * 
         * @param namespace
         *        The namespace for the metric data.</p>
         *        <p>
         *        You cannot specify a namespace that begins with "AWS/". Namespaces that begin with "AWS/" are reserved
         *        for use by Amazon Web Services products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The data for the metric.
         * </p>
         * 
         * @param metricData
         *        The data for the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricData(Collection<MetricDatum> metricData);

        /**
         * <p>
         * The data for the metric.
         * </p>
         * 
         * @param metricData
         *        The data for the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricData(MetricDatum... metricData);
    }

    private static final class BuilderImpl implements Builder {
        private String namespace;

        private List<MetricDatum> metricData;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetricDataRequest model) {
            setNamespace(model.namespace);
            setMetricData(model.metricData);
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final Collection<MetricDatum> getMetricData() {
            return metricData;
        }

        @Override
        public final Builder metricData(Collection<MetricDatum> metricData) {
            this.metricData = MetricDataCopier.copy(metricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(MetricDatum... metricData) {
            metricData(Arrays.asList(metricData));
            return this;
        }

        public final void setMetricData(Collection<MetricDatum> metricData) {
            this.metricData = MetricDataCopier.copy(metricData);
        }

        @SafeVarargs
        public final void setMetricData(MetricDatum... metricData) {
            metricData(Arrays.asList(metricData));
        }

        @Override
        public PutMetricDataRequest build() {
            return new PutMetricDataRequest(this);
        }
    }
}
