/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SetAlarmStateRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<SetAlarmStateRequest.Builder, SetAlarmStateRequest> {
    private final String alarmName;

    private final String stateValue;

    private final String stateReason;

    private final String stateReasonData;

    private SetAlarmStateRequest(BuilderImpl builder) {
        this.alarmName = builder.alarmName;
        this.stateValue = builder.stateValue;
        this.stateReason = builder.stateReason;
        this.stateReasonData = builder.stateReasonData;
    }

    /**
     * <p>
     * The name for the alarm. This name must be unique within the AWS account. The maximum length is 255 characters.
     * </p>
     * 
     * @return The name for the alarm. This name must be unique within the AWS account. The maximum length is 255
     *         characters.
     */
    public String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * The value of the state.
     * </p>
     * 
     * @return The value of the state.
     * @see StateValue
     */
    public String stateValue() {
        return stateValue;
    }

    /**
     * <p>
     * The reason that this alarm is set to this specific state, in text format.
     * </p>
     * 
     * @return The reason that this alarm is set to this specific state, in text format.
     */
    public String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * The reason that this alarm is set to this specific state, in JSON format.
     * </p>
     * 
     * @return The reason that this alarm is set to this specific state, in JSON format.
     */
    public String stateReasonData() {
        return stateReasonData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((alarmName() == null) ? 0 : alarmName().hashCode());
        hashCode = 31 * hashCode + ((stateValue() == null) ? 0 : stateValue().hashCode());
        hashCode = 31 * hashCode + ((stateReason() == null) ? 0 : stateReason().hashCode());
        hashCode = 31 * hashCode + ((stateReasonData() == null) ? 0 : stateReasonData().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetAlarmStateRequest)) {
            return false;
        }
        SetAlarmStateRequest other = (SetAlarmStateRequest) obj;
        if (other.alarmName() == null ^ this.alarmName() == null) {
            return false;
        }
        if (other.alarmName() != null && !other.alarmName().equals(this.alarmName())) {
            return false;
        }
        if (other.stateValue() == null ^ this.stateValue() == null) {
            return false;
        }
        if (other.stateValue() != null && !other.stateValue().equals(this.stateValue())) {
            return false;
        }
        if (other.stateReason() == null ^ this.stateReason() == null) {
            return false;
        }
        if (other.stateReason() != null && !other.stateReason().equals(this.stateReason())) {
            return false;
        }
        if (other.stateReasonData() == null ^ this.stateReasonData() == null) {
            return false;
        }
        if (other.stateReasonData() != null && !other.stateReasonData().equals(this.stateReasonData())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (alarmName() != null) {
            sb.append("AlarmName: ").append(alarmName()).append(",");
        }
        if (stateValue() != null) {
            sb.append("StateValue: ").append(stateValue()).append(",");
        }
        if (stateReason() != null) {
            sb.append("StateReason: ").append(stateReason()).append(",");
        }
        if (stateReasonData() != null) {
            sb.append("StateReasonData: ").append(stateReasonData()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SetAlarmStateRequest> {
        /**
         * <p>
         * The name for the alarm. This name must be unique within the AWS account. The maximum length is 255
         * characters.
         * </p>
         * 
         * @param alarmName
         *        The name for the alarm. This name must be unique within the AWS account. The maximum length is 255
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * The value of the state.
         * </p>
         * 
         * @param stateValue
         *        The value of the state.
         * @see StateValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateValue
         */
        Builder stateValue(String stateValue);

        /**
         * <p>
         * The value of the state.
         * </p>
         * 
         * @param stateValue
         *        The value of the state.
         * @see StateValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateValue
         */
        Builder stateValue(StateValue stateValue);

        /**
         * <p>
         * The reason that this alarm is set to this specific state, in text format.
         * </p>
         * 
         * @param stateReason
         *        The reason that this alarm is set to this specific state, in text format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * The reason that this alarm is set to this specific state, in JSON format.
         * </p>
         * 
         * @param stateReasonData
         *        The reason that this alarm is set to this specific state, in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReasonData(String stateReasonData);
    }

    private static final class BuilderImpl implements Builder {
        private String alarmName;

        private String stateValue;

        private String stateReason;

        private String stateReasonData;

        private BuilderImpl() {
        }

        private BuilderImpl(SetAlarmStateRequest model) {
            setAlarmName(model.alarmName);
            setStateValue(model.stateValue);
            setStateReason(model.stateReason);
            setStateReasonData(model.stateReasonData);
        }

        public final String getAlarmName() {
            return alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getStateValue() {
            return stateValue;
        }

        @Override
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        @Override
        public final Builder stateValue(StateValue stateValue) {
            this.stateValue(stateValue.toString());
            return this;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        public final void setStateValue(StateValue stateValue) {
            this.stateValue(stateValue.toString());
        }

        public final String getStateReason() {
            return stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        public final String getStateReasonData() {
            return stateReasonData;
        }

        @Override
        public final Builder stateReasonData(String stateReasonData) {
            this.stateReasonData = stateReasonData;
            return this;
        }

        public final void setStateReasonData(String stateReasonData) {
            this.stateReasonData = stateReasonData;
        }

        @Override
        public SetAlarmStateRequest build() {
            return new SetAlarmStateRequest(this);
        }
    }
}
