/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * DescribeAlarmHistoryRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeAlarmHistoryRequestMarshaller implements
        Marshaller<Request<DescribeAlarmHistoryRequest>, DescribeAlarmHistoryRequest> {

    public Request<DescribeAlarmHistoryRequest> marshall(DescribeAlarmHistoryRequest describeAlarmHistoryRequest) {

        if (describeAlarmHistoryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeAlarmHistoryRequest> request = new DefaultRequest<DescribeAlarmHistoryRequest>(
                describeAlarmHistoryRequest, "CloudWatchClient");
        request.addParameter("Action", "DescribeAlarmHistory");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (describeAlarmHistoryRequest.alarmName() != null) {
            request.addParameter("AlarmName", StringUtils.fromString(describeAlarmHistoryRequest.alarmName()));
        }

        if (describeAlarmHistoryRequest.historyItemType() != null) {
            request.addParameter("HistoryItemType", StringUtils.fromString(describeAlarmHistoryRequest.historyItemType()));
        }

        if (describeAlarmHistoryRequest.startDate() != null) {
            request.addParameter("StartDate", StringUtils.fromInstant(describeAlarmHistoryRequest.startDate()));
        }

        if (describeAlarmHistoryRequest.endDate() != null) {
            request.addParameter("EndDate", StringUtils.fromInstant(describeAlarmHistoryRequest.endDate()));
        }

        if (describeAlarmHistoryRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeAlarmHistoryRequest.maxRecords()));
        }

        if (describeAlarmHistoryRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeAlarmHistoryRequest.nextToken()));
        }

        return request;
    }

}
