/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.waiters;

import javax.annotation.Generated;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;

@SdkInternalApi
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeAlarmsFunction implements SdkFunction<DescribeAlarmsRequest, DescribeAlarmsResponse> {

    /**
     * Represents the service client
     */
    private final CloudWatchClient client;

    /**
     * Constructs a new DescribeAlarmsFunction with the given client
     * 
     * @param client
     *        Service client
     */
    public DescribeAlarmsFunction(CloudWatchClient client) {
        this.client = client;
    }

    /**
     * Makes a call to the operation specified by the waiter by taking the corresponding request and returns the
     * corresponding result
     * 
     * @param describeAlarmsRequest
     *        Corresponding request for the operation
     * @return Corresponding result of the operation
     */
    @Override
    public DescribeAlarmsResponse apply(DescribeAlarmsRequest describeAlarmsRequest) {
        return client.describeAlarms(describeAlarmsRequest);
    }
}
