/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudwatch.model.HistoryItemType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAlarmHistoryRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeAlarmHistoryRequest> {
    private final String alarmName;
    private final String historyItemType;
    private final Instant startDate;
    private final Instant endDate;
    private final Integer maxRecords;
    private final String nextToken;

    private DescribeAlarmHistoryRequest(BuilderImpl builder) {
        this.alarmName = builder.alarmName;
        this.historyItemType = builder.historyItemType;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    public String alarmName() {
        return this.alarmName;
    }

    public String historyItemType() {
        return this.historyItemType;
    }

    public Instant startDate() {
        return this.startDate;
    }

    public Instant endDate() {
        return this.endDate;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.alarmName() == null ? 0 : this.alarmName().hashCode());
        hashCode = 31 * hashCode + (this.historyItemType() == null ? 0 : this.historyItemType().hashCode());
        hashCode = 31 * hashCode + (this.startDate() == null ? 0 : this.startDate().hashCode());
        hashCode = 31 * hashCode + (this.endDate() == null ? 0 : this.endDate().hashCode());
        hashCode = 31 * hashCode + (this.maxRecords() == null ? 0 : this.maxRecords().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmHistoryRequest)) {
            return false;
        }
        DescribeAlarmHistoryRequest other = (DescribeAlarmHistoryRequest)((Object)obj);
        if (other.alarmName() == null ^ this.alarmName() == null) {
            return false;
        }
        if (other.alarmName() != null && !other.alarmName().equals(this.alarmName())) {
            return false;
        }
        if (other.historyItemType() == null ^ this.historyItemType() == null) {
            return false;
        }
        if (other.historyItemType() != null && !other.historyItemType().equals(this.historyItemType())) {
            return false;
        }
        if (other.startDate() == null ^ this.startDate() == null) {
            return false;
        }
        if (other.startDate() != null && !other.startDate().equals(this.startDate())) {
            return false;
        }
        if (other.endDate() == null ^ this.endDate() == null) {
            return false;
        }
        if (other.endDate() != null && !other.endDate().equals(this.endDate())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.alarmName() != null) {
            sb.append("AlarmName: ").append(this.alarmName()).append(",");
        }
        if (this.historyItemType() != null) {
            sb.append("HistoryItemType: ").append(this.historyItemType()).append(",");
        }
        if (this.startDate() != null) {
            sb.append("StartDate: ").append(this.startDate()).append(",");
        }
        if (this.endDate() != null) {
            sb.append("EndDate: ").append(this.endDate()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String alarmName;
        private String historyItemType;
        private Instant startDate;
        private Instant endDate;
        private Integer maxRecords;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmHistoryRequest model) {
            this.setAlarmName(model.alarmName);
            this.setHistoryItemType(model.historyItemType);
            this.setStartDate(model.startDate);
            this.setEndDate(model.endDate);
            this.setMaxRecords(model.maxRecords);
            this.setNextToken(model.nextToken);
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getHistoryItemType() {
            return this.historyItemType;
        }

        @Override
        public final Builder historyItemType(String historyItemType) {
            this.historyItemType = historyItemType;
            return this;
        }

        @Override
        public final Builder historyItemType(HistoryItemType historyItemType) {
            this.historyItemType(historyItemType.toString());
            return this;
        }

        public final void setHistoryItemType(String historyItemType) {
            this.historyItemType = historyItemType;
        }

        public final void setHistoryItemType(HistoryItemType historyItemType) {
            this.historyItemType(historyItemType.toString());
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeAlarmHistoryRequest build() {
            return new DescribeAlarmHistoryRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAlarmHistoryRequest> {
        public Builder alarmName(String var1);

        public Builder historyItemType(String var1);

        public Builder historyItemType(HistoryItemType var1);

        public Builder startDate(Instant var1);

        public Builder endDate(Instant var1);

        public Builder maxRecords(Integer var1);

        public Builder nextToken(String var1);
    }
}

