/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class EnableAlarmActionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<EnableAlarmActionsRequest.Builder, EnableAlarmActionsRequest> {
    private final List<String> alarmNames;

    private EnableAlarmActionsRequest(BuilderImpl builder) {
        this.alarmNames = builder.alarmNames;
    }

    /**
     * <p>
     * The names of the alarms.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of the alarms.
     */
    public List<String> alarmNames() {
        return alarmNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((alarmNames() == null) ? 0 : alarmNames().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableAlarmActionsRequest)) {
            return false;
        }
        EnableAlarmActionsRequest other = (EnableAlarmActionsRequest) obj;
        if (other.alarmNames() == null ^ this.alarmNames() == null) {
            return false;
        }
        if (other.alarmNames() != null && !other.alarmNames().equals(this.alarmNames())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (alarmNames() != null) {
            sb.append("AlarmNames: ").append(alarmNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, EnableAlarmActionsRequest> {
        /**
         * <p>
         * The names of the alarms.
         * </p>
         * 
         * @param alarmNames
         *        The names of the alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmNames(Collection<String> alarmNames);

        /**
         * <p>
         * The names of the alarms.
         * </p>
         * 
         * @param alarmNames
         *        The names of the alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmNames(String... alarmNames);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> alarmNames;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableAlarmActionsRequest model) {
            setAlarmNames(model.alarmNames);
        }

        public final Collection<String> getAlarmNames() {
            return alarmNames;
        }

        @Override
        public final Builder alarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmNames(String... alarmNames) {
            alarmNames(Arrays.asList(alarmNames));
            return this;
        }

        public final void setAlarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
        }

        @Override
        public EnableAlarmActionsRequest build() {
            return new EnableAlarmActionsRequest(this);
        }
    }
}
