/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetMetricStatisticsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetMetricStatisticsRequest.Builder, GetMetricStatisticsRequest> {
    private final String namespace;

    private final String metricName;

    private final List<Dimension> dimensions;

    private final Instant startTime;

    private final Instant endTime;

    private final Integer period;

    private final List<String> statistics;

    private final List<String> extendedStatistics;

    private final String unit;

    private GetMetricStatisticsRequest(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.metricName = builder.metricName;
        this.dimensions = builder.dimensions;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.period = builder.period;
        this.statistics = builder.statistics;
        this.extendedStatistics = builder.extendedStatistics;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * The namespace of the metric, with or without spaces.
     * </p>
     * 
     * @return The namespace of the metric, with or without spaces.
     */
    public String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the metric, with or without spaces.
     * </p>
     * 
     * @return The name of the metric, with or without spaces.
     */
    public String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The dimensions. If the metric contains multiple dimensions, you must include a value for each dimension.
     * CloudWatch treats each unique combination of dimensions as a separate metric. You can't retrieve statistics using
     * combinations of dimensions that were not specially published. You must specify the same dimensions that were used
     * when the metrics were created. For an example, see <a href=
     * "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#dimension-combinations"
     * >Dimension Combinations</a> in the <i>Amazon CloudWatch User Guide</i>. For more information on specifying
     * dimensions, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html">Publishing
     * Metrics</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The dimensions. If the metric contains multiple dimensions, you must include a value for each dimension.
     *         CloudWatch treats each unique combination of dimensions as a separate metric. You can't retrieve
     *         statistics using combinations of dimensions that were not specially published. You must specify the same
     *         dimensions that were used when the metrics were created. For an example, see <a href=
     *         "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#dimension-combinations"
     *         >Dimension Combinations</a> in the <i>Amazon CloudWatch User Guide</i>. For more information on
     *         specifying dimensions, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html">Publishing
     *         Metrics</a> in the <i>Amazon CloudWatch User Guide</i>.
     */
    public List<Dimension> dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The time stamp that determines the first data point to return. Note that start times are evaluated relative to
     * the time that CloudWatch receives the request.
     * </p>
     * <p>
     * The value specified is inclusive; results include data points with the specified time stamp. The time stamp must
     * be in ISO 8601 UTC format (for example, 2016-10-03T23:00:00Z).
     * </p>
     * <p>
     * CloudWatch rounds the specified time stamp as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Start time less than 15 days ago - Round down to the nearest whole minute. For example, 12:32:34 is rounded down
     * to 12:32:00.
     * </p>
     * </li>
     * <li>
     * <p>
     * Start time between 15 and 63 days ago - Round down to the nearest 5-minute clock interval. For example, 12:32:34
     * is rounded down to 12:30:00.
     * </p>
     * </li>
     * <li>
     * <p>
     * Start time greater than 63 days ago - Round down to the nearest 1-hour clock interval. For example, 12:32:34 is
     * rounded down to 12:00:00.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The time stamp that determines the first data point to return. Note that start times are evaluated
     *         relative to the time that CloudWatch receives the request.</p>
     *         <p>
     *         The value specified is inclusive; results include data points with the specified time stamp. The time
     *         stamp must be in ISO 8601 UTC format (for example, 2016-10-03T23:00:00Z).
     *         </p>
     *         <p>
     *         CloudWatch rounds the specified time stamp as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Start time less than 15 days ago - Round down to the nearest whole minute. For example, 12:32:34 is
     *         rounded down to 12:32:00.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start time between 15 and 63 days ago - Round down to the nearest 5-minute clock interval. For example,
     *         12:32:34 is rounded down to 12:30:00.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start time greater than 63 days ago - Round down to the nearest 1-hour clock interval. For example,
     *         12:32:34 is rounded down to 12:00:00.
     *         </p>
     *         </li>
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time stamp that determines the last data point to return.
     * </p>
     * <p>
     * The value specified is exclusive; results will include data points up to the specified time stamp. The time stamp
     * must be in ISO 8601 UTC format (for example, 2016-10-10T23:00:00Z).
     * </p>
     * 
     * @return The time stamp that determines the last data point to return.</p>
     *         <p>
     *         The value specified is exclusive; results will include data points up to the specified time stamp. The
     *         time stamp must be in ISO 8601 UTC format (for example, 2016-10-10T23:00:00Z).
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The granularity, in seconds, of the returned data points. A period can be as short as one minute (60 seconds) and
     * must be a multiple of 60. The default value is 60.
     * </p>
     * <p>
     * If the <code>StartTime</code> parameter specifies a time stamp that is greater than 15 days ago, you must specify
     * the period as follows or no data points in that time range is returned:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).
     * </p>
     * </li>
     * <li>
     * <p>
     * Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).
     * </p>
     * </li>
     * </ul>
     * 
     * @return The granularity, in seconds, of the returned data points. A period can be as short as one minute (60
     *         seconds) and must be a multiple of 60. The default value is 60.</p>
     *         <p>
     *         If the <code>StartTime</code> parameter specifies a time stamp that is greater than 15 days ago, you must
     *         specify the period as follows or no data points in that time range is returned:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).
     *         </p>
     *         </li>
     */
    public Integer period() {
        return period;
    }

    /**
     * <p>
     * The metric statistics, other than percentile. For percentile statistics, use <code>ExtendedStatistic</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The metric statistics, other than percentile. For percentile statistics, use
     *         <code>ExtendedStatistic</code>.
     * @see Statistic
     */
    public List<String> statistics() {
        return statistics;
    }

    /**
     * <p>
     * The percentile statistics. Specify values between p0.0 and p100.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The percentile statistics. Specify values between p0.0 and p100.
     */
    public List<String> extendedStatistics() {
        return extendedStatistics;
    }

    /**
     * <p>
     * The unit for a given metric. Metrics may be reported in multiple units. Not supplying a unit results in all units
     * being returned. If the metric only ever reports one unit, specifying a unit has no effect.
     * </p>
     * 
     * @return The unit for a given metric. Metrics may be reported in multiple units. Not supplying a unit results in
     *         all units being returned. If the metric only ever reports one unit, specifying a unit has no effect.
     * @see StandardUnit
     */
    public String unit() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((namespace() == null) ? 0 : namespace().hashCode());
        hashCode = 31 * hashCode + ((metricName() == null) ? 0 : metricName().hashCode());
        hashCode = 31 * hashCode + ((dimensions() == null) ? 0 : dimensions().hashCode());
        hashCode = 31 * hashCode + ((startTime() == null) ? 0 : startTime().hashCode());
        hashCode = 31 * hashCode + ((endTime() == null) ? 0 : endTime().hashCode());
        hashCode = 31 * hashCode + ((period() == null) ? 0 : period().hashCode());
        hashCode = 31 * hashCode + ((statistics() == null) ? 0 : statistics().hashCode());
        hashCode = 31 * hashCode + ((extendedStatistics() == null) ? 0 : extendedStatistics().hashCode());
        hashCode = 31 * hashCode + ((unit() == null) ? 0 : unit().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricStatisticsRequest)) {
            return false;
        }
        GetMetricStatisticsRequest other = (GetMetricStatisticsRequest) obj;
        if (other.namespace() == null ^ this.namespace() == null) {
            return false;
        }
        if (other.namespace() != null && !other.namespace().equals(this.namespace())) {
            return false;
        }
        if (other.metricName() == null ^ this.metricName() == null) {
            return false;
        }
        if (other.metricName() != null && !other.metricName().equals(this.metricName())) {
            return false;
        }
        if (other.dimensions() == null ^ this.dimensions() == null) {
            return false;
        }
        if (other.dimensions() != null && !other.dimensions().equals(this.dimensions())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.period() == null ^ this.period() == null) {
            return false;
        }
        if (other.period() != null && !other.period().equals(this.period())) {
            return false;
        }
        if (other.statistics() == null ^ this.statistics() == null) {
            return false;
        }
        if (other.statistics() != null && !other.statistics().equals(this.statistics())) {
            return false;
        }
        if (other.extendedStatistics() == null ^ this.extendedStatistics() == null) {
            return false;
        }
        if (other.extendedStatistics() != null && !other.extendedStatistics().equals(this.extendedStatistics())) {
            return false;
        }
        if (other.unit() == null ^ this.unit() == null) {
            return false;
        }
        if (other.unit() != null && !other.unit().equals(this.unit())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (namespace() != null) {
            sb.append("Namespace: ").append(namespace()).append(",");
        }
        if (metricName() != null) {
            sb.append("MetricName: ").append(metricName()).append(",");
        }
        if (dimensions() != null) {
            sb.append("Dimensions: ").append(dimensions()).append(",");
        }
        if (startTime() != null) {
            sb.append("StartTime: ").append(startTime()).append(",");
        }
        if (endTime() != null) {
            sb.append("EndTime: ").append(endTime()).append(",");
        }
        if (period() != null) {
            sb.append("Period: ").append(period()).append(",");
        }
        if (statistics() != null) {
            sb.append("Statistics: ").append(statistics()).append(",");
        }
        if (extendedStatistics() != null) {
            sb.append("ExtendedStatistics: ").append(extendedStatistics()).append(",");
        }
        if (unit() != null) {
            sb.append("Unit: ").append(unit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetMetricStatisticsRequest> {
        /**
         * <p>
         * The namespace of the metric, with or without spaces.
         * </p>
         * 
         * @param namespace
         *        The namespace of the metric, with or without spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the metric, with or without spaces.
         * </p>
         * 
         * @param metricName
         *        The name of the metric, with or without spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The dimensions. If the metric contains multiple dimensions, you must include a value for each dimension.
         * CloudWatch treats each unique combination of dimensions as a separate metric. You can't retrieve statistics
         * using combinations of dimensions that were not specially published. You must specify the same dimensions that
         * were used when the metrics were created. For an example, see <a href=
         * "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#dimension-combinations"
         * >Dimension Combinations</a> in the <i>Amazon CloudWatch User Guide</i>. For more information on specifying
         * dimensions, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html">Publishing
         * Metrics</a> in the <i>Amazon CloudWatch User Guide</i>.
         * </p>
         * 
         * @param dimensions
         *        The dimensions. If the metric contains multiple dimensions, you must include a value for each
         *        dimension. CloudWatch treats each unique combination of dimensions as a separate metric. You can't
         *        retrieve statistics using combinations of dimensions that were not specially published. You must
         *        specify the same dimensions that were used when the metrics were created. For an example, see <a href=
         *        "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#dimension-combinations"
         *        >Dimension Combinations</a> in the <i>Amazon CloudWatch User Guide</i>. For more information on
         *        specifying dimensions, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html">Publishing
         *        Metrics</a> in the <i>Amazon CloudWatch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<Dimension> dimensions);

        /**
         * <p>
         * The dimensions. If the metric contains multiple dimensions, you must include a value for each dimension.
         * CloudWatch treats each unique combination of dimensions as a separate metric. You can't retrieve statistics
         * using combinations of dimensions that were not specially published. You must specify the same dimensions that
         * were used when the metrics were created. For an example, see <a href=
         * "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#dimension-combinations"
         * >Dimension Combinations</a> in the <i>Amazon CloudWatch User Guide</i>. For more information on specifying
         * dimensions, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html">Publishing
         * Metrics</a> in the <i>Amazon CloudWatch User Guide</i>.
         * </p>
         * 
         * @param dimensions
         *        The dimensions. If the metric contains multiple dimensions, you must include a value for each
         *        dimension. CloudWatch treats each unique combination of dimensions as a separate metric. You can't
         *        retrieve statistics using combinations of dimensions that were not specially published. You must
         *        specify the same dimensions that were used when the metrics were created. For an example, see <a href=
         *        "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#dimension-combinations"
         *        >Dimension Combinations</a> in the <i>Amazon CloudWatch User Guide</i>. For more information on
         *        specifying dimensions, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html">Publishing
         *        Metrics</a> in the <i>Amazon CloudWatch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Dimension... dimensions);

        /**
         * <p>
         * The time stamp that determines the first data point to return. Note that start times are evaluated relative
         * to the time that CloudWatch receives the request.
         * </p>
         * <p>
         * The value specified is inclusive; results include data points with the specified time stamp. The time stamp
         * must be in ISO 8601 UTC format (for example, 2016-10-03T23:00:00Z).
         * </p>
         * <p>
         * CloudWatch rounds the specified time stamp as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Start time less than 15 days ago - Round down to the nearest whole minute. For example, 12:32:34 is rounded
         * down to 12:32:00.
         * </p>
         * </li>
         * <li>
         * <p>
         * Start time between 15 and 63 days ago - Round down to the nearest 5-minute clock interval. For example,
         * 12:32:34 is rounded down to 12:30:00.
         * </p>
         * </li>
         * <li>
         * <p>
         * Start time greater than 63 days ago - Round down to the nearest 1-hour clock interval. For example, 12:32:34
         * is rounded down to 12:00:00.
         * </p>
         * </li>
         * </ul>
         * 
         * @param startTime
         *        The time stamp that determines the first data point to return. Note that start times are evaluated
         *        relative to the time that CloudWatch receives the request.</p>
         *        <p>
         *        The value specified is inclusive; results include data points with the specified time stamp. The time
         *        stamp must be in ISO 8601 UTC format (for example, 2016-10-03T23:00:00Z).
         *        </p>
         *        <p>
         *        CloudWatch rounds the specified time stamp as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Start time less than 15 days ago - Round down to the nearest whole minute. For example, 12:32:34 is
         *        rounded down to 12:32:00.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Start time between 15 and 63 days ago - Round down to the nearest 5-minute clock interval. For
         *        example, 12:32:34 is rounded down to 12:30:00.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Start time greater than 63 days ago - Round down to the nearest 1-hour clock interval. For example,
         *        12:32:34 is rounded down to 12:00:00.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time stamp that determines the last data point to return.
         * </p>
         * <p>
         * The value specified is exclusive; results will include data points up to the specified time stamp. The time
         * stamp must be in ISO 8601 UTC format (for example, 2016-10-10T23:00:00Z).
         * </p>
         * 
         * @param endTime
         *        The time stamp that determines the last data point to return.</p>
         *        <p>
         *        The value specified is exclusive; results will include data points up to the specified time stamp. The
         *        time stamp must be in ISO 8601 UTC format (for example, 2016-10-10T23:00:00Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The granularity, in seconds, of the returned data points. A period can be as short as one minute (60 seconds)
         * and must be a multiple of 60. The default value is 60.
         * </p>
         * <p>
         * If the <code>StartTime</code> parameter specifies a time stamp that is greater than 15 days ago, you must
         * specify the period as follows or no data points in that time range is returned:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).
         * </p>
         * </li>
         * <li>
         * <p>
         * Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).
         * </p>
         * </li>
         * </ul>
         * 
         * @param period
         *        The granularity, in seconds, of the returned data points. A period can be as short as one minute (60
         *        seconds) and must be a multiple of 60. The default value is 60.</p>
         *        <p>
         *        If the <code>StartTime</code> parameter specifies a time stamp that is greater than 15 days ago, you
         *        must specify the period as follows or no data points in that time range is returned:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * <p>
         * The metric statistics, other than percentile. For percentile statistics, use <code>ExtendedStatistic</code>.
         * </p>
         * 
         * @param statistics
         *        The metric statistics, other than percentile. For percentile statistics, use
         *        <code>ExtendedStatistic</code>.
         * @see Statistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Statistic
         */
        Builder statistics(Collection<String> statistics);

        /**
         * <p>
         * The metric statistics, other than percentile. For percentile statistics, use <code>ExtendedStatistic</code>.
         * </p>
         * 
         * @param statistics
         *        The metric statistics, other than percentile. For percentile statistics, use
         *        <code>ExtendedStatistic</code>.
         * @see Statistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Statistic
         */
        Builder statistics(String... statistics);

        /**
         * <p>
         * The metric statistics, other than percentile. For percentile statistics, use <code>ExtendedStatistic</code>.
         * </p>
         * 
         * @param statistics
         *        The metric statistics, other than percentile. For percentile statistics, use
         *        <code>ExtendedStatistic</code>.
         * @see Statistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Statistic
         */
        Builder statistics(Statistic... statistics);

        /**
         * <p>
         * The percentile statistics. Specify values between p0.0 and p100.
         * </p>
         * 
         * @param extendedStatistics
         *        The percentile statistics. Specify values between p0.0 and p100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedStatistics(Collection<String> extendedStatistics);

        /**
         * <p>
         * The percentile statistics. Specify values between p0.0 and p100.
         * </p>
         * 
         * @param extendedStatistics
         *        The percentile statistics. Specify values between p0.0 and p100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedStatistics(String... extendedStatistics);

        /**
         * <p>
         * The unit for a given metric. Metrics may be reported in multiple units. Not supplying a unit results in all
         * units being returned. If the metric only ever reports one unit, specifying a unit has no effect.
         * </p>
         * 
         * @param unit
         *        The unit for a given metric. Metrics may be reported in multiple units. Not supplying a unit results
         *        in all units being returned. If the metric only ever reports one unit, specifying a unit has no
         *        effect.
         * @see StandardUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit for a given metric. Metrics may be reported in multiple units. Not supplying a unit results in all
         * units being returned. If the metric only ever reports one unit, specifying a unit has no effect.
         * </p>
         * 
         * @param unit
         *        The unit for a given metric. Metrics may be reported in multiple units. Not supplying a unit results
         *        in all units being returned. If the metric only ever reports one unit, specifying a unit has no
         *        effect.
         * @see StandardUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardUnit
         */
        Builder unit(StandardUnit unit);
    }

    private static final class BuilderImpl implements Builder {
        private String namespace;

        private String metricName;

        private List<Dimension> dimensions;

        private Instant startTime;

        private Instant endTime;

        private Integer period;

        private List<String> statistics;

        private List<String> extendedStatistics;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricStatisticsRequest model) {
            setNamespace(model.namespace);
            setMetricName(model.metricName);
            setDimensions(model.dimensions);
            setStartTime(model.startTime);
            setEndTime(model.endTime);
            setPeriod(model.period);
            setStatistics(model.statistics);
            setExtendedStatistics(model.extendedStatistics);
            setUnit(model.unit);
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Collection<Dimension> getDimensions() {
            return dimensions;
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        public final void setDimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Integer getPeriod() {
            return period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final Collection<String> getStatistics() {
            return statistics;
        }

        @Override
        public final Builder statistics(Collection<String> statistics) {
            this.statistics = StatisticsCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(String... statistics) {
            statistics(Arrays.asList(statistics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(Statistic... statistics) {
            statistics(Arrays.asList(statistics).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setStatistics(Collection<String> statistics) {
            this.statistics = StatisticsCopier.copy(statistics);
        }

        public final Collection<String> getExtendedStatistics() {
            return extendedStatistics;
        }

        @Override
        public final Builder extendedStatistics(Collection<String> extendedStatistics) {
            this.extendedStatistics = ExtendedStatisticsCopier.copy(extendedStatistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendedStatistics(String... extendedStatistics) {
            extendedStatistics(Arrays.asList(extendedStatistics));
            return this;
        }

        public final void setExtendedStatistics(Collection<String> extendedStatistics) {
            this.extendedStatistics = ExtendedStatisticsCopier.copy(extendedStatistics);
        }

        public final String getUnit() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public GetMetricStatisticsRequest build() {
            return new GetMetricStatisticsRequest(this);
        }
    }
}
