/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetMetricStatisticsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetMetricStatisticsResponse.Builder, GetMetricStatisticsResponse> {
    private final String label;

    private final List<Datapoint> datapoints;

    private GetMetricStatisticsResponse(BuilderImpl builder) {
        this.label = builder.label;
        this.datapoints = builder.datapoints;
    }

    /**
     * <p>
     * A label for the specified metric.
     * </p>
     * 
     * @return A label for the specified metric.
     */
    public String label() {
        return label;
    }

    /**
     * <p>
     * The data points for the specified metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The data points for the specified metric.
     */
    public List<Datapoint> datapoints() {
        return datapoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((label() == null) ? 0 : label().hashCode());
        hashCode = 31 * hashCode + ((datapoints() == null) ? 0 : datapoints().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricStatisticsResponse)) {
            return false;
        }
        GetMetricStatisticsResponse other = (GetMetricStatisticsResponse) obj;
        if (other.label() == null ^ this.label() == null) {
            return false;
        }
        if (other.label() != null && !other.label().equals(this.label())) {
            return false;
        }
        if (other.datapoints() == null ^ this.datapoints() == null) {
            return false;
        }
        if (other.datapoints() != null && !other.datapoints().equals(this.datapoints())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (label() != null) {
            sb.append("Label: ").append(label()).append(",");
        }
        if (datapoints() != null) {
            sb.append("Datapoints: ").append(datapoints()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetMetricStatisticsResponse> {
        /**
         * <p>
         * A label for the specified metric.
         * </p>
         * 
         * @param label
         *        A label for the specified metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * The data points for the specified metric.
         * </p>
         * 
         * @param datapoints
         *        The data points for the specified metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datapoints(Collection<Datapoint> datapoints);

        /**
         * <p>
         * The data points for the specified metric.
         * </p>
         * 
         * @param datapoints
         *        The data points for the specified metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datapoints(Datapoint... datapoints);
    }

    private static final class BuilderImpl implements Builder {
        private String label;

        private List<Datapoint> datapoints;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricStatisticsResponse model) {
            setLabel(model.label);
            setDatapoints(model.datapoints);
        }

        public final String getLabel() {
            return label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Collection<Datapoint> getDatapoints() {
            return datapoints;
        }

        @Override
        public final Builder datapoints(Collection<Datapoint> datapoints) {
            this.datapoints = DatapointsCopier.copy(datapoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datapoints(Datapoint... datapoints) {
            datapoints(Arrays.asList(datapoints));
            return this;
        }

        public final void setDatapoints(Collection<Datapoint> datapoints) {
            this.datapoints = DatapointsCopier.copy(datapoints);
        }

        @Override
        public GetMetricStatisticsResponse build() {
            return new GetMetricStatisticsResponse(this);
        }
    }
}
