/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.Map;
import java.util.HashMap;

import java.util.Map.Entry;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.runtime.transform.MapEntry;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * Datapoint StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DatapointUnmarshaller implements Unmarshaller<Datapoint, StaxUnmarshallerContext> {

    private static class ExtendedStatisticsMapEntryUnmarshaller implements
            Unmarshaller<Map.Entry<String, Double>, StaxUnmarshallerContext> {

        @Override
        public Entry<String, Double> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;

            MapEntry<String, Double> entry = new MapEntry<String, Double>();

            while (true) {
                XMLEvent xmlEvent = context.nextEvent();
                if (xmlEvent.isEndDocument())
                    return entry;

                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("value", targetDepth)) {
                        entry.setValue(DoubleUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                } else if (xmlEvent.isEndElement()) {
                    if (context.getCurrentDepth() < originalDepth)
                        return entry;
                }
            }
        }

        private static final ExtendedStatisticsMapEntryUnmarshaller INSTANCE = new ExtendedStatisticsMapEntryUnmarshaller();

        public static ExtendedStatisticsMapEntryUnmarshaller getInstance() {
            return INSTANCE;
        }

    }

    public Datapoint unmarshall(StaxUnmarshallerContext context) throws Exception {
        Datapoint.Builder datapoint = Datapoint.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.Map<String, Double> extendedStatistics = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                datapoint.extendedStatistics(extendedStatistics);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Timestamp", targetDepth)) {
                    datapoint.timestamp(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("SampleCount", targetDepth)) {
                    datapoint.sampleCount(DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Average", targetDepth)) {
                    datapoint.average(DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Sum", targetDepth)) {
                    datapoint.sum(DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Minimum", targetDepth)) {
                    datapoint.minimum(DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Maximum", targetDepth)) {
                    datapoint.maximum(DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Unit", targetDepth)) {
                    datapoint.unit(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ExtendedStatistics/entry", targetDepth)) {
                    if (extendedStatistics == null) {
                        extendedStatistics = new java.util.HashMap<>();
                    }
                    Entry<String, Double> entry = ExtendedStatisticsMapEntryUnmarshaller.getInstance().unmarshall(context);
                    // datapoint.addExtendedStatisticsEntry(entry.getKey(), entry.getValue());

                    extendedStatistics.put(entry.getKey(), entry.getValue());
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    datapoint.extendedStatistics(extendedStatistics);
                    break;
                }
            }
        }
        return datapoint.build();
    }

    private static final DatapointUnmarshaller INSTANCE = new DatapointUnmarshaller();

    public static DatapointUnmarshaller getInstance() {
        return INSTANCE;
    }
}
