/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * MetricDatum StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class MetricDatumUnmarshaller implements Unmarshaller<MetricDatum, StaxUnmarshallerContext> {

    public MetricDatum unmarshall(StaxUnmarshallerContext context) throws Exception {
        MetricDatum.Builder metricDatum = MetricDatum.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<Dimension> dimensions = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                metricDatum.dimensions(dimensions);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("MetricName", targetDepth)) {
                    metricDatum.metricName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Dimensions", targetDepth)) {
                    dimensions = new ArrayList<Dimension>();
                    continue;
                }

                if (context.testExpression("Dimensions/member", targetDepth)) {
                    dimensions.add(DimensionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Timestamp", targetDepth)) {
                    metricDatum.timestamp(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Value", targetDepth)) {
                    metricDatum.value(DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StatisticValues", targetDepth)) {
                    metricDatum.statisticValues(StatisticSetUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Unit", targetDepth)) {
                    metricDatum.unit(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    metricDatum.dimensions(dimensions);
                    break;
                }
            }
        }
        return metricDatum.build();
    }

    private static final MetricDatumUnmarshaller INSTANCE = new MetricDatumUnmarshaller();

    public static MetricDatumUnmarshaller getInstance() {
        return INSTANCE;
    }
}
