/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * PutMetricDataRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutMetricDataRequestMarshaller implements Marshaller<Request<PutMetricDataRequest>, PutMetricDataRequest> {

    public Request<PutMetricDataRequest> marshall(PutMetricDataRequest putMetricDataRequest) {

        if (putMetricDataRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PutMetricDataRequest> request = new DefaultRequest<PutMetricDataRequest>(putMetricDataRequest, "CloudWatchClient");
        request.addParameter("Action", "PutMetricData");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (putMetricDataRequest.namespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString(putMetricDataRequest.namespace()));
        }

        java.util.List<MetricDatum> metricDataList = putMetricDataRequest.metricData();

        if (metricDataList != null) {
            if (!metricDataList.isEmpty()) {
                int metricDataListIndex = 1;

                for (MetricDatum metricDataListValue : metricDataList) {

                    if (metricDataListValue.metricName() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".MetricName",
                                StringUtils.fromString(metricDataListValue.metricName()));
                    }

                    java.util.List<Dimension> dimensionsList = metricDataListValue.dimensions();

                    if (dimensionsList != null) {
                        if (!dimensionsList.isEmpty()) {
                            int dimensionsListIndex = 1;

                            for (Dimension dimensionsListValue : dimensionsList) {

                                if (dimensionsListValue.name() != null) {
                                    request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions.member."
                                            + dimensionsListIndex + ".Name", StringUtils.fromString(dimensionsListValue.name()));
                                }

                                if (dimensionsListValue.value() != null) {
                                    request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions.member."
                                            + dimensionsListIndex + ".Value", StringUtils.fromString(dimensionsListValue.value()));
                                }
                                dimensionsListIndex++;
                            }
                        } else {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions", "");
                        }
                    }

                    if (metricDataListValue.timestamp() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".Timestamp",
                                StringUtils.fromInstant(metricDataListValue.timestamp()));
                    }

                    if (metricDataListValue.value() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".Value",
                                StringUtils.fromDouble(metricDataListValue.value()));
                    }

                    StatisticSet statisticValues = metricDataListValue.statisticValues();
                    if (statisticValues != null) {

                        if (statisticValues.sampleCount() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.SampleCount",
                                    StringUtils.fromDouble(statisticValues.sampleCount()));
                        }

                        if (statisticValues.sum() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Sum",
                                    StringUtils.fromDouble(statisticValues.sum()));
                        }

                        if (statisticValues.minimum() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Minimum",
                                    StringUtils.fromDouble(statisticValues.minimum()));
                        }

                        if (statisticValues.maximum() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Maximum",
                                    StringUtils.fromDouble(statisticValues.maximum()));
                        }
                    }

                    if (metricDataListValue.unit() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".Unit",
                                StringUtils.fromString(metricDataListValue.unit()));
                    }
                    metricDataListIndex++;
                }
            } else {
                request.addParameter("MetricData", "");
            }
        }

        return request;
    }

}
