/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAlarmHistoryResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeAlarmHistoryResponse.Builder, DescribeAlarmHistoryResponse> {
    private final List<AlarmHistoryItem> alarmHistoryItems;

    private final String nextToken;

    private DescribeAlarmHistoryResponse(BuilderImpl builder) {
        this.alarmHistoryItems = builder.alarmHistoryItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The alarm histories, in JSON format.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The alarm histories, in JSON format.
     */
    public List<AlarmHistoryItem> alarmHistoryItems() {
        return alarmHistoryItems;
    }

    /**
     * <p>
     * The token that marks the start of the next batch of returned results.
     * </p>
     * 
     * @return The token that marks the start of the next batch of returned results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((alarmHistoryItems() == null) ? 0 : alarmHistoryItems().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmHistoryResponse)) {
            return false;
        }
        DescribeAlarmHistoryResponse other = (DescribeAlarmHistoryResponse) obj;
        if (other.alarmHistoryItems() == null ^ this.alarmHistoryItems() == null) {
            return false;
        }
        if (other.alarmHistoryItems() != null && !other.alarmHistoryItems().equals(this.alarmHistoryItems())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (alarmHistoryItems() != null) {
            sb.append("AlarmHistoryItems: ").append(alarmHistoryItems()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeAlarmHistoryResponse> {
        /**
         * <p>
         * The alarm histories, in JSON format.
         * </p>
         * 
         * @param alarmHistoryItems
         *        The alarm histories, in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmHistoryItems(Collection<AlarmHistoryItem> alarmHistoryItems);

        /**
         * <p>
         * The alarm histories, in JSON format.
         * </p>
         * 
         * @param alarmHistoryItems
         *        The alarm histories, in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmHistoryItems(AlarmHistoryItem... alarmHistoryItems);

        /**
         * <p>
         * The token that marks the start of the next batch of returned results.
         * </p>
         * 
         * @param nextToken
         *        The token that marks the start of the next batch of returned results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<AlarmHistoryItem> alarmHistoryItems;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmHistoryResponse model) {
            setAlarmHistoryItems(model.alarmHistoryItems);
            setNextToken(model.nextToken);
        }

        public final Collection<AlarmHistoryItem> getAlarmHistoryItems() {
            return alarmHistoryItems;
        }

        @Override
        public final Builder alarmHistoryItems(Collection<AlarmHistoryItem> alarmHistoryItems) {
            this.alarmHistoryItems = AlarmHistoryItemsCopier.copy(alarmHistoryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmHistoryItems(AlarmHistoryItem... alarmHistoryItems) {
            alarmHistoryItems(Arrays.asList(alarmHistoryItems));
            return this;
        }

        public final void setAlarmHistoryItems(Collection<AlarmHistoryItem> alarmHistoryItems) {
            this.alarmHistoryItems = AlarmHistoryItemsCopier.copy(alarmHistoryItems);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAlarmHistoryResponse build() {
            return new DescribeAlarmHistoryResponse(this);
        }
    }
}
