/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAlarmsForMetricRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeAlarmsForMetricRequest.Builder, DescribeAlarmsForMetricRequest> {
    private final String metricName;

    private final String namespace;

    private final String statistic;

    private final String extendedStatistic;

    private final List<Dimension> dimensions;

    private final Integer period;

    private final String unit;

    private DescribeAlarmsForMetricRequest(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
        this.statistic = builder.statistic;
        this.extendedStatistic = builder.extendedStatistic;
        this.dimensions = builder.dimensions;
        this.period = builder.period;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * 
     * @return The name of the metric.
     */
    public String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The namespace of the metric.
     * </p>
     * 
     * @return The namespace of the metric.
     */
    public String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The statistic for the metric, other than percentiles. For percentile statistics, use
     * <code>ExtendedStatistics</code>.
     * </p>
     * 
     * @return The statistic for the metric, other than percentiles. For percentile statistics, use
     *         <code>ExtendedStatistics</code>.
     * @see Statistic
     */
    public String statistic() {
        return statistic;
    }

    /**
     * <p>
     * The percentile statistic for the metric. Specify a value between p0.0 and p100.
     * </p>
     * 
     * @return The percentile statistic for the metric. Specify a value between p0.0 and p100.
     */
    public String extendedStatistic() {
        return extendedStatistic;
    }

    /**
     * <p>
     * The dimensions associated with the metric. If the metric has any associated dimensions, you must specify them in
     * order for the call to succeed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The dimensions associated with the metric. If the metric has any associated dimensions, you must specify
     *         them in order for the call to succeed.
     */
    public List<Dimension> dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The period, in seconds, over which the statistic is applied.
     * </p>
     * 
     * @return The period, in seconds, over which the statistic is applied.
     */
    public Integer period() {
        return period;
    }

    /**
     * <p>
     * The unit for the metric.
     * </p>
     * 
     * @return The unit for the metric.
     * @see StandardUnit
     */
    public String unit() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((metricName() == null) ? 0 : metricName().hashCode());
        hashCode = 31 * hashCode + ((namespace() == null) ? 0 : namespace().hashCode());
        hashCode = 31 * hashCode + ((statistic() == null) ? 0 : statistic().hashCode());
        hashCode = 31 * hashCode + ((extendedStatistic() == null) ? 0 : extendedStatistic().hashCode());
        hashCode = 31 * hashCode + ((dimensions() == null) ? 0 : dimensions().hashCode());
        hashCode = 31 * hashCode + ((period() == null) ? 0 : period().hashCode());
        hashCode = 31 * hashCode + ((unit() == null) ? 0 : unit().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmsForMetricRequest)) {
            return false;
        }
        DescribeAlarmsForMetricRequest other = (DescribeAlarmsForMetricRequest) obj;
        if (other.metricName() == null ^ this.metricName() == null) {
            return false;
        }
        if (other.metricName() != null && !other.metricName().equals(this.metricName())) {
            return false;
        }
        if (other.namespace() == null ^ this.namespace() == null) {
            return false;
        }
        if (other.namespace() != null && !other.namespace().equals(this.namespace())) {
            return false;
        }
        if (other.statistic() == null ^ this.statistic() == null) {
            return false;
        }
        if (other.statistic() != null && !other.statistic().equals(this.statistic())) {
            return false;
        }
        if (other.extendedStatistic() == null ^ this.extendedStatistic() == null) {
            return false;
        }
        if (other.extendedStatistic() != null && !other.extendedStatistic().equals(this.extendedStatistic())) {
            return false;
        }
        if (other.dimensions() == null ^ this.dimensions() == null) {
            return false;
        }
        if (other.dimensions() != null && !other.dimensions().equals(this.dimensions())) {
            return false;
        }
        if (other.period() == null ^ this.period() == null) {
            return false;
        }
        if (other.period() != null && !other.period().equals(this.period())) {
            return false;
        }
        if (other.unit() == null ^ this.unit() == null) {
            return false;
        }
        if (other.unit() != null && !other.unit().equals(this.unit())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (metricName() != null) {
            sb.append("MetricName: ").append(metricName()).append(",");
        }
        if (namespace() != null) {
            sb.append("Namespace: ").append(namespace()).append(",");
        }
        if (statistic() != null) {
            sb.append("Statistic: ").append(statistic()).append(",");
        }
        if (extendedStatistic() != null) {
            sb.append("ExtendedStatistic: ").append(extendedStatistic()).append(",");
        }
        if (dimensions() != null) {
            sb.append("Dimensions: ").append(dimensions()).append(",");
        }
        if (period() != null) {
            sb.append("Period: ").append(period()).append(",");
        }
        if (unit() != null) {
            sb.append("Unit: ").append(unit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeAlarmsForMetricRequest> {
        /**
         * <p>
         * The name of the metric.
         * </p>
         * 
         * @param metricName
         *        The name of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The namespace of the metric.
         * </p>
         * 
         * @param namespace
         *        The namespace of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The statistic for the metric, other than percentiles. For percentile statistics, use
         * <code>ExtendedStatistics</code>.
         * </p>
         * 
         * @param statistic
         *        The statistic for the metric, other than percentiles. For percentile statistics, use
         *        <code>ExtendedStatistics</code>.
         * @see Statistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Statistic
         */
        Builder statistic(String statistic);

        /**
         * <p>
         * The statistic for the metric, other than percentiles. For percentile statistics, use
         * <code>ExtendedStatistics</code>.
         * </p>
         * 
         * @param statistic
         *        The statistic for the metric, other than percentiles. For percentile statistics, use
         *        <code>ExtendedStatistics</code>.
         * @see Statistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Statistic
         */
        Builder statistic(Statistic statistic);

        /**
         * <p>
         * The percentile statistic for the metric. Specify a value between p0.0 and p100.
         * </p>
         * 
         * @param extendedStatistic
         *        The percentile statistic for the metric. Specify a value between p0.0 and p100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedStatistic(String extendedStatistic);

        /**
         * <p>
         * The dimensions associated with the metric. If the metric has any associated dimensions, you must specify them
         * in order for the call to succeed.
         * </p>
         * 
         * @param dimensions
         *        The dimensions associated with the metric. If the metric has any associated dimensions, you must
         *        specify them in order for the call to succeed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<Dimension> dimensions);

        /**
         * <p>
         * The dimensions associated with the metric. If the metric has any associated dimensions, you must specify them
         * in order for the call to succeed.
         * </p>
         * 
         * @param dimensions
         *        The dimensions associated with the metric. If the metric has any associated dimensions, you must
         *        specify them in order for the call to succeed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Dimension... dimensions);

        /**
         * <p>
         * The period, in seconds, over which the statistic is applied.
         * </p>
         * 
         * @param period
         *        The period, in seconds, over which the statistic is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * <p>
         * The unit for the metric.
         * </p>
         * 
         * @param unit
         *        The unit for the metric.
         * @see StandardUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit for the metric.
         * </p>
         * 
         * @param unit
         *        The unit for the metric.
         * @see StandardUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardUnit
         */
        Builder unit(StandardUnit unit);
    }

    private static final class BuilderImpl implements Builder {
        private String metricName;

        private String namespace;

        private String statistic;

        private String extendedStatistic;

        private List<Dimension> dimensions;

        private Integer period;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmsForMetricRequest model) {
            setMetricName(model.metricName);
            setNamespace(model.namespace);
            setStatistic(model.statistic);
            setExtendedStatistic(model.extendedStatistic);
            setDimensions(model.dimensions);
            setPeriod(model.period);
            setUnit(model.unit);
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getStatistic() {
            return statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(Statistic statistic) {
            this.statistic(statistic.toString());
            return this;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        public final String getExtendedStatistic() {
            return extendedStatistic;
        }

        @Override
        public final Builder extendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
            return this;
        }

        public final void setExtendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
        }

        public final Collection<Dimension> getDimensions() {
            return dimensions;
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        public final void setDimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
        }

        public final Integer getPeriod() {
            return period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final String getUnit() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public DescribeAlarmsForMetricRequest build() {
            return new DescribeAlarmsForMetricRequest(this);
        }
    }
}
