/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the history of a specific alarm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AlarmHistoryItem implements ToCopyableBuilder<AlarmHistoryItem.Builder, AlarmHistoryItem> {
    private final String alarmName;

    private final Instant timestamp;

    private final String historyItemType;

    private final String historySummary;

    private final String historyData;

    private AlarmHistoryItem(BuilderImpl builder) {
        this.alarmName = builder.alarmName;
        this.timestamp = builder.timestamp;
        this.historyItemType = builder.historyItemType;
        this.historySummary = builder.historySummary;
        this.historyData = builder.historyData;
    }

    /**
     * <p>
     * The descriptive name for the alarm.
     * </p>
     * 
     * @return The descriptive name for the alarm.
     */
    public String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * The time stamp for the alarm history item.
     * </p>
     * 
     * @return The time stamp for the alarm history item.
     */
    public Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The type of alarm history item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #historyItemType}
     * will return {@link HistoryItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #historyItemTypeString}.
     * </p>
     * 
     * @return The type of alarm history item.
     * @see HistoryItemType
     */
    public HistoryItemType historyItemType() {
        return HistoryItemType.fromValue(historyItemType);
    }

    /**
     * <p>
     * The type of alarm history item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #historyItemType}
     * will return {@link HistoryItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #historyItemTypeString}.
     * </p>
     * 
     * @return The type of alarm history item.
     * @see HistoryItemType
     */
    public String historyItemTypeString() {
        return historyItemType;
    }

    /**
     * <p>
     * A summary of the alarm history, in text format.
     * </p>
     * 
     * @return A summary of the alarm history, in text format.
     */
    public String historySummary() {
        return historySummary;
    }

    /**
     * <p>
     * Data about the alarm, in JSON format.
     * </p>
     * 
     * @return Data about the alarm, in JSON format.
     */
    public String historyData() {
        return historyData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((alarmName() == null) ? 0 : alarmName().hashCode());
        hashCode = 31 * hashCode + ((timestamp() == null) ? 0 : timestamp().hashCode());
        hashCode = 31 * hashCode + ((historyItemTypeString() == null) ? 0 : historyItemTypeString().hashCode());
        hashCode = 31 * hashCode + ((historySummary() == null) ? 0 : historySummary().hashCode());
        hashCode = 31 * hashCode + ((historyData() == null) ? 0 : historyData().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmHistoryItem)) {
            return false;
        }
        AlarmHistoryItem other = (AlarmHistoryItem) obj;
        if (other.alarmName() == null ^ this.alarmName() == null) {
            return false;
        }
        if (other.alarmName() != null && !other.alarmName().equals(this.alarmName())) {
            return false;
        }
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        if (other.historyItemTypeString() == null ^ this.historyItemTypeString() == null) {
            return false;
        }
        if (other.historyItemTypeString() != null && !other.historyItemTypeString().equals(this.historyItemTypeString())) {
            return false;
        }
        if (other.historySummary() == null ^ this.historySummary() == null) {
            return false;
        }
        if (other.historySummary() != null && !other.historySummary().equals(this.historySummary())) {
            return false;
        }
        if (other.historyData() == null ^ this.historyData() == null) {
            return false;
        }
        if (other.historyData() != null && !other.historyData().equals(this.historyData())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (alarmName() != null) {
            sb.append("AlarmName: ").append(alarmName()).append(",");
        }
        if (timestamp() != null) {
            sb.append("Timestamp: ").append(timestamp()).append(",");
        }
        if (historyItemTypeString() != null) {
            sb.append("HistoryItemType: ").append(historyItemTypeString()).append(",");
        }
        if (historySummary() != null) {
            sb.append("HistorySummary: ").append(historySummary()).append(",");
        }
        if (historyData() != null) {
            sb.append("HistoryData: ").append(historyData()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlarmName":
            return Optional.of(clazz.cast(alarmName()));
        case "Timestamp":
            return Optional.of(clazz.cast(timestamp()));
        case "HistoryItemType":
            return Optional.of(clazz.cast(historyItemTypeString()));
        case "HistorySummary":
            return Optional.of(clazz.cast(historySummary()));
        case "HistoryData":
            return Optional.of(clazz.cast(historyData()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AlarmHistoryItem> {
        /**
         * <p>
         * The descriptive name for the alarm.
         * </p>
         * 
         * @param alarmName
         *        The descriptive name for the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * The time stamp for the alarm history item.
         * </p>
         * 
         * @param timestamp
         *        The time stamp for the alarm history item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The type of alarm history item.
         * </p>
         * 
         * @param historyItemType
         *        The type of alarm history item.
         * @see HistoryItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HistoryItemType
         */
        Builder historyItemType(String historyItemType);

        /**
         * <p>
         * The type of alarm history item.
         * </p>
         * 
         * @param historyItemType
         *        The type of alarm history item.
         * @see HistoryItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HistoryItemType
         */
        Builder historyItemType(HistoryItemType historyItemType);

        /**
         * <p>
         * A summary of the alarm history, in text format.
         * </p>
         * 
         * @param historySummary
         *        A summary of the alarm history, in text format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historySummary(String historySummary);

        /**
         * <p>
         * Data about the alarm, in JSON format.
         * </p>
         * 
         * @param historyData
         *        Data about the alarm, in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historyData(String historyData);
    }

    static final class BuilderImpl implements Builder {
        private String alarmName;

        private Instant timestamp;

        private String historyItemType;

        private String historySummary;

        private String historyData;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmHistoryItem model) {
            alarmName(model.alarmName);
            timestamp(model.timestamp);
            historyItemType(model.historyItemType);
            historySummary(model.historySummary);
            historyData(model.historyData);
        }

        public final String getAlarmName() {
            return alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getHistoryItemType() {
            return historyItemType;
        }

        @Override
        public final Builder historyItemType(String historyItemType) {
            this.historyItemType = historyItemType;
            return this;
        }

        @Override
        public final Builder historyItemType(HistoryItemType historyItemType) {
            this.historyItemType(historyItemType.toString());
            return this;
        }

        public final void setHistoryItemType(String historyItemType) {
            this.historyItemType = historyItemType;
        }

        public final String getHistorySummary() {
            return historySummary;
        }

        @Override
        public final Builder historySummary(String historySummary) {
            this.historySummary = historySummary;
            return this;
        }

        public final void setHistorySummary(String historySummary) {
            this.historySummary = historySummary;
        }

        public final String getHistoryData() {
            return historyData;
        }

        @Override
        public final Builder historyData(String historyData) {
            this.historyData = historyData;
            return this;
        }

        public final void setHistoryData(String historyData) {
            this.historyData = historyData;
        }

        @Override
        public AlarmHistoryItem build() {
            return new AlarmHistoryItem(this);
        }
    }
}
