/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * SetAlarmStateRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SetAlarmStateRequestMarshaller implements Marshaller<Request<SetAlarmStateRequest>, SetAlarmStateRequest> {

    public Request<SetAlarmStateRequest> marshall(SetAlarmStateRequest setAlarmStateRequest) {

        if (setAlarmStateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<SetAlarmStateRequest> request = new DefaultRequest<SetAlarmStateRequest>(setAlarmStateRequest, "CloudWatchClient");
        request.addParameter("Action", "SetAlarmState");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (setAlarmStateRequest.alarmName() != null) {
            request.addParameter("AlarmName", StringUtils.fromString(setAlarmStateRequest.alarmName()));
        }

        if (setAlarmStateRequest.stateValueString() != null) {
            request.addParameter("StateValue", StringUtils.fromString(setAlarmStateRequest.stateValueString()));
        }

        if (setAlarmStateRequest.stateReason() != null) {
            request.addParameter("StateReason", StringUtils.fromString(setAlarmStateRequest.stateReason()));
        }

        if (setAlarmStateRequest.stateReasonData() != null) {
            request.addParameter("StateReasonData", StringUtils.fromString(setAlarmStateRequest.stateReasonData()));
        }

        return request;
    }

}
